/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import javax.enterprise.event.Event;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InOrder;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.ActivityManager;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PerspectiveManagerImpl;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.PanelManager;
import org.uberfire.client.workbench.WorkbenchServicesProxy;
import org.uberfire.client.workbench.events.PerspectiveChange;
import org.uberfire.client.workbench.panels.impl.MultiListWorkbenchPanelPresenter;
import org.uberfire.client.workbench.panels.impl.SimpleWorkbenchPanelPresenter;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.PerspectiveDefinition;
import org.uberfire.workbench.model.Position;
import org.uberfire.workbench.model.impl.PanelDefinitionImpl;
import org.uberfire.workbench.model.impl.PartDefinitionImpl;
import org.uberfire.workbench.model.impl.PerspectiveDefinitionImpl;

@RunWith(value=MockitoJUnitRunner.class)
public class PerspectiveManagerTest {
    @Mock
    PlaceManager placeManager;
    @Mock
    PanelManager panelManager;
    @Mock
    ActivityManager activityManager;
    @Mock
    WorkbenchServicesProxy wbServices;
    @Mock
    Event<PerspectiveChange> perspectiveChangeEvent;
    @InjectMocks
    PerspectiveManagerImpl perspectiveManager;
    private PerspectiveDefinition ozDefinition;
    private PerspectiveActivity oz;
    private ParameterizedCommand<PerspectiveDefinition> doWhenFinished;
    private Command doWhenFinishedSave;

    @Before
    public void setup() {
        this.ozDefinition = new PerspectiveDefinitionImpl(MultiListWorkbenchPanelPresenter.class.getName());
        this.oz = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        Mockito.when((Object)this.oz.getDefaultPerspectiveLayout()).thenReturn((Object)this.ozDefinition);
        Mockito.when((Object)this.oz.getIdentifier()).thenReturn((Object)"oz_perspective");
        Mockito.when((Object)this.oz.isTransient()).thenReturn((Object)true);
        this.doWhenFinished = (ParameterizedCommand)Mockito.mock(ParameterizedCommand.class);
        this.doWhenFinishedSave = (Command)Mockito.mock(Command.class);
        ((WorkbenchServicesProxy)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                Command callback = (Command)invocation.getArguments()[2];
                callback.execute();
                return null;
            }
        }).when((Object)this.wbServices)).save((String)Mockito.any(String.class), (PerspectiveDefinition)Mockito.any(PerspectiveDefinition.class), (Command)Mockito.any(Command.class));
        ((WorkbenchServicesProxy)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                ParameterizedCommand callback = (ParameterizedCommand)invocation.getArguments()[1];
                callback.execute(null);
                return null;
            }
        }).when((Object)this.wbServices)).loadPerspective(Mockito.anyString(), (ParameterizedCommand)Mockito.any(ParameterizedCommand.class));
        Mockito.when((Object)this.panelManager.addWorkbenchPanel((PanelDefinition)Mockito.any(PanelDefinition.class), (PanelDefinition)Mockito.any(PanelDefinition.class), (Position)Mockito.any(Position.class))).thenAnswer((Answer)new Answer<PanelDefinition>(){

            public PanelDefinition answer(InvocationOnMock invocation) {
                return (PanelDefinition)invocation.getArguments()[1];
            }
        });
    }

    @Test
    public void shouldReportNullPerspectiveInitially() throws Exception {
        Assert.assertNull((Object)this.perspectiveManager.getCurrentPerspective());
    }

    @Test
    public void shouldReportNewPerspectiveAsCurrentAfterSwitching() throws Exception {
        this.perspectiveManager.switchToPerspective(this.oz, this.doWhenFinished);
        Assert.assertSame((Object)this.oz, (Object)this.perspectiveManager.getCurrentPerspective());
    }

    @Test
    public void shouldSaveNonTransientPerspectives() throws Exception {
        PerspectiveDefinitionImpl kansasDefinition = new PerspectiveDefinitionImpl(MultiListWorkbenchPanelPresenter.class.getName());
        PerspectiveActivity kansas = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        Mockito.when((Object)kansas.getDefaultPerspectiveLayout()).thenReturn((Object)kansasDefinition);
        Mockito.when((Object)kansas.getIdentifier()).thenReturn((Object)"kansas_perspective");
        Mockito.when((Object)kansas.isTransient()).thenReturn((Object)false);
        this.perspectiveManager.switchToPerspective(kansas, this.doWhenFinished);
        this.perspectiveManager.savePerspectiveState(this.doWhenFinishedSave);
        ((WorkbenchServicesProxy)Mockito.verify((Object)this.wbServices)).save((String)Mockito.eq((Object)"kansas_perspective"), (PerspectiveDefinition)Mockito.eq((Object)kansasDefinition), (Command)Mockito.eq((Object)this.doWhenFinishedSave));
    }

    @Test
    public void shouldNotSaveTransientPerspectives() throws Exception {
        PerspectiveDefinitionImpl kansasDefinition = new PerspectiveDefinitionImpl(MultiListWorkbenchPanelPresenter.class.getName());
        PerspectiveActivity kansas = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        Mockito.when((Object)kansas.getDefaultPerspectiveLayout()).thenReturn((Object)kansasDefinition);
        Mockito.when((Object)kansas.getIdentifier()).thenReturn((Object)"kansas_perspective");
        Mockito.when((Object)kansas.isTransient()).thenReturn((Object)true);
        this.perspectiveManager.switchToPerspective(kansas, this.doWhenFinished);
        this.perspectiveManager.savePerspectiveState(this.doWhenFinishedSave);
        ((WorkbenchServicesProxy)Mockito.verify((Object)this.wbServices, (VerificationMode)Mockito.never())).save((String)Mockito.any(String.class), (PerspectiveDefinition)Mockito.eq((Object)kansasDefinition), (Command)Mockito.any(Command.class));
    }

    @Test
    public void shouldLoadNewNonTransientPerspectiveState() throws Exception {
        Mockito.when((Object)this.oz.isTransient()).thenReturn((Object)false);
        this.perspectiveManager.switchToPerspective(this.oz, this.doWhenFinished);
        ((WorkbenchServicesProxy)Mockito.verify((Object)this.wbServices)).loadPerspective((String)Mockito.eq((Object)"oz_perspective"), (ParameterizedCommand)Mockito.any(ParameterizedCommand.class));
    }

    @Test
    public void shouldNotLoadNewTransientPerspectiveState() throws Exception {
        Mockito.when((Object)this.oz.isTransient()).thenReturn((Object)true);
        this.perspectiveManager.switchToPerspective(this.oz, this.doWhenFinished);
        ((WorkbenchServicesProxy)Mockito.verify((Object)this.wbServices, (VerificationMode)Mockito.never())).loadPerspective((String)Mockito.eq((Object)"oz_perspective"), (ParameterizedCommand)Mockito.any(ParameterizedCommand.class));
    }

    @Test
    public void shouldExecuteCallbackWhenDoneLaunchingPerspective() throws Exception {
        this.perspectiveManager.switchToPerspective(this.oz, this.doWhenFinished);
        ((ParameterizedCommand)Mockito.verify(this.doWhenFinished)).execute((Object)this.ozDefinition);
    }

    @Test
    public void shouldFireEventWhenLaunchingNewPerspective() throws Exception {
        this.perspectiveManager.switchToPerspective(this.oz, this.doWhenFinished);
        ((Event)Mockito.verify(this.perspectiveChangeEvent)).fire(Mockito.refEq((Object)new PerspectiveChange(this.ozDefinition, null, "oz_perspective"), (String[])new String[0]));
    }

    @Test
    public void shouldAddAllPanelsToPanelManager() throws Exception {
        PanelDefinitionImpl westPanel = new PanelDefinitionImpl(MultiListWorkbenchPanelPresenter.class.getName());
        PanelDefinitionImpl eastPanel = new PanelDefinitionImpl(MultiListWorkbenchPanelPresenter.class.getName());
        PanelDefinitionImpl northPanel = new PanelDefinitionImpl(MultiListWorkbenchPanelPresenter.class.getName());
        PanelDefinitionImpl southPanel = new PanelDefinitionImpl(MultiListWorkbenchPanelPresenter.class.getName());
        PanelDefinitionImpl southWestPanel = new PanelDefinitionImpl(MultiListWorkbenchPanelPresenter.class.getName());
        this.ozDefinition.getRoot().appendChild((Position)CompassPosition.WEST, (PanelDefinition)westPanel);
        this.ozDefinition.getRoot().appendChild((Position)CompassPosition.EAST, (PanelDefinition)eastPanel);
        this.ozDefinition.getRoot().appendChild((Position)CompassPosition.NORTH, (PanelDefinition)northPanel);
        this.ozDefinition.getRoot().appendChild((Position)CompassPosition.SOUTH, (PanelDefinition)southPanel);
        southPanel.appendChild((Position)CompassPosition.WEST, (PanelDefinition)southWestPanel);
        Mockito.when((Object)this.panelManager.getRoot()).thenReturn((Object)this.ozDefinition.getRoot());
        this.perspectiveManager.switchToPerspective(this.oz, this.doWhenFinished);
        ((PanelManager)Mockito.verify((Object)this.panelManager)).addWorkbenchPanel(this.ozDefinition.getRoot(), (PanelDefinition)westPanel, (Position)CompassPosition.WEST);
        ((PanelManager)Mockito.verify((Object)this.panelManager)).addWorkbenchPanel(this.ozDefinition.getRoot(), (PanelDefinition)eastPanel, (Position)CompassPosition.EAST);
        ((PanelManager)Mockito.verify((Object)this.panelManager)).addWorkbenchPanel(this.ozDefinition.getRoot(), (PanelDefinition)northPanel, (Position)CompassPosition.NORTH);
        ((PanelManager)Mockito.verify((Object)this.panelManager)).addWorkbenchPanel(this.ozDefinition.getRoot(), (PanelDefinition)southPanel, (Position)CompassPosition.SOUTH);
        ((PanelManager)Mockito.verify((Object)this.panelManager)).addWorkbenchPanel((PanelDefinition)southPanel, (PanelDefinition)southWestPanel, (Position)CompassPosition.WEST);
    }

    @Test
    public void shouldDestroyAllOldPanelsWhenSwitchingRoot() throws Exception {
        PerspectiveDefinitionImpl fooPerspectiveDef = new PerspectiveDefinitionImpl(MultiListWorkbenchPanelPresenter.class.getName());
        PanelDefinition rootPanel = fooPerspectiveDef.getRoot();
        PanelDefinitionImpl fooPanel = new PanelDefinitionImpl(SimpleWorkbenchPanelPresenter.class.getName());
        PanelDefinitionImpl fooChildPanel = new PanelDefinitionImpl(SimpleWorkbenchPanelPresenter.class.getName());
        PanelDefinitionImpl barPanel = new PanelDefinitionImpl(SimpleWorkbenchPanelPresenter.class.getName());
        PanelDefinitionImpl bazPanel = new PanelDefinitionImpl(SimpleWorkbenchPanelPresenter.class.getName());
        rootPanel.appendChild((PanelDefinition)fooPanel);
        rootPanel.appendChild((PanelDefinition)barPanel);
        rootPanel.appendChild((PanelDefinition)bazPanel);
        fooPanel.appendChild((PanelDefinition)fooChildPanel);
        PerspectiveActivity fooPerspective = (PerspectiveActivity)Mockito.mock(PerspectiveActivity.class);
        Mockito.when((Object)fooPerspective.getDefaultPerspectiveLayout()).thenReturn((Object)fooPerspectiveDef);
        Mockito.when((Object)fooPerspective.isTransient()).thenReturn((Object)true);
        this.perspectiveManager.switchToPerspective(fooPerspective, this.doWhenFinished);
        this.perspectiveManager.switchToPerspective(this.oz, this.doWhenFinished);
        ((PanelManager)Mockito.verify((Object)this.panelManager)).removeWorkbenchPanel((PanelDefinition)fooPanel);
        ((PanelManager)Mockito.verify((Object)this.panelManager)).removeWorkbenchPanel((PanelDefinition)fooChildPanel);
        ((PanelManager)Mockito.verify((Object)this.panelManager)).removeWorkbenchPanel((PanelDefinition)barPanel);
        ((PanelManager)Mockito.verify((Object)this.panelManager)).removeWorkbenchPanel((PanelDefinition)bazPanel);
        ((PanelManager)Mockito.verify((Object)this.panelManager, (VerificationMode)Mockito.never())).removeWorkbenchPanel(rootPanel);
    }

    @Test
    @Ignore
    public void shouldLaunchPartsFoundInPanels() throws Exception {
        PartDefinitionImpl rootPart1 = new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest("rootPart1"));
        PartDefinitionImpl southPart1 = new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest("southPart1"));
        PartDefinitionImpl southPart2 = new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest("southPart2"));
        PartDefinitionImpl southWestPart1 = new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest("southWestPart1"));
        PartDefinitionImpl southWestPart2 = new PartDefinitionImpl((PlaceRequest)new DefaultPlaceRequest("southWestPart2"));
        this.ozDefinition.getRoot().addPart((PartDefinition)rootPart1);
        PanelDefinitionImpl southPanel = new PanelDefinitionImpl(MultiListWorkbenchPanelPresenter.class.getName());
        southPanel.addPart((PartDefinition)southPart1);
        southPanel.addPart((PartDefinition)southPart2);
        this.ozDefinition.getRoot().appendChild((Position)CompassPosition.SOUTH, (PanelDefinition)southPanel);
        PanelDefinitionImpl southWestPanel = new PanelDefinitionImpl(MultiListWorkbenchPanelPresenter.class.getName());
        southWestPanel.addPart((PartDefinition)southWestPart1);
        southWestPanel.addPart((PartDefinition)southWestPart2);
        southPanel.appendChild((Position)CompassPosition.WEST, (PanelDefinition)southWestPanel);
        Mockito.when((Object)this.panelManager.getRoot()).thenReturn((Object)this.ozDefinition.getRoot());
        this.perspectiveManager.switchToPerspective(this.oz, this.doWhenFinished);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.placeManager});
        ((PlaceManager)inOrder.verify((Object)this.placeManager)).goTo((PartDefinition)rootPart1, this.ozDefinition.getRoot());
        ((PlaceManager)inOrder.verify((Object)this.placeManager)).goTo((PartDefinition)southPart1, (PanelDefinition)southPanel);
        ((PlaceManager)inOrder.verify((Object)this.placeManager)).goTo((PartDefinition)southPart2, (PanelDefinition)southPanel);
        ((PlaceManager)inOrder.verify((Object)this.placeManager)).goTo((PartDefinition)southWestPart1, (PanelDefinition)southWestPanel);
        ((PlaceManager)inOrder.verify((Object)this.placeManager)).goTo((PartDefinition)southWestPart2, (PanelDefinition)southWestPanel);
    }
}

