/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import javax.inject.Inject;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.client.mvp.AbstractWorkbenchActivity;
import org.uberfire.client.mvp.EditorLockManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.WorkbenchEditorActivity;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;

public abstract class AbstractWorkbenchEditorActivity
extends AbstractWorkbenchActivity
implements WorkbenchEditorActivity {
    @Inject
    private EditorLockManager lockManager;
    protected ObservablePath path;

    public AbstractWorkbenchEditorActivity(PlaceManager placeManager) {
        super(placeManager);
    }

    @Override
    public final void onStartup(PlaceRequest place) {
        if (place instanceof PathPlaceRequest) {
            this.onStartup(((PathPlaceRequest)place).getPath(), place);
        } else {
            super.onStartup(place);
        }
    }

    @Override
    public void onStartup(ObservablePath path, PlaceRequest place) {
        super.onStartup(place);
        this.path = path;
        this.lockManager.init(this);
    }

    @Override
    public void onOpen() {
        super.onOpen();
        if (this.path != null) {
            this.lockManager.acquireLockOnDemand();
        }
    }

    @Override
    public void onSave() {
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void onClose() {
        this.lockManager.releaseLock();
        super.onClose();
    }

    @Override
    public void onFocus() {
        super.onFocus();
        this.lockManager.onFocus();
    }

    public ObservablePath getPath() {
        return this.path;
    }

    public boolean isOpen() {
        return this.open;
    }
}

