/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.History;
import com.google.web.bindery.event.shared.EventBus;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceRequestHistoryMapper;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@Dependent
public class PlaceHistoryHandler {
    private static final Logger log = Logger.getLogger(PlaceHistoryHandler.class.getName());
    private final Historian historian;
    @Inject
    private PlaceRequestHistoryMapper mapper;
    private PlaceManager placeManager;
    private PlaceRequest defaultPlaceRequest = PlaceRequest.NOWHERE;

    public PlaceHistoryHandler() {
        this.historian = (Historian)GWT.create(DefaultHistorian.class);
    }

    public void handleCurrentHistory() {
        this.handleHistoryToken(this.historian.getToken());
    }

    public com.google.web.bindery.event.shared.HandlerRegistration register(PlaceManager placeManager, EventBus eventBus, PlaceRequest defaultPlaceRequest) {
        this.placeManager = placeManager;
        this.defaultPlaceRequest = defaultPlaceRequest;
        HandlerRegistration historyReg = this.historian.addValueChangeHandler(new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                String token = (String)event.getValue();
                PlaceHistoryHandler.this.handleHistoryToken(token);
            }
        });
        return new com.google.web.bindery.event.shared.HandlerRegistration((com.google.web.bindery.event.shared.HandlerRegistration)historyReg){
            final /* synthetic */ com.google.web.bindery.event.shared.HandlerRegistration val$historyReg;
            {
                this.val$historyReg = handlerRegistration;
            }

            public void removeHandler() {
                PlaceHistoryHandler.this.defaultPlaceRequest = DefaultPlaceRequest.NOWHERE;
                PlaceHistoryHandler.this.placeManager = null;
                this.val$historyReg.removeHandler();
            }
        };
    }

    public void onPlaceChange(PlaceRequest placeRequest) {
        if (placeRequest.isUpdateLocationBarAllowed()) {
            this.historian.newItem(this.tokenForPlace(placeRequest), false);
        }
    }

    Logger log() {
        return log;
    }

    private void handleHistoryToken(String token) {
        PlaceRequest newPlaceRequest = null;
        if ("".equals(token)) {
            newPlaceRequest = this.defaultPlaceRequest;
        }
        if (newPlaceRequest == null) {
            newPlaceRequest = this.mapper.getPlaceRequest(token);
        }
        if (newPlaceRequest == null) {
            this.log().warning("Unrecognized history token: " + token);
            newPlaceRequest = this.defaultPlaceRequest;
        }
        this.placeManager.goTo(newPlaceRequest);
    }

    private String tokenForPlace(PlaceRequest newPlaceRequest) {
        if (this.defaultPlaceRequest.equals(newPlaceRequest)) {
            return "";
        }
        return newPlaceRequest.getFullIdentifier();
    }

    public static interface Historian {
        public HandlerRegistration addValueChangeHandler(ValueChangeHandler<String> var1);

        public String getToken();

        public void newItem(String var1, boolean var2);
    }

    public static class DefaultHistorian
    implements Historian {
        @Override
        public HandlerRegistration addValueChangeHandler(ValueChangeHandler<String> valueChangeHandler) {
            return History.addValueChangeHandler(valueChangeHandler);
        }

        @Override
        public String getToken() {
            return History.getToken();
        }

        @Override
        public void newItem(String token, boolean issueEvent) {
            History.newItem((String)token, (boolean)issueEvent);
        }
    }
}

