/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench;

import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.HeaderPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.SimpleLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.uberfire.client.util.Layouts;
import org.uberfire.client.workbench.Footer;
import org.uberfire.client.workbench.Header;
import org.uberfire.client.workbench.WorkbenchLayout;
import org.uberfire.client.workbench.widgets.dnd.WorkbenchDragAndDropManager;
import org.uberfire.client.workbench.widgets.dnd.WorkbenchPickupDragController;

@ApplicationScoped
public class WorkbenchLayoutImpl
implements WorkbenchLayout {
    private static final int MAXIMIZED_PANEL_Z_INDEX = 100;
    @Inject
    private HeaderPanel root;
    private final SimpleLayoutPanel perspectiveRootContainer = new SimpleLayoutPanel();
    private final Panel headerPanel = new FlowPanel();
    private final Panel footerPanel = new FlowPanel();
    @Inject
    private WorkbenchDragAndDropManager dndManager;
    @Inject
    private WorkbenchPickupDragController dragController;
    private final Map<Widget, OriginalStyleInfo> maximizedWidgetOriginalStyles = new HashMap<Widget, OriginalStyleInfo>();

    @PostConstruct
    private void init() {
        this.perspectiveRootContainer.ensureDebugId("perspectiveRootContainer");
        this.headerPanel.ensureDebugId("workbenchHeaderPanel");
        this.footerPanel.ensureDebugId("workbenchFooterPanel");
        this.dragController.getBoundaryPanel().ensureDebugId("workbenchDragBoundary");
    }

    public HeaderPanel getRoot() {
        return this.root;
    }

    @Override
    public HasWidgets getPerspectiveContainer() {
        return this.perspectiveRootContainer;
    }

    @Override
    public void setHeaderContents(List<Header> headers) {
        this.headerPanel.clear();
        this.root.remove((Widget)this.headerPanel);
        if (!headers.isEmpty()) {
            for (Header h : headers) {
                this.headerPanel.add((IsWidget)h);
            }
            this.root.setHeaderWidget((Widget)this.headerPanel);
        }
    }

    @Override
    public void setFooterContents(List<Footer> footers) {
        this.footerPanel.clear();
        this.root.remove((Widget)this.footerPanel);
        if (!footers.isEmpty()) {
            for (Footer f : footers) {
                this.footerPanel.add((IsWidget)f);
            }
            this.root.setFooterWidget((Widget)this.footerPanel);
        }
    }

    @Override
    public void onBootstrap() {
        this.dndManager.unregisterDropControllers();
        AbsolutePanel dragBoundary = this.dragController.getBoundaryPanel();
        dragBoundary.add((Widget)this.perspectiveRootContainer);
        Layouts.setToFillParent((Widget)this.perspectiveRootContainer);
        Layouts.setToFillParent((Widget)dragBoundary);
        this.root.setContentWidget((Widget)dragBoundary);
    }

    @Override
    public void onResize() {
        this.resizeTo(Window.getClientWidth(), Window.getClientHeight());
    }

    @Override
    public void resizeTo(int width, int height) {
        this.root.setPixelSize(width, height);
        this.perspectiveRootContainer.onResize();
        new Timer(){

            public void run() {
                WorkbenchLayoutImpl.this.updateMaximizedPanelSizes();
            }
        }.schedule(5);
    }

    private void updateMaximizedPanelSizes() {
        for (Widget w : this.maximizedWidgetOriginalStyles.keySet()) {
            Style style = w.getElement().getStyle();
            style.setTop((double)this.perspectiveRootContainer.getAbsoluteTop(), Style.Unit.PX);
            style.setLeft((double)this.perspectiveRootContainer.getAbsoluteLeft(), Style.Unit.PX);
            style.setWidth((double)this.perspectiveRootContainer.getOffsetWidth(), Style.Unit.PX);
            style.setHeight((double)this.perspectiveRootContainer.getOffsetHeight(), Style.Unit.PX);
            if (!(w instanceof RequiresResize)) continue;
            ((RequiresResize)w).onResize();
        }
    }

    @Override
    public void maximize(Widget w) {
        if (this.maximizedWidgetOriginalStyles.get(w) != null) {
            return;
        }
        w.addStyleName("uf-maximized-panel");
        Style style = w.getElement().getStyle();
        OriginalStyleInfo backup = new OriginalStyleInfo();
        backup.setPosition(style.getPosition());
        style.setPosition(Style.Position.FIXED);
        backup.setTop(style.getTop());
        style.setTop((double)this.perspectiveRootContainer.getAbsoluteTop(), Style.Unit.PX);
        backup.setLeft(style.getLeft());
        style.setLeft((double)this.perspectiveRootContainer.getAbsoluteLeft(), Style.Unit.PX);
        backup.setWidth(style.getWidth());
        style.setWidth((double)this.perspectiveRootContainer.getOffsetWidth(), Style.Unit.PX);
        backup.setHeight(style.getHeight());
        style.setHeight((double)this.perspectiveRootContainer.getOffsetHeight(), Style.Unit.PX);
        backup.setZIndex(style.getZIndex());
        style.setZIndex(100);
        this.maximizedWidgetOriginalStyles.put(w, backup);
        if (w instanceof RequiresResize) {
            ((RequiresResize)w).onResize();
        }
    }

    @Override
    public void unmaximize(Widget w) {
        w.removeStyleName("uf-maximized-panel");
        OriginalStyleInfo originalStyleInfo = this.maximizedWidgetOriginalStyles.remove(w);
        if (originalStyleInfo != null) {
            originalStyleInfo.restore(w);
        }
        if (w instanceof RequiresResize) {
            ((RequiresResize)w).onResize();
        }
    }

    public class OriginalStyleInfo {
        private String position;
        private String top;
        private String left;
        private String width;
        private String height;
        private String zIndex;

        public void restore(Widget w) {
            Style style = w.getElement().getStyle();
            style.setProperty("position", this.position);
            style.setProperty("top", this.top);
            style.setProperty("left", this.left);
            style.setProperty("width", this.width);
            style.setProperty("height", this.height);
            style.setProperty("zIndex", this.zIndex);
        }

        public String getPosition() {
            return this.position;
        }

        public void setPosition(String position) {
            this.position = position;
        }

        public String getTop() {
            return this.top;
        }

        public void setTop(String top) {
            this.top = top;
        }

        public String getLeft() {
            return this.left;
        }

        public void setLeft(String left) {
            this.left = left;
        }

        public String getWidth() {
            return this.width;
        }

        public void setWidth(String width) {
            this.width = width;
        }

        public String getHeight() {
            return this.height;
        }

        public void setHeight(String height) {
            this.height = height;
        }

        public String getZIndex() {
            return this.zIndex;
        }

        public void setZIndex(String zIndex) {
            this.zIndex = zIndex;
        }
    }
}

