/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.panels.impl;

import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import java.util.IdentityHashMap;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.uberfire.client.mvp.TemplatedActivity;
import org.uberfire.client.workbench.WorkbenchLayout;
import org.uberfire.client.workbench.panels.WorkbenchPanelView;
import org.uberfire.client.workbench.panels.impl.TemplatedWorkbenchPanelPresenter;
import org.uberfire.client.workbench.part.WorkbenchPartPresenter;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.workbench.model.NamedPosition;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.Position;

@Dependent
@Named(value="TemplatedWorkbenchPanelView")
public class TemplatedWorkbenchPanelView
implements WorkbenchPanelView<TemplatedWorkbenchPanelPresenter> {
    private TemplatedWorkbenchPanelPresenter presenter;
    private TemplatedActivity activity;
    private String elementId;
    private final IdentityHashMap<WorkbenchPanelView<?>, NamedPosition> childPanelPositions = new IdentityHashMap();
    @Inject
    private WorkbenchLayout workbenchLayout;

    public void init(TemplatedWorkbenchPanelPresenter presenter) {
        this.presenter = presenter;
    }

    public void setActivity(TemplatedActivity activity) {
        this.activity = (TemplatedActivity)PortablePreconditions.checkNotNull((String)"activity", (Object)activity);
        this.setElementId(this.elementId);
    }

    public Widget asWidget() {
        if (this.activity == null) {
            return null;
        }
        return this.activity.getRootWidget().asWidget();
    }

    public void onResize() {
        Widget root = this.asWidget();
        if (root instanceof RequiresResize) {
            ((RequiresResize)root).onResize();
        }
    }

    @Override
    public TemplatedWorkbenchPanelPresenter getPresenter() {
        return this.presenter;
    }

    @Override
    public void addPanel(PanelDefinition panel, WorkbenchPanelView<?> view, Position p) {
        NamedPosition position = (NamedPosition)p;
        HasWidgets panelContainer = this.activity.resolvePosition(position);
        if (panelContainer.iterator().hasNext()) {
            throw new IllegalStateException("Child position " + position + " is already occupied");
        }
        panelContainer.add(view.asWidget());
        this.childPanelPositions.put(view, position);
    }

    @Override
    public boolean removePanel(WorkbenchPanelView<?> child) {
        NamedPosition removedFromPosition = this.childPanelPositions.remove(child);
        if (removedFromPosition == null) {
            return false;
        }
        HasWidgets panelContainer = this.activity.resolvePosition(removedFromPosition);
        panelContainer.clear();
        return true;
    }

    @Override
    public void setFocus(boolean hasFocus) {
    }

    @Override
    public void addPart(WorkbenchPartPresenter.View view) {
        throw new UnsupportedOperationException("This view doesn't support parts");
    }

    @Override
    public void changeTitle(PartDefinition part, String title, IsWidget titleDecoration) {
        throw new UnsupportedOperationException("This view doesn't support parts");
    }

    @Override
    public boolean selectPart(PartDefinition part) {
        throw new UnsupportedOperationException("This view doesn't support parts");
    }

    @Override
    public boolean removePart(PartDefinition part) {
        throw new UnsupportedOperationException("This view doesn't support parts");
    }

    @Override
    public Widget getPartDropRegion() {
        return null;
    }

    @Override
    public void setElementId(String elementId) {
        this.elementId = elementId;
        if (this.asWidget() != null && elementId != null) {
            this.asWidget().getElement().setAttribute("id", elementId);
        }
    }

    @Override
    public void maximize() {
        this.workbenchLayout.maximize(this.asWidget());
    }

    @Override
    public void unmaximize() {
        this.workbenchLayout.unmaximize(this.asWidget());
    }
}

