/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.widgets.dnd;

import com.allen_sauer.gwt.dnd.client.DragContext;
import com.allen_sauer.gwt.dnd.client.PickupDragController;
import com.allen_sauer.gwt.dnd.client.util.DOMUtil;
import com.allen_sauer.gwt.dnd.client.util.DragClientBundle;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.uberfire.client.resources.WorkbenchResources;
import org.uberfire.client.workbench.part.WorkbenchPartPresenter;
import org.uberfire.client.workbench.widgets.dnd.WorkbenchDragAndDropManager;
import org.uberfire.client.workbench.widgets.dnd.WorkbenchDragContext;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PartDefinition;

@ApplicationScoped
public class WorkbenchPickupDragController
extends PickupDragController {
    private final Image dragProxy = new Image(WorkbenchResources.INSTANCE.images().workbenchPanelDragProxy());
    @Inject
    private WorkbenchDragAndDropManager dndManager;

    public WorkbenchPickupDragController() {
        super(new AbsolutePanel(), false);
        this.setBehaviorDragProxy(true);
        this.setBehaviorDragStartSensitivity(1);
    }

    public void dragStart() {
        WorkbenchPartPresenter.View sourceView = (WorkbenchPartPresenter.View)this.context.selectedWidgets.get(0);
        PartDefinition sourcePart = sourceView.getPresenter().getDefinition();
        PanelDefinition sourcePanel = sourceView.getPresenter().getDefinition().getParentPanel();
        PlaceRequest place = sourcePart.getPlace();
        String title = sourceView.getPresenter().getTitle();
        IsWidget titleDecoration = sourceView.getPresenter().getTitleDecoration();
        String contextId = sourceView.getPresenter().getContextId();
        IsWidget widget = sourceView.getPresenter().getPartView().getWrappedWidget();
        Integer height = sourcePanel.getHeight();
        Integer width = sourcePanel.getWidth();
        Integer minHeight = sourcePanel.getMinHeight();
        Integer minWidth = sourcePanel.getMinWidth();
        WorkbenchDragContext context = new WorkbenchDragContext(place, sourcePart, sourcePanel, sourceView.getPresenter().getMenus(), title, titleDecoration, widget, contextId, height, width, minHeight, minWidth);
        this.dndManager.setWorkbenchContext(context);
        super.dragStart();
        Widget movablePanel = this.getMoveablePanel();
        if (movablePanel != null) {
            DOMUtil.fastSetElementPosition((Element)movablePanel.getElement(), (int)this.context.mouseX, (int)this.context.mouseY);
        }
    }

    public void dragMove() {
        super.dragMove();
        Widget movablePanel = this.getMoveablePanel();
        if (movablePanel != null) {
            DOMUtil.fastSetElementPosition((Element)movablePanel.getElement(), (int)this.context.mouseX, (int)this.context.mouseY);
        }
    }

    protected Widget newDragProxy(DragContext context) {
        AbsolutePanel container = new AbsolutePanel();
        container.getElement().getStyle().setProperty("overflow", "visible");
        container.getElement().getStyle().setOpacity(0.75);
        container.getElement().getStyle().setZIndex(Integer.MAX_VALUE);
        int offsetX = 0 - (int)((double)this.dragProxy.getWidth() * 0.5);
        int offsetY = 0 - (int)((double)this.dragProxy.getHeight() * 1.5);
        container.add((Widget)this.dragProxy, offsetX, offsetY);
        return container;
    }

    private Widget getMoveablePanel() {
        for (int index = 0; index < this.context.boundaryPanel.getWidgetCount(); ++index) {
            Widget w = this.context.boundaryPanel.getWidget(index);
            if (!w.getStyleName().equals(DragClientBundle.INSTANCE.css().movablePanel())) continue;
            return w;
        }
        return null;
    }
}

