/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.Event;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.Dependent;

@Dependent
public class LockDemandDetector {
    private static final List<String> TAG_CLICK_LOCK_EXCLUSIONS = Arrays.asList("a", "select", "table", "tbody", "tfoot", "td", "tr");

    public boolean isLockRequired(Event event) {
        Element target = Element.as((JavaScriptObject)event.getEventTarget());
        String lockAttribute = this.findLockAttribute(target);
        if (lockAttribute != null && !lockAttribute.isEmpty()) {
            return Boolean.parseBoolean(lockAttribute);
        }
        boolean eventExcluded = event.getTypeInt() == 1 && TAG_CLICK_LOCK_EXCLUSIONS.contains(target.getTagName().toLowerCase());
        return !eventExcluded;
    }

    public int getLockDemandEventTypes() {
        return 1921;
    }

    private String findLockAttribute(Element element) {
        if (element == null) {
            return null;
        }
        String lockAttribute = element.getAttribute("data-uf-lock");
        if (lockAttribute != null && !lockAttribute.isEmpty()) {
            return lockAttribute;
        }
        return this.findLockAttribute(element.getParentElement());
    }
}

