/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.panels.impl;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.SimpleLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.uberfire.client.util.Layouts;
import org.uberfire.client.workbench.BeanFactory;
import org.uberfire.client.workbench.panels.DockingWorkbenchPanelView;
import org.uberfire.client.workbench.panels.WorkbenchPanelPresenter;
import org.uberfire.client.workbench.panels.WorkbenchPanelView;
import org.uberfire.client.workbench.panels.impl.AbstractWorkbenchPanelView;
import org.uberfire.client.workbench.widgets.dnd.WorkbenchDragAndDropManager;
import org.uberfire.client.workbench.widgets.listbar.ResizeFlowPanel;
import org.uberfire.client.workbench.widgets.split.WorkbenchSplitLayoutPanel;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.Position;

public abstract class AbstractDockingWorkbenchPanelView<P extends WorkbenchPanelPresenter>
extends AbstractWorkbenchPanelView<P>
implements DockingWorkbenchPanelView<P> {
    private final IdentityHashMap<WorkbenchPanelView<?>, WorkbenchSplitLayoutPanel> viewSplitters = new IdentityHashMap();
    @Inject
    protected WorkbenchDragAndDropManager dndManager;
    @Inject
    protected BeanFactory factory;
    @Inject
    private SimpleLayoutPanel topLevelWidget;
    @Inject
    private ResizeFlowPanel partViewContainer;

    @PostConstruct
    void setupDockingPanel() {
        this.initWidget((Widget)this.topLevelWidget);
        this.topLevelWidget.add((Widget)this.partViewContainer);
        Layouts.setToFillParent((Widget)this.topLevelWidget);
        Layouts.setToFillParent((Widget)this.partViewContainer);
        if (this.getPartDropRegion() != null) {
            this.dndManager.registerDropController(this, this.factory.newDropController(this));
        }
    }

    @PreDestroy
    private void tearDownDockingPanel() {
        if (this.getPartDropRegion() != null) {
            this.dndManager.unregisterDropController(this);
        }
    }

    public final Widget getWidget() {
        return this.topLevelWidget;
    }

    protected ResizeFlowPanel getPartViewContainer() {
        return this.partViewContainer;
    }

    @Override
    public Widget getPartDropRegion() {
        return this.getPartViewContainer();
    }

    @Override
    public void setElementId(String elementId) {
        if (elementId == null) {
            this.getPartViewContainer().getElement().removeAttribute("id");
        } else {
            this.getPartViewContainer().getElement().setAttribute("id", elementId);
        }
    }

    @Override
    public void addPanel(PanelDefinition childPanelDef, WorkbenchPanelView<?> childPanelView, Position childPosition) {
        Integer myMinSize;
        PortablePreconditions.checkNotNull((String)"childPanelView", childPanelView);
        CompassPosition position = (CompassPosition)PortablePreconditions.checkNotNull((String)"childPosition", (Object)childPosition);
        if (this.viewSplitters.get(position) != null) {
            throw new IllegalStateException("This panel already has a " + position + " child");
        }
        WorkbenchSplitLayoutPanel splitPanel = new WorkbenchSplitLayoutPanel();
        splitPanel.add(childPanelView.asWidget(), position, Layouts.widthOrHeight(position, childPanelDef));
        Widget partContainerParent = this.partViewContainer.getParent();
        splitPanel.add((Widget)this.partViewContainer);
        ((HasWidgets)partContainerParent).add((Widget)splitPanel);
        Integer childMinSize = AbstractDockingWorkbenchPanelView.minWidthOrHeight(position, childPanelDef);
        if (childMinSize != null) {
            splitPanel.setWidgetMinSize(childPanelView.asWidget(), childMinSize);
        }
        if ((myMinSize = AbstractDockingWorkbenchPanelView.minWidthOrHeight(position, this.getPresenter().getDefinition())) != null) {
            splitPanel.setWidgetMinSize((Widget)splitPanel, myMinSize);
        }
        this.viewSplitters.put(childPanelView, splitPanel);
        AbstractDockingWorkbenchPanelView.scheduleResize((RequiresResize)splitPanel);
    }

    @Override
    public boolean removePanel(WorkbenchPanelView<?> childView) {
        CompassPosition removalPosition = this.positionOf(childView);
        if (removalPosition == null) {
            System.out.println("  remove failed - no such child view");
            return false;
        }
        WorkbenchSplitLayoutPanel splitter = this.viewSplitters.remove(childView);
        splitter.remove(childView.asWidget());
        Widget orphan = null;
        Iterator<Map.Entry<WorkbenchPanelView<?>, WorkbenchSplitLayoutPanel>> iterator = splitter.iterator();
        while (iterator.hasNext()) {
            Widget w = (Widget)iterator.next();
            if (orphan != null) {
                System.out.println("  splitter@" + System.identityHashCode((Object)splitter) + " LOSING ORPHAN: " + splitter.getWidgetDirection(w) + " - " + w);
            }
            orphan = w;
        }
        if (this.topLevelWidget.getWidget() == splitter) {
            if (orphan != null) {
                this.topLevelWidget.setWidget(orphan);
            }
        } else {
            for (Map.Entry<WorkbenchPanelView<?>, WorkbenchSplitLayoutPanel> ent : this.viewSplitters.entrySet()) {
                WorkbenchSplitLayoutPanel sp = ent.getValue();
                if (sp.getWidgetIndex((Widget)splitter) < 0) continue;
                DockLayoutPanel.Direction d = sp.getWidgetDirection((Widget)splitter);
                Double size = sp.getWidgetSize((Widget)splitter);
                sp.remove((Widget)splitter);
                if (orphan == null) continue;
                sp.insert(orphan, d, size, null);
            }
        }
        AbstractDockingWorkbenchPanelView.scheduleResize(this.partViewContainer);
        return true;
    }

    private static CompassPosition toPosition(DockLayoutPanel.Direction d) {
        if (d == null) {
            return null;
        }
        switch (d) {
            case NORTH: {
                return CompassPosition.NORTH;
            }
            case SOUTH: {
                return CompassPosition.SOUTH;
            }
            case EAST: 
            case LINE_START: {
                return CompassPosition.WEST;
            }
            case WEST: 
            case LINE_END: {
                return CompassPosition.EAST;
            }
        }
        throw new IllegalArgumentException("Unknown direction: " + d);
    }

    private CompassPosition positionOf(WorkbenchPanelView<?> childView) {
        WorkbenchSplitLayoutPanel splitter = this.viewSplitters.get(childView);
        if (splitter == null) {
            return null;
        }
        DockLayoutPanel.Direction widgetDirection = splitter.getWidgetDirection(childView.asWidget());
        if (widgetDirection == null) {
            throw new AssertionError((Object)"Found child in splitter map but not in the splitter itself");
        }
        return AbstractDockingWorkbenchPanelView.toPosition(widgetDirection);
    }

    @Override
    public boolean setChildSize(WorkbenchPanelView<?> childPanel, int size) {
        WorkbenchSplitLayoutPanel splitPanel = this.viewSplitters.get(childPanel);
        if (splitPanel != null) {
            PanelDefinition definition = this.getPresenter().getDefinition();
            CompassPosition childPosition = this.positionOf(childPanel);
            Integer childMinSize = AbstractDockingWorkbenchPanelView.minWidthOrHeight(childPosition, definition);
            Integer myMinSize = AbstractDockingWorkbenchPanelView.minWidthOrHeight(childPosition, this.getPresenter().getDefinition());
            int mySize = AbstractDockingWorkbenchPanelView.getWidthOrHeight(childPosition, this.asWidget());
            if (childMinSize != null) {
                size = Math.max(size, childMinSize);
            }
            if (myMinSize != null) {
                size = Math.min(size, mySize - myMinSize);
            }
            splitPanel.setWidgetSize(childPanel.asWidget(), size);
            return true;
        }
        return false;
    }

    static int initialWidthOrHeight(CompassPosition position, PanelDefinition definition, Widget parent) {
        int availableSize;
        Integer requestedSize;
        switch (position) {
            case NORTH: 
            case SOUTH: {
                requestedSize = definition.getHeight();
                availableSize = parent.getOffsetHeight();
                break;
            }
            case EAST: 
            case WEST: {
                requestedSize = definition.getWidth();
                availableSize = parent.getOffsetWidth();
                break;
            }
            default: {
                throw new IllegalArgumentException("Position " + position + " has no horizontal or vertial aspect.");
            }
        }
        if (requestedSize == null || requestedSize <= 0) {
            return availableSize / 2;
        }
        return requestedSize;
    }

    static Integer minWidthOrHeight(CompassPosition position, PanelDefinition definition) {
        switch (position) {
            case NORTH: 
            case SOUTH: {
                return definition.getMinHeight();
            }
            case EAST: 
            case WEST: {
                return definition.getMinWidth();
            }
        }
        throw new IllegalArgumentException("Position " + position + " has no horizontal or vertial aspect.");
    }

    private static int getWidthOrHeight(CompassPosition position, Widget w) {
        switch (position) {
            case NORTH: 
            case SOUTH: {
                return w.getOffsetHeight();
            }
            case EAST: 
            case WEST: {
                return w.getOffsetWidth();
            }
        }
        throw new IllegalArgumentException("Position " + position + " has no horizontal or vertial aspect.");
    }

    private static void scheduleResize(final RequiresResize widget) {
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                widget.onResize();
            }
        });
    }

    @Override
    public void maximize() {
        this.layoutSelection.get().maximize((Widget)this.getPartViewContainer());
    }

    @Override
    public void unmaximize() {
        this.layoutSelection.get().unmaximize((Widget)this.getPartViewContainer());
    }
}

