/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.menu;

import java.util.List;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.security.authz.ResourceActionRef;
import org.uberfire.workbench.model.menu.MenuCustom;
import org.uberfire.workbench.model.menu.MenuGroup;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuItemCommand;
import org.uberfire.workbench.model.menu.MenuItemPerspective;
import org.uberfire.workbench.model.menu.MenuItemPlain;
import org.uberfire.workbench.model.menu.MenuVisitor;
import org.uberfire.workbench.model.menu.Menus;

public class AuthFilterMenuVisitor
implements MenuVisitor {
    private final AuthorizationManager authzManager;
    private final User user;
    private final MenuVisitor chainedVisitor;

    public AuthFilterMenuVisitor(AuthorizationManager authzManager, User user, MenuVisitor chainedVisitor) {
        this.authzManager = (AuthorizationManager)PortablePreconditions.checkNotNull((String)"authzManager", (Object)authzManager);
        this.user = (User)PortablePreconditions.checkNotNull((String)"user", (Object)user);
        this.chainedVisitor = (MenuVisitor)PortablePreconditions.checkNotNull((String)"chainedVisitor", (Object)chainedVisitor);
    }

    public boolean visitEnter(Menus menus) {
        return this.chainedVisitor.visitEnter(menus);
    }

    public void visitLeave(Menus menus) {
        this.chainedVisitor.visitLeave(menus);
    }

    public boolean visitEnter(MenuGroup menuGroup) {
        if (!this.authorize((MenuItem)menuGroup)) {
            return false;
        }
        return this.chainedVisitor.visitEnter(menuGroup);
    }

    public void visitLeave(MenuGroup menuGroup) {
        this.chainedVisitor.visitLeave(menuGroup);
    }

    public void visit(MenuItemPlain menuItemPlain) {
        if (this.authorize((MenuItem)menuItemPlain)) {
            this.chainedVisitor.visit(menuItemPlain);
        }
    }

    public void visit(MenuItemCommand menuItemCommand) {
        if (this.authorize((MenuItem)menuItemCommand)) {
            this.chainedVisitor.visit(menuItemCommand);
        }
    }

    public void visit(MenuCustom<?> menuCustom) {
        if (this.authorize((MenuItem)menuCustom)) {
            this.chainedVisitor.visit(menuCustom);
        }
    }

    public void visit(MenuItemPerspective menuItemPerspective) {
        if (this.authorize((MenuItem)menuItemPerspective)) {
            this.chainedVisitor.visit(menuItemPerspective);
        }
    }

    public boolean authorize(MenuItem item) {
        List permissions;
        List actions = item.getResourceActions();
        if (actions != null && !actions.isEmpty()) {
            for (ResourceActionRef ref : actions) {
                if (this.authzManager.authorize(ref.getResource(), ref.getAction(), this.user)) continue;
                return false;
            }
        }
        if ((permissions = item.getPermissions()) != null && !permissions.isEmpty()) {
            for (String p : permissions) {
                if (this.authzManager.authorize(p, this.user)) continue;
                return false;
            }
        }
        boolean itemResult = this.authzManager.authorize((Resource)item, this.user);
        boolean denied = false;
        if (item instanceof MenuGroup) {
            MenuGroup group = (MenuGroup)item;
            for (MenuItem child : group.getItems()) {
                if (this.authorize(child)) {
                    return itemResult;
                }
                denied = true;
            }
        }
        return itemResult && !denied;
    }
}

