/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.ActivityBeansCache;
import org.uberfire.client.mvp.ActivityLifecycleError;
import org.uberfire.client.mvp.ActivityLifecycleErrorHandler;
import org.uberfire.client.mvp.ActivityManager;
import org.uberfire.client.mvp.SplashScreenActivity;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;

@ApplicationScoped
public class ActivityManagerImpl
implements ActivityManager {
    @Inject
    private SyncBeanManager iocManager;
    @Inject
    private AuthorizationManager authzManager;
    @Inject
    private ActivityBeansCache activityBeansCache;
    @Inject
    private User identity;
    @Inject
    private ActivityLifecycleErrorHandler lifecycleErrorHandler;
    private final Map<Activity, PlaceRequest> startedActivities = new IdentityHashMap<Activity, PlaceRequest>();
    private final Map<Object, Boolean> containsCache = new HashMap<Object, Boolean>();

    @Override
    public <T extends Activity> Set<T> getActivities(Class<T> clazz) {
        return this.secure(this.iocManager.lookupBeans(clazz), true);
    }

    @Override
    public SplashScreenActivity getSplashScreenInterceptor(PlaceRequest placeRequest) {
        SplashScreenActivity resultBean = null;
        for (SplashScreenActivity splashScreen : this.activityBeansCache.getSplashScreens()) {
            if (!splashScreen.intercept(placeRequest).booleanValue() || !splashScreen.isEnabled()) continue;
            resultBean = splashScreen;
            break;
        }
        return this.startIfNecessary(this.secure(resultBean), placeRequest);
    }

    @Override
    public Set<Activity> getActivities(PlaceRequest placeRequest) {
        return this.getActivities(placeRequest, true);
    }

    @Override
    public Set<Activity> getActivities(PlaceRequest placeRequest, boolean secure) {
        Collection<SyncBeanDef<Activity>> beans = placeRequest instanceof PathPlaceRequest ? this.resolveByPath((PathPlaceRequest)placeRequest) : this.resolveById(placeRequest.getIdentifier());
        Set<Activity> activities = this.startIfNecessary(this.secure(beans, secure), placeRequest);
        if (placeRequest instanceof PathPlaceRequest) {
            this.resolvePathPlaceRequestIdentifier(placeRequest, activities);
        }
        return activities;
    }

    private void resolvePathPlaceRequestIdentifier(PlaceRequest placeRequest, Set<Activity> activities) {
        if (activities != null && !activities.isEmpty()) {
            Activity activity = activities.iterator().next();
            placeRequest.setIdentifier(activity.getIdentifier());
        }
    }

    @Override
    public boolean containsActivity(PlaceRequest placeRequest) {
        if (this.containsCache.containsKey(placeRequest.getIdentifier())) {
            return this.containsCache.get(placeRequest.getIdentifier());
        }
        ObservablePath path = null;
        if (placeRequest instanceof PathPlaceRequest && this.containsCache.containsKey(path = ((PathPlaceRequest)placeRequest).getPath())) {
            return this.containsCache.get(path);
        }
        Activity result = this.getActivity(placeRequest);
        this.containsCache.put(placeRequest.getIdentifier(), result != null);
        if (path != null) {
            this.containsCache.put(path, result != null);
        }
        return result != null;
    }

    @Override
    public Activity getActivity(PlaceRequest placeRequest) {
        return this.getActivity(Activity.class, placeRequest);
    }

    @Override
    public Activity getActivity(PlaceRequest placeRequest, boolean secure) {
        return this.getActivity(Activity.class, placeRequest, secure);
    }

    @Override
    public <T extends Activity> T getActivity(Class<T> clazz, PlaceRequest placeRequest) {
        return this.getActivity(clazz, placeRequest, true);
    }

    @Override
    public <T extends Activity> T getActivity(Class<T> clazz, PlaceRequest placeRequest, boolean secure) {
        Set<Activity> activities = this.getActivities(placeRequest, secure);
        if (activities.size() == 0) {
            return null;
        }
        Activity activity = activities.iterator().next();
        return (T)activity;
    }

    @Override
    public void destroyActivity(Activity activity) {
        if (this.startedActivities.remove(activity) != null) {
            boolean isDependentScope = this.getBeanScope(activity) == Dependent.class;
            try {
                activity.onShutdown();
            }
            catch (Exception ex) {
                this.lifecycleErrorHandler.handle(activity, ActivityLifecycleError.LifecyclePhase.SHUTDOWN, ex);
            }
            if (isDependentScope) {
                this.iocManager.destroyBean((Object)activity);
            }
        } else {
            throw new IllegalStateException("Activity " + activity + " is not currently in the started state");
        }
    }

    @Override
    public boolean isStarted(Activity activity) {
        return this.startedActivities.containsKey(activity);
    }

    private Class<?> getBeanScope(Activity startedActivity) {
        if (startedActivity instanceof SplashScreenActivity) {
            return ApplicationScoped.class;
        }
        SyncBeanDef<Activity> beanDef = this.activityBeansCache.getActivity(startedActivity.getPlace().getIdentifier());
        if (beanDef == null) {
            return Dependent.class;
        }
        return beanDef.getScope();
    }

    private <T extends Activity> Set<T> secure(Collection<SyncBeanDef<T>> activityBeans, boolean protectedAccess) {
        HashSet<Activity> activities = new HashSet<Activity>(activityBeans.size());
        for (SyncBeanDef<T> activityBean : activityBeans) {
            if (!activityBean.isActivated()) continue;
            Activity instance = (Activity)activityBean.getInstance();
            if (!protectedAccess || this.authzManager.authorize((Resource)instance, this.identity)) {
                activities.add(instance);
                continue;
            }
            if (!activityBean.getScope().equals(Dependent.class)) continue;
            this.iocManager.destroyBean((Object)instance);
        }
        return activities;
    }

    private SplashScreenActivity secure(SplashScreenActivity bean) {
        if (bean == null) {
            return null;
        }
        if (this.authzManager.authorize((Resource)bean, this.identity)) {
            return bean;
        }
        return null;
    }

    private <T extends Activity> T startIfNecessary(T activity, PlaceRequest place) {
        if (activity == null) {
            return null;
        }
        try {
            if (!this.startedActivities.containsKey(activity)) {
                this.startedActivities.put(activity, place);
                activity.onStartup(place);
            }
            return activity;
        }
        catch (Exception ex) {
            this.lifecycleErrorHandler.handle(activity, ActivityLifecycleError.LifecyclePhase.STARTUP, ex);
            this.destroyActivity(activity);
            return null;
        }
    }

    private Set<Activity> startIfNecessary(Set<Activity> activities, PlaceRequest place) {
        HashSet<Activity> validatedActivities = new HashSet<Activity>();
        for (Activity activity : activities) {
            Activity validated = this.startIfNecessary(activity, place);
            if (validated == null) continue;
            validatedActivities.add(validated);
        }
        return validatedActivities;
    }

    private Collection<SyncBeanDef<Activity>> resolveById(String identifier) {
        if (identifier == null) {
            return Collections.emptyList();
        }
        SyncBeanDef<Activity> beanDefActivity = this.activityBeansCache.getActivity(identifier);
        if (beanDefActivity == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(beanDefActivity);
    }

    private Set<SyncBeanDef<Activity>> resolveByPath(PathPlaceRequest place) {
        if (place == null) {
            return Collections.emptySet();
        }
        SyncBeanDef<Activity> result = this.activityBeansCache.getActivity(place.getIdentifier());
        if (result != null) {
            return Collections.singleton(result);
        }
        return this.asSet(this.activityBeansCache.getActivity((Path)place.getPath()));
    }

    private Set<SyncBeanDef<Activity>> asSet(SyncBeanDef<Activity> activity) {
        if (activity == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(activity);
    }
}

