/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.logical.shared.AttachEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UIPart;
import org.uberfire.client.workbench.BeanFactory;
import org.uberfire.client.workbench.LayoutSelection;
import org.uberfire.client.workbench.PanelManager;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.client.workbench.events.DropPlaceEvent;
import org.uberfire.client.workbench.events.PanelFocusEvent;
import org.uberfire.client.workbench.events.PlaceGainFocusEvent;
import org.uberfire.client.workbench.events.PlaceHiddenEvent;
import org.uberfire.client.workbench.events.PlaceLostFocusEvent;
import org.uberfire.client.workbench.events.PlaceMaximizedEvent;
import org.uberfire.client.workbench.events.PlaceMinimizedEvent;
import org.uberfire.client.workbench.events.SelectPlaceEvent;
import org.uberfire.client.workbench.panels.DockingWorkbenchPanelPresenter;
import org.uberfire.client.workbench.panels.WorkbenchPanelPresenter;
import org.uberfire.client.workbench.part.WorkbenchPartPresenter;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.debug.Debug;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.plugin.PluginUtil;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.Position;
import org.uberfire.workbench.model.impl.PanelDefinitionImpl;
import org.uberfire.workbench.model.menu.Menus;

@ApplicationScoped
public class PanelManagerImpl
implements PanelManager {
    protected Event<PlaceGainFocusEvent> placeGainFocusEvent;
    protected Event<PlaceLostFocusEvent> placeLostFocusEvent;
    protected Event<PanelFocusEvent> panelFocusEvent;
    protected Event<SelectPlaceEvent> selectPlaceEvent;
    protected Event<PlaceMaximizedEvent> placeMaximizedEvent;
    protected Event<PlaceMinimizedEvent> placeMinimizedEvent;
    protected Event<PlaceHiddenEvent> placeHiddenEvent;
    protected SyncBeanManager iocManager;
    protected Instance<PlaceManager> placeManager;
    LayoutSelection layoutSelection;
    private BeanFactory beanFactory;
    protected PanelDefinition rootPanelDef = null;
    protected final Map<PartDefinition, WorkbenchPartPresenter> mapPartDefinitionToPresenter = new HashMap<PartDefinition, WorkbenchPartPresenter>();
    protected final Map<PanelDefinition, WorkbenchPanelPresenter> mapPanelDefinitionToPresenter = new HashMap<PanelDefinition, WorkbenchPanelPresenter>();
    protected final Map<PanelDefinition, HasWidgets> customPanels = new HashMap<PanelDefinition, HasWidgets>();
    protected final Map<PanelDefinition, HTMLElement> customPanelsInsideHTMLElements = new HashMap<PanelDefinition, HTMLElement>();
    protected PartDefinition activePart = null;
    private HandlerRegistration globalHandlerRegistration;
    private WorkbenchPanelPresenter maximizedPanel = null;

    @Inject
    public PanelManagerImpl(Event<PlaceGainFocusEvent> placeGainFocusEvent, Event<PlaceLostFocusEvent> placeLostFocusEvent, Event<PanelFocusEvent> panelFocusEvent, Event<SelectPlaceEvent> selectPlaceEvent, Event<PlaceMaximizedEvent> placeMaximizedEvent, Event<PlaceMinimizedEvent> placeMinimizedEventEvent, Event<PlaceHiddenEvent> placeHiddenEvent, SyncBeanManager iocManager, Instance<PlaceManager> placeManager, LayoutSelection layoutSelection, BeanFactory beanFactory) {
        this.placeGainFocusEvent = placeGainFocusEvent;
        this.placeLostFocusEvent = placeLostFocusEvent;
        this.panelFocusEvent = panelFocusEvent;
        this.selectPlaceEvent = selectPlaceEvent;
        this.placeMaximizedEvent = placeMaximizedEvent;
        this.placeMinimizedEvent = placeMinimizedEventEvent;
        this.placeHiddenEvent = placeHiddenEvent;
        this.iocManager = iocManager;
        this.placeManager = placeManager;
        this.layoutSelection = layoutSelection;
        this.beanFactory = beanFactory;
    }

    @PostConstruct
    private void setup() {
        this.globalHandlerRegistration = com.google.gwt.user.client.Event.addNativePreviewHandler((Event.NativePreviewHandler)new Event.NativePreviewHandler(){

            public void onPreviewNativeEvent(Event.NativePreviewEvent event) {
                if (event.getTypeInt() == 256 && event.getNativeEvent().getCharCode() == 109 && event.getNativeEvent().getCtrlKey()) {
                    if (PanelManagerImpl.this.maximizedPanel != null) {
                        PanelManagerImpl.this.maximizedPanel.unmaximize();
                        PanelManagerImpl.this.maximizedPanel = null;
                    } else if (PanelManagerImpl.this.activePart != null) {
                        WorkbenchPanelPresenter activePanelPresenter = PanelManagerImpl.this.mapPanelDefinitionToPresenter.get(PanelManagerImpl.this.activePart.getParentPanel());
                        activePanelPresenter.maximize();
                        PanelManagerImpl.this.maximizedPanel = activePanelPresenter;
                    }
                }
            }
        });
    }

    @PreDestroy
    private void teardown() {
        this.globalHandlerRegistration.removeHandler();
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    @Override
    public PanelDefinition getRoot() {
        return this.rootPanelDef;
    }

    @Override
    public void setRoot(PerspectiveActivity activity, PanelDefinition root) {
        PortablePreconditions.checkNotNull((String)"root", (Object)root);
        WorkbenchPanelPresenter oldRootPanelPresenter = this.mapPanelDefinitionToPresenter.remove(this.rootPanelDef);
        if (!this.mapPanelDefinitionToPresenter.isEmpty()) {
            String message = "Can't replace current root panel because it is not empty. The following panels remain: " + this.mapPanelDefinitionToPresenter;
            this.mapPanelDefinitionToPresenter.put(this.rootPanelDef, oldRootPanelPresenter);
            throw new IllegalStateException(message);
        }
        HasWidgets perspectiveContainer = this.layoutSelection.get().getPerspectiveContainer();
        perspectiveContainer.clear();
        this.getBeanFactory().destroy(oldRootPanelPresenter);
        this.rootPanelDef = root;
        WorkbenchPanelPresenter newPresenter = this.mapPanelDefinitionToPresenter.get(root);
        if (newPresenter == null) {
            newPresenter = this.getBeanFactory().newRootPanel(activity, root);
            this.mapPanelDefinitionToPresenter.put(root, newPresenter);
        }
        perspectiveContainer.add(newPresenter.getPanelView().asWidget());
    }

    @Override
    public void addWorkbenchPart(PlaceRequest place, PartDefinition partDef, PanelDefinition panelDef, Menus menus, UIPart uiPart, String contextId, Integer preferredWidth, Integer preferredHeight) {
        PortablePreconditions.checkNotNull((String)"panel", (Object)panelDef);
        WorkbenchPanelPresenter panelPresenter = this.mapPanelDefinitionToPresenter.get(panelDef);
        if (panelPresenter == null) {
            throw new IllegalArgumentException("Target panel is not part of the layout");
        }
        WorkbenchPartPresenter partPresenter = this.mapPartDefinitionToPresenter.get(partDef);
        if (partPresenter == null) {
            partPresenter = this.getBeanFactory().newWorkbenchPart(menus, uiPart.getTitle(), uiPart.getTitleDecoration(), partDef, panelPresenter.getPartType());
            partPresenter.setWrappedWidget(uiPart.getWidget());
            partPresenter.setContextId(contextId);
            this.mapPartDefinitionToPresenter.put(partDef, partPresenter);
        }
        panelPresenter.addPart(partPresenter, contextId);
        if (panelPresenter.getParent() instanceof DockingWorkbenchPanelPresenter) {
            DockingWorkbenchPanelPresenter parent = (DockingWorkbenchPanelPresenter)panelPresenter.getParent();
            parent.setChildSize(panelPresenter, preferredWidth, preferredHeight);
        }
        this.selectPlaceEvent.fire((Object)new SelectPlaceEvent(place));
    }

    @Override
    public boolean removePartForPlace(PlaceRequest toRemove) {
        PartDefinition removedPart = this.getPartForPlace(toRemove);
        if (removedPart != null) {
            this.removePart(removedPart);
            return true;
        }
        return false;
    }

    @Override
    public PanelDefinition addWorkbenchPanel(PanelDefinition targetPanel, Position position, Integer height, Integer width, Integer minHeight, Integer minWidth) {
        PanelDefinitionImpl childPanel = new PanelDefinitionImpl("PARENT_CHOOSES_TYPE");
        childPanel.setHeight(height);
        childPanel.setWidth(width);
        childPanel.setMinHeight(minHeight);
        childPanel.setMinWidth(minWidth);
        return this.addWorkbenchPanel(targetPanel, (PanelDefinition)childPanel, position);
    }

    @Override
    public void removeWorkbenchPanel(PanelDefinition toRemove) throws IllegalStateException {
        if (toRemove.isRoot()) {
            throw new IllegalArgumentException("The root panel cannot be removed. To replace it, call setRoot()");
        }
        if (!toRemove.getParts().isEmpty()) {
            throw new IllegalStateException("Panel still contains parts: " + toRemove.getParts());
        }
        WorkbenchPanelPresenter presenterToRemove = this.mapPanelDefinitionToPresenter.remove(toRemove);
        if (presenterToRemove == null) {
            throw new IllegalArgumentException("Couldn't find panel to remove: " + toRemove);
        }
        this.removeWorkbenchPanelFromParent(toRemove, presenterToRemove);
        if (!toRemove.getChildren().isEmpty()) {
            throw new IllegalStateException("Panel still contains child panels: " + toRemove.getChildren());
        }
        this.getBeanFactory().destroy(presenterToRemove);
    }

    private void removeWorkbenchPanelFromParent(PanelDefinition toRemove, WorkbenchPanelPresenter presenterToRemove) {
        HasWidgets customContainer = this.customPanels.remove(toRemove);
        if (customContainer != null) {
            customContainer.remove(presenterToRemove.getPanelView().asWidget());
        } else {
            HTMLElement customHTMLElementContainer = this.customPanelsInsideHTMLElements.remove(toRemove);
            if (customHTMLElementContainer != null) {
                DOMUtil.removeFromParent((Widget)presenterToRemove.getPanelView().asWidget());
            } else {
                PanelDefinition parentDef = toRemove.getParent();
                WorkbenchPanelPresenter parentPresenter = this.mapPanelDefinitionToPresenter.get(parentDef);
                if (parentPresenter == null) {
                    throw new IllegalArgumentException("The given panel's parent could not be found");
                }
                parentPresenter.removePanel(presenterToRemove);
            }
        }
    }

    @Override
    public void onPartFocus(PartDefinition part) {
        this.activePart = part;
        this.panelFocusEvent.fire((Object)new PanelFocusEvent(part.getParentPanel()));
        this.placeGainFocusEvent.fire((Object)new PlaceGainFocusEvent(part.getPlace()));
    }

    @Override
    public void onPartMaximized(PartDefinition part) {
        this.placeMaximizedEvent.fire((Object)new PlaceMaximizedEvent(part.getPlace()));
    }

    @Override
    public void onPartMinimized(PartDefinition part) {
        this.placeMinimizedEvent.fire((Object)new PlaceMinimizedEvent(part.getPlace()));
    }

    @Override
    public void onPartHidden(PartDefinition part) {
        this.placeHiddenEvent.fire((Object)new PlaceHiddenEvent(part.getPlace()));
    }

    @Override
    public void onPartLostFocus() {
        if (this.activePart == null) {
            return;
        }
        this.placeLostFocusEvent.fire((Object)new PlaceLostFocusEvent(this.activePart.getPlace()));
        this.activePart = null;
    }

    @Override
    public void onPanelFocus(PanelDefinition panel) {
        for (Map.Entry<PanelDefinition, WorkbenchPanelPresenter> e : this.mapPanelDefinitionToPresenter.entrySet()) {
            e.getValue().setFocus(e.getKey().asString().equals(panel.asString()));
        }
    }

    @Override
    public void closePart(PartDefinition part) {
        ((PlaceManager)this.placeManager.get()).closePlace(part.getPlace());
    }

    void onSelectPlaceEvent(@Observes SelectPlaceEvent event) {
        PlaceRequest place = event.getPlace();
        for (Map.Entry<PanelDefinition, WorkbenchPanelPresenter> e : this.mapPanelDefinitionToPresenter.entrySet()) {
            WorkbenchPanelPresenter panelPresenter = e.getValue();
            for (PartDefinition part : PluginUtil.ensureIterable((Set)panelPresenter.getDefinition().getParts())) {
                if (!part.getPlace().asString().equals(place.asString())) continue;
                panelPresenter.selectPart(part);
                this.onPanelFocus(e.getKey());
            }
        }
    }

    private void onDropPlaceEvent(@Observes DropPlaceEvent event) {
        PartDefinition part = this.getPartForPlace(event.getPlace());
        if (part != null) {
            this.removePart(part);
        }
    }

    @Override
    public PanelDefinition getPanelForPlace(PlaceRequest place) {
        for (PartDefinition part : this.mapPartDefinitionToPresenter.keySet()) {
            if (!part.getPlace().equals(place)) continue;
            return part.getParentPanel();
        }
        return null;
    }

    protected PartDefinition getPartForPlace(PlaceRequest place) {
        for (PartDefinition part : this.mapPartDefinitionToPresenter.keySet()) {
            if (!part.getPlace().asString().equals(place.asString())) continue;
            return part;
        }
        return null;
    }

    private void onChangeTitleWidgetEvent(@Observes ChangeTitleWidgetEvent event) {
        PlaceRequest place = event.getPlaceRequest();
        IsWidget titleDecoration = event.getTitleDecoration();
        String title = event.getTitle();
        block0: for (Map.Entry<PanelDefinition, WorkbenchPanelPresenter> e : this.mapPanelDefinitionToPresenter.entrySet()) {
            PanelDefinition panel = e.getKey();
            WorkbenchPanelPresenter presenter = e.getValue();
            for (PartDefinition part : PluginUtil.ensureIterable((Set)panel.getParts())) {
                if (!place.equals(part.getPlace())) continue;
                this.mapPartDefinitionToPresenter.get(part).setTitle(title);
                presenter.changeTitle(part, title, titleDecoration);
                continue block0;
            }
        }
    }

    protected void removePart(PartDefinition part) {
        for (Map.Entry<PanelDefinition, WorkbenchPanelPresenter> e : this.mapPanelDefinitionToPresenter.entrySet()) {
            WorkbenchPanelPresenter panelPresenter = e.getValue();
            if (!panelPresenter.getDefinition().getParts().contains(part)) continue;
            panelPresenter.removePart(part);
            break;
        }
        WorkbenchPartPresenter deadPartPresenter = this.mapPartDefinitionToPresenter.remove(part);
        this.getBeanFactory().destroy(deadPartPresenter);
    }

    @Override
    public PanelDefinition addWorkbenchPanel(PanelDefinition targetPanel, PanelDefinition childPanel, Position position) {
        PanelDefinition newPanel;
        WorkbenchPanelPresenter targetPanelPresenter = this.mapPanelDefinitionToPresenter.get(targetPanel);
        if (targetPanelPresenter == null) {
            targetPanelPresenter = this.beanFactory.newWorkbenchPanel(targetPanel);
            this.mapPanelDefinitionToPresenter.put(targetPanel, targetPanelPresenter);
        }
        if (CompassPosition.ROOT.getName().equals(position.getName())) {
            newPanel = this.rootPanelDef;
        } else if (CompassPosition.SELF.getName().equals(position.getName())) {
            newPanel = targetPanelPresenter.getDefinition();
        } else {
            String defaultChildType = targetPanelPresenter.getDefaultChildType();
            if (defaultChildType == null) {
                throw new IllegalArgumentException("Target panel (type " + targetPanelPresenter.getClass().getName() + ") does not allow child panels");
            }
            if (childPanel.getPanelType().equals("PARENT_CHOOSES_TYPE")) {
                childPanel.setPanelType(defaultChildType);
            }
            WorkbenchPanelPresenter childPanelPresenter = this.beanFactory.newWorkbenchPanel(childPanel);
            this.mapPanelDefinitionToPresenter.put(childPanel, childPanelPresenter);
            targetPanelPresenter.addPanel(childPanelPresenter, position);
            newPanel = childPanel;
        }
        this.onPanelFocus(newPanel);
        return newPanel;
    }

    @Override
    public PanelDefinition addCustomPanel(HasWidgets container, String panelType) {
        return this.addCustomPanelOnContainer(container, panelType);
    }

    @Override
    public PanelDefinition addCustomPanel(HTMLElement container, String panelType) {
        return this.addCustomPanelOnContainer(container, panelType);
    }

    private PanelDefinition addCustomPanelOnContainer(Object container, String panelType) {
        PanelDefinitionImpl panelDef = new PanelDefinitionImpl(panelType);
        WorkbenchPanelPresenter panelPresenter = this.beanFactory.newWorkbenchPanel((PanelDefinition)panelDef);
        Widget panelViewWidget = panelPresenter.getPanelView().asWidget();
        panelViewWidget.addAttachHandler((AttachEvent.Handler)new CustomPanelCleanupHandler(panelPresenter));
        if (container instanceof HasWidgets) {
            HasWidgets widgetContainer = (HasWidgets)container;
            widgetContainer.add(panelViewWidget);
            this.customPanels.put((PanelDefinition)panelDef, widgetContainer);
        } else {
            HTMLElement htmlContainer = (HTMLElement)container;
            this.appendWidgetToElement(htmlContainer, panelViewWidget);
            this.customPanelsInsideHTMLElements.put((PanelDefinition)panelDef, htmlContainer);
        }
        this.mapPanelDefinitionToPresenter.put((PanelDefinition)panelDef, panelPresenter);
        this.onPanelFocus((PanelDefinition)panelDef);
        return panelDef;
    }

    void appendWidgetToElement(HTMLElement container, Widget panelViewWidget) {
        DOMUtil.appendWidgetToElement((HTMLElement)container, (Widget)panelViewWidget.asWidget());
    }

    private final class CustomPanelCleanupHandler
    implements AttachEvent.Handler {
        private final WorkbenchPanelPresenter panelPresenter;
        private boolean detaching;

        private CustomPanelCleanupHandler(WorkbenchPanelPresenter panelPresenter) {
            this.panelPresenter = panelPresenter;
        }

        public void onAttachOrDetach(AttachEvent event) {
            if (event.isAttached()) {
                return;
            }
            if (!this.detaching && PanelManagerImpl.this.mapPanelDefinitionToPresenter.containsKey(this.panelPresenter.getDefinition())) {
                System.out.println("Running cleanup for " + Debug.objectId((Object)this));
                this.detaching = true;
                Scheduler.get().scheduleFinally(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        try {
                            for (PartDefinition part : PluginUtil.ensureIterable((Set)CustomPanelCleanupHandler.this.panelPresenter.getDefinition().getParts())) {
                                ((PlaceManager)PanelManagerImpl.this.placeManager.get()).closePlace(part.getPlace());
                            }
                            if (PanelManagerImpl.this.mapPanelDefinitionToPresenter.containsKey(CustomPanelCleanupHandler.this.panelPresenter.getDefinition())) {
                                PanelManagerImpl.this.removeWorkbenchPanel(CustomPanelCleanupHandler.this.panelPresenter.getDefinition());
                            }
                        }
                        finally {
                            CustomPanelCleanupHandler.this.detaching = false;
                        }
                    }
                });
            }
        }
    }
}

