/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.panels.impl;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.panels.impl.SinglePartPanelHelper;
import org.uberfire.client.workbench.panels.impl.UnanchoredStaticWorkbenchPanelPresenter;
import org.uberfire.client.workbench.panels.impl.UnanchoredStaticWorkbenchPanelView;
import org.uberfire.client.workbench.part.WorkbenchPartPresenter;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.PartDefinition;
import org.uberfire.workbench.model.impl.PanelDefinitionImpl;

@RunWith(value=GwtMockitoTestRunner.class)
public class UnanchoredStaticWorkbenchPanelPresenterTest {
    @Mock
    UnanchoredStaticWorkbenchPanelView view;
    UnanchoredStaticWorkbenchPanelPresenter presenter;
    @Mock
    private PlaceManager placeManager;

    @Before
    public void setup() {
        this.presenter = new UnanchoredStaticWorkbenchPanelPresenter(this.view, (PerspectiveManager)Mockito.mock(PerspectiveManager.class), this.placeManager);
        this.presenter.init();
        this.presenter.setDefinition((PanelDefinition)new PanelDefinitionImpl());
    }

    @Test
    public void getDefaultChildTypeTest() {
        Assert.assertNull((Object)this.presenter.getDefaultChildType());
    }

    @Test
    public void addPartTest() {
        WorkbenchPartPresenter part = (WorkbenchPartPresenter)Mockito.mock(WorkbenchPartPresenter.class);
        Mockito.when((Object)part.getDefinition()).thenReturn(Mockito.mock(PartDefinition.class));
        this.presenter.addPart(part);
        ((UnanchoredStaticWorkbenchPanelView)Mockito.verify((Object)this.view)).addPart((WorkbenchPartPresenter.View)Matchers.any());
    }

    @Test
    public void addPartTwiceShouldCloseOtherPartTest() {
        final SinglePartPanelHelper singlePartPanelHelper = (SinglePartPanelHelper)Mockito.mock(SinglePartPanelHelper.class);
        UnanchoredStaticWorkbenchPanelPresenter presenter = new UnanchoredStaticWorkbenchPanelPresenter(this.view, (PerspectiveManager)Mockito.mock(PerspectiveManager.class), this.placeManager){

            SinglePartPanelHelper createSinglePartPanelHelper() {
                return singlePartPanelHelper;
            }
        };
        presenter.init();
        presenter.setDefinition((PanelDefinition)new PanelDefinitionImpl());
        Mockito.when((Object)singlePartPanelHelper.hasNoParts()).thenReturn((Object)false);
        WorkbenchPartPresenter part2 = (WorkbenchPartPresenter)Mockito.mock(WorkbenchPartPresenter.class);
        Mockito.when((Object)part2.getDefinition()).thenReturn(Mockito.mock(PartDefinition.class));
        presenter.addPart(part2);
        ((SinglePartPanelHelper)Mockito.verify((Object)singlePartPanelHelper)).closeFirstPartAndAddNewOne((Command)Matchers.any(Command.class));
    }
}

