/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.mvp.PlaceRequest;

public class BookmarkableUrlHelper {
    public static final String PERSPECTIVE_SEP = "|";
    public static final String DOCK_BEGIN_SEP = "[";
    public static final String DOCK_CLOSE_SEP = "]";
    public static final String SEPARATOR = ",";
    public static final String OTHER_SCREEN_SEP = "$";
    public static final String CLOSED_PREFIX = "~";
    public static final String CLOSED_DOCK_PREFIX = "!";
    public static final int MAX_NAV_URL_SIZE = 1900;

    private static boolean isNotBlank(String str) {
        return str != null && str.trim().length() > 0;
    }

    private static boolean isNotBlank(PlaceRequest place) {
        return null != place && BookmarkableUrlHelper.isNotBlank(place.getFullIdentifier());
    }

    public static String registerOpenedScreen(String bookmarkableUrl, PlaceRequest placeRequest) {
        String screenName = placeRequest.getFullIdentifier();
        String closedScreen = CLOSED_PREFIX.concat(screenName);
        String currentBookmarkableUrl = bookmarkableUrl;
        bookmarkableUrl = BookmarkableUrlHelper.screenWasClosed(bookmarkableUrl, closedScreen) ? bookmarkableUrl.replace(closedScreen, screenName) : (!BookmarkableUrlHelper.isPerspectiveInUrl(bookmarkableUrl) ? (BookmarkableUrlHelper.isNotBlank(bookmarkableUrl) ? bookmarkableUrl.concat(SEPARATOR).concat(screenName) : screenName) : (!BookmarkableUrlHelper.urlContainsExtraPerspectiveScreen(bookmarkableUrl) ? bookmarkableUrl.concat(OTHER_SCREEN_SEP).concat(screenName) : bookmarkableUrl.concat(SEPARATOR).concat(screenName)));
        if (BookmarkableUrlHelper.isBiggerThenMaxURLSize(bookmarkableUrl)) {
            return currentBookmarkableUrl;
        }
        return bookmarkableUrl;
    }

    private static boolean screenWasClosed(String bookmarkableUrl, String closedScreen) {
        return bookmarkableUrl.indexOf(closedScreen) != -1;
    }

    private static boolean isBiggerThenMaxURLSize(String bookmarkableUrl) {
        return BookmarkableUrlHelper.isNotBlank(bookmarkableUrl) && bookmarkableUrl.length() >= 1900;
    }

    public static String registerClose(String bookmarkableUrl, String screenName) {
        boolean isPerspective = BookmarkableUrlHelper.isPerspectiveScreen(bookmarkableUrl, screenName);
        String separator = isPerspective ? PERSPECTIVE_SEP : OTHER_SCREEN_SEP;
        String closedScreen = CLOSED_PREFIX.concat(screenName);
        String uniqueScreenAfterDelimiter = separator.concat(screenName);
        String firstScreenAfterDelimiter = uniqueScreenAfterDelimiter.concat(SEPARATOR);
        String commaSeparatedScreen = screenName.concat(SEPARATOR);
        if (BookmarkableUrlHelper.isScreenClosed(bookmarkableUrl, closedScreen)) {
            return bookmarkableUrl;
        }
        if (isPerspective) {
            bookmarkableUrl = bookmarkableUrl.replace(screenName, closedScreen);
        } else if (bookmarkableUrl.contains(firstScreenAfterDelimiter)) {
            bookmarkableUrl = bookmarkableUrl.replace(firstScreenAfterDelimiter, separator);
        } else if (bookmarkableUrl.contains(uniqueScreenAfterDelimiter)) {
            bookmarkableUrl = bookmarkableUrl.replace(uniqueScreenAfterDelimiter, "");
        } else if (bookmarkableUrl.contains(commaSeparatedScreen)) {
            bookmarkableUrl = bookmarkableUrl.replace(commaSeparatedScreen, "");
        }
        return bookmarkableUrl;
    }

    public static PlaceRequest getPerspectiveFromPlace(PlaceRequest place) {
        String url = place.getFullIdentifier();
        if (BookmarkableUrlHelper.isPerspectiveInUrl(url)) {
            String perspectiveName = url.substring(0, url.indexOf(PERSPECTIVE_SEP));
            PlaceRequest copy = place.clone();
            copy.setIdentifier(perspectiveName);
            if (!place.getParameters().isEmpty()) {
                for (Map.Entry elem : place.getParameters().entrySet()) {
                    copy.addParameter((String)elem.getKey(), (String)elem.getValue());
                }
            }
            return copy;
        }
        return place;
    }

    public static boolean isPerspectiveScreen(String bookmarkableUrl, String screen) {
        return BookmarkableUrlHelper.isNotBlank(screen) && BookmarkableUrlHelper.isNotBlank(bookmarkableUrl) && (!BookmarkableUrlHelper.urlContainsExtraPerspectiveScreen(bookmarkableUrl) || bookmarkableUrl.indexOf(OTHER_SCREEN_SEP) > bookmarkableUrl.indexOf(screen));
    }

    public static boolean isPerspectiveInUrl(String url) {
        return BookmarkableUrlHelper.isNotBlank(url) && url.indexOf(PERSPECTIVE_SEP) > 0;
    }

    public static boolean urlContainsExtraPerspectiveScreen(String bookmarkableUrl) {
        return bookmarkableUrl.indexOf(OTHER_SCREEN_SEP) != -1;
    }

    public static String getUrlToken(String bookmarkableUrl, String screen) {
        int st = BookmarkableUrlHelper.isPerspectiveInUrl(bookmarkableUrl) ? bookmarkableUrl.indexOf(PERSPECTIVE_SEP) + 1 : 0;
        String screensList = bookmarkableUrl.replace(OTHER_SCREEN_SEP, SEPARATOR).substring(st, bookmarkableUrl.length());
        String[] tokens = screensList.split(SEPARATOR);
        Optional<String> token = Arrays.asList(tokens).stream().filter(s -> s.contains(screen)).findFirst();
        return token.orElse(screen);
    }

    public static Set<String> getDockedScreensFromUrl(String url) {
        if (!BookmarkableUrlHelper.isNotBlank(url)) {
            return new HashSet<String>();
        }
        int start = url.indexOf(DOCK_BEGIN_SEP) + 1;
        int end = url.indexOf(DOCK_CLOSE_SEP) - 1;
        if (start > 0) {
            String docks = url.substring(start, end);
            String[] token = docks.split(SEPARATOR);
            return new HashSet<String>(Arrays.asList(token));
        }
        return new HashSet<String>();
    }

    public static Set<String> getDockedScreensFromPlace(PlaceRequest place) {
        if (null != place) {
            return BookmarkableUrlHelper.getDockedScreensFromUrl(place.getFullIdentifier());
        }
        return new HashSet<String>();
    }

    public static Set<String> getScreensFromPlace(PlaceRequest place) {
        String url;
        if (!BookmarkableUrlHelper.isNotBlank(place)) {
            return new HashSet<String>();
        }
        if (BookmarkableUrlHelper.isPerspectiveInUrl(place.getFullIdentifier())) {
            String request = place.getFullIdentifier();
            url = request.substring(request.indexOf(PERSPECTIVE_SEP) + 1);
        } else {
            url = place.getFullIdentifier();
        }
        int start = url.indexOf(DOCK_BEGIN_SEP);
        int end = url.indexOf(DOCK_CLOSE_SEP) + 1;
        if (start > 0) {
            String docks = url.substring(start, end);
            url = url.replace(docks, "");
        }
        url = url.replace(OTHER_SCREEN_SEP, SEPARATOR);
        String[] token = url.split(SEPARATOR);
        return new HashSet<String>(Arrays.asList(token));
    }

    public static Set<String> getClosedScreenFromPlace(PlaceRequest place) {
        Set<String> screens = BookmarkableUrlHelper.getScreensFromPlace(place);
        Set<String> result = screens.stream().filter(s -> s.startsWith(CLOSED_PREFIX)).collect(Collectors.toSet());
        return result;
    }

    public static Set<String> getOpenedScreenFromPlace(PlaceRequest place) {
        Set<String> screens = BookmarkableUrlHelper.getScreensFromPlace(place);
        Set<String> result = screens.stream().filter(s -> !s.startsWith(CLOSED_PREFIX)).collect(Collectors.toSet());
        return result;
    }

    public static boolean isScreenClosed(String bookmarkableUrl, String screen) {
        if (!screen.startsWith(CLOSED_PREFIX)) {
            screen = CLOSED_PREFIX.concat(screen);
        }
        return bookmarkableUrl.indexOf(screen) != -1;
    }

    public static String registerOpenedPerspective(String currentBookmarkableURLStatus, PlaceRequest place) {
        return place.getFullIdentifier().concat(PERSPECTIVE_SEP).concat(currentBookmarkableURLStatus);
    }

    private static String getDockId(UberfireDock targetDock) {
        return targetDock.getDockPosition().getShortName() + targetDock.getPlaceRequest().getFullIdentifier() + SEPARATOR;
    }

    public static String registerOpenedDock(String currentBookmarkableURLStatus, UberfireDock targetDock) {
        if (targetDock == null) {
            return currentBookmarkableURLStatus;
        }
        String id = BookmarkableUrlHelper.getDockId(targetDock);
        String closed = CLOSED_DOCK_PREFIX.concat(id);
        if (currentBookmarkableURLStatus.contains(DOCK_CLOSE_SEP)) {
            String result = null;
            result = !currentBookmarkableURLStatus.contains(id) ? currentBookmarkableURLStatus.replace(DOCK_CLOSE_SEP, id + DOCK_CLOSE_SEP) : (currentBookmarkableURLStatus.contains(closed) ? currentBookmarkableURLStatus.replace(closed, id) : currentBookmarkableURLStatus);
            return result;
        }
        return currentBookmarkableURLStatus + DOCK_BEGIN_SEP + BookmarkableUrlHelper.getDockId(targetDock) + DOCK_CLOSE_SEP;
    }

    public static String registerClosedDock(String currentBookmarkableURLStatus, UberfireDock targetDock) {
        if (!BookmarkableUrlHelper.isNotBlank(currentBookmarkableURLStatus) || null == targetDock) {
            return currentBookmarkableURLStatus;
        }
        String id = BookmarkableUrlHelper.getDockId(targetDock);
        String closed = CLOSED_DOCK_PREFIX.concat(id);
        if (!currentBookmarkableURLStatus.contains(closed)) {
            return currentBookmarkableURLStatus.replace(id, CLOSED_DOCK_PREFIX.concat(id));
        }
        return currentBookmarkableURLStatus;
    }
}

