/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.widgets.animations;

import com.google.gwt.animation.client.Animation;
import java.util.ArrayList;
import java.util.List;
import org.uberfire.client.workbench.widgets.animations.SequencedAnimation;

public class Sequencer {
    private int currentAnimationIndex = 0;
    private List<AnimationConfiguration> animations = new ArrayList<AnimationConfiguration>();

    public void add(SequencedAnimation animation, int duration) {
        this.animations.add(new AnimationConfiguration(new WrappedAnimation(animation), duration));
    }

    public void run() {
        this.runNextAnimation();
    }

    public void reset() {
        this.currentAnimationIndex = 0;
    }

    private void runNextAnimation() {
        if (this.currentAnimationIndex < this.animations.size()) {
            AnimationConfiguration config = this.animations.get(this.currentAnimationIndex++);
            WrappedAnimation animation = config.animation;
            int duration = config.duration;
            animation.run(duration);
        } else {
            this.reset();
        }
    }

    private class WrappedAnimation
    extends Animation {
        private final SequencedAnimation animation;

        WrappedAnimation(SequencedAnimation animation) {
            this.animation = animation;
        }

        public void onComplete() {
            this.animation.onComplete();
            Sequencer.this.runNextAnimation();
        }

        protected void onUpdate(double progress) {
            this.animation.onUpdate(progress);
        }

        public void cancel() {
            this.animation.cancel();
        }

        protected double interpolate(double progress) {
            return this.animation.interpolate(progress);
        }

        protected void onCancel() {
            this.animation.onCancel();
        }

        protected void onStart() {
            this.animation.onStart();
        }
    }

    private class AnimationConfiguration {
        final WrappedAnimation animation;
        final int duration;

        AnimationConfiguration(WrappedAnimation animation, int duration) {
            this.animation = animation;
            this.duration = duration;
        }
    }
}

