/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.annotations.processors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.uberfire.annotations.processors.exceptions.GenerationException;
import org.uberfire.annotations.processors.facades.APIModule;
import org.uberfire.annotations.processors.facades.BackendModule;
import org.uberfire.annotations.processors.facades.ClientAPIModule;
import org.uberfire.annotations.processors.facades.SecurityModule;

public class GeneratorUtils {
    public static String getOnStartupZeroParameterMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getVoidMethodName(classElement, processingEnvironment, APIModule.getOnStartupClass());
    }

    public static String getOnStartupPathParameterMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getVoidMethodName(classElement, processingEnvironment, new String[]{BackendModule.getPathClass().getName()}, APIModule.getOnStartupClass());
    }

    public static String getOnStartupPathPlaceRequestParametersMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getVoidMethodName(classElement, processingEnvironment, new String[]{BackendModule.getPathClass().getName(), APIModule.getPlaceRequestClass().getName()}, APIModule.getOnStartupClass());
    }

    public static String getOnContextAttachPanelDefinitionMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getVoidMethodName(classElement, processingEnvironment, new String[]{APIModule.getPanelDefinitionClass().getName()}, APIModule.getOnContextAttachClass());
    }

    public static String getOnStartPlaceRequestParameterMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getVoidMethodName(classElement, processingEnvironment, new String[]{APIModule.getPlaceRequestClass().getName()}, APIModule.getOnStartupClass());
    }

    public static String getOnMayCloseMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getBooleanMethodName(classElement, processingEnvironment, APIModule.getOnMayCloseClass());
    }

    public static String getOnCloseMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getVoidMethodName(classElement, processingEnvironment, APIModule.getOnCloseClass());
    }

    public static String getOnShutdownMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getVoidMethodName(classElement, processingEnvironment, APIModule.getOnShutdownlass());
    }

    public static String getOnOpenMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getVoidMethodName(classElement, processingEnvironment, APIModule.getOnOpenClass());
    }

    public static String getOnLostFocusMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getVoidMethodName(classElement, processingEnvironment, APIModule.getOnLostFocusClass());
    }

    public static String getOnFocusMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getVoidMethodName(classElement, processingEnvironment, APIModule.getOnFocusClass());
    }

    public static String getDefaultPositionMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getDefaultPositionMethodName(classElement, processingEnvironment, ClientAPIModule.getDefaultPositionClass());
    }

    public static String getTitleMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getStringMethodName(classElement, processingEnvironment, ClientAPIModule.getWorkbenchPartTitleClass());
    }

    public static String getContextIdMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getStringMethodName(classElement, processingEnvironment, ClientAPIModule.getWorkbenchContextIdClass());
    }

    public static ExecutableElement getTitleWidgetMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getWidgetMethodName(classElement, processingEnvironment, ClientAPIModule.getWorkbenchPartTitleDecorationsClass());
    }

    public static ExecutableElement getWidgetMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getWidgetMethodName(classElement, processingEnvironment, ClientAPIModule.getWorkbenchPartViewClass());
    }

    public static boolean getIsWidget(TypeElement classElement, ProcessingEnvironment processingEnvironment) {
        Types typeUtils = processingEnvironment.getTypeUtils();
        Elements elementUtils = processingEnvironment.getElementUtils();
        TypeMirror requiredReturnType = elementUtils.getTypeElement("com.google.gwt.user.client.ui.IsWidget").asType();
        return typeUtils.isAssignable(classElement.asType(), requiredReturnType);
    }

    public static boolean hasUberViewReference(TypeElement classElement, ProcessingEnvironment processingEnvironment, ExecutableElement getWidgetMethod) {
        if (getWidgetMethod == null) {
            return false;
        }
        Types typeUtils = processingEnvironment.getTypeUtils();
        Elements elementUtils = processingEnvironment.getElementUtils();
        TypeMirror requiredReturnType = elementUtils.getTypeElement("org.uberfire.client.mvp.UberView").asType();
        return typeUtils.isAssignable(typeUtils.erasure(getWidgetMethod.getReturnType()), requiredReturnType);
    }

    public static String getPopupMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getPopupMethodName(classElement, processingEnvironment, ClientAPIModule.getWorkbenchPartViewClass());
    }

    public static boolean getIsPopup(TypeElement classElement, ProcessingEnvironment processingEnvironment) {
        Types typeUtils = processingEnvironment.getTypeUtils();
        Elements elementUtils = processingEnvironment.getElementUtils();
        TypeMirror requiredReturnType = elementUtils.getTypeElement("com.google.gwt.user.client.ui.PopupPanel").asType();
        return typeUtils.isAssignable(classElement.asType(), requiredReturnType);
    }

    public static String getIsDirtyMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getBooleanMethodName(classElement, processingEnvironment, APIModule.getIsDirtyClass());
    }

    public static String getOnSaveMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getVoidMethodName(classElement, processingEnvironment, APIModule.getOnSaveClass());
    }

    public static String getMenuBarMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getMenuBarMethodName(classElement, processingEnvironment, ClientAPIModule.getWorkbenchMenuClass());
    }

    public static String getToolBarMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getToolBarMethodName(classElement, processingEnvironment, ClientAPIModule.getWorkbenchToolBarClass());
    }

    public static String getPerspectiveMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getMethodName(classElement, processingEnvironment, "org.uberfire.workbench.model.PerspectiveDefinition", ClientAPIModule.getPerspectiveClass());
    }

    public static String getSplashFilterMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getMethodName(classElement, processingEnvironment, "org.uberfire.workbench.model.SplashScreenFilter", ClientAPIModule.getSplashFilterClass());
    }

    public static String getBodyHeightMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getMethodName(classElement, processingEnvironment, "java.lang.Integer", ClientAPIModule.getSplashBodySizeClass());
    }

    public static String getInterceptMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getMethodName(classElement, processingEnvironment, "java.lang.Boolean", ClientAPIModule.getInterceptClass());
    }

    private static String getVoidMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment, Class annotation) throws GenerationException {
        Types typeUtils = processingEnvironment.getTypeUtils();
        NoType requiredReturnType = typeUtils.getNoType(TypeKind.VOID);
        List<ExecutableElement> methods = ElementFilter.methodsIn(classElement.getEnclosedElements());
        ExecutableElement match = null;
        for (ExecutableElement e : methods) {
            TypeMirror actualReturnType = e.getReturnType();
            if (e.getAnnotation(annotation) == null || !typeUtils.isSameType(actualReturnType, requiredReturnType) || e.getParameters().size() != 0 || e.getModifiers().contains((Object)Modifier.STATIC) || !e.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            if (match != null) {
                throw new GenerationException("Multiple methods with @" + annotation.getSimpleName() + " detected.");
            }
            match = e;
        }
        if (match == null) {
            return null;
        }
        return match.getSimpleName().toString();
    }

    private static String getVoidMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment, String[] parameterTypes, Class annotation) throws GenerationException {
        Types typeUtils = processingEnvironment.getTypeUtils();
        Elements elementUtils = processingEnvironment.getElementUtils();
        NoType requiredReturnType = typeUtils.getNoType(TypeKind.VOID);
        List<ExecutableElement> methods = ElementFilter.methodsIn(classElement.getEnclosedElements());
        ExecutableElement match = null;
        for (ExecutableElement e : methods) {
            TypeMirror actualReturnType = e.getReturnType();
            if (e.getAnnotation(annotation) == null || !typeUtils.isSameType(actualReturnType, requiredReturnType) || !GeneratorUtils.doParametersMatch(typeUtils, elementUtils, e, parameterTypes) || e.getModifiers().contains((Object)Modifier.STATIC) || !e.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            if (match != null) {
                throw new GenerationException("Multiple methods with @" + annotation.getSimpleName() + " detected.");
            }
            match = e;
        }
        if (match == null) {
            return null;
        }
        return match.getSimpleName().toString();
    }

    private static boolean doParametersMatch(Types typeUtils, Elements elementUtils, ExecutableElement e, String[] requiredParameterTypes) {
        if (e.getParameters().size() != requiredParameterTypes.length) {
            return false;
        }
        ArrayList<TypeMirror> requiredTypes = new ArrayList<TypeMirror>();
        for (String parameterType : requiredParameterTypes) {
            requiredTypes.add(elementUtils.getTypeElement(parameterType).asType());
        }
        for (int i = 0; i < requiredTypes.size(); ++i) {
            TypeMirror requiredType;
            TypeMirror actualType = e.getParameters().get(i).asType();
            if (typeUtils.isAssignable(actualType, requiredType = (TypeMirror)requiredTypes.get(i))) continue;
            return false;
        }
        return true;
    }

    private static String getBooleanMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment, Class annotation) throws GenerationException {
        Types typeUtils = processingEnvironment.getTypeUtils();
        Elements elementUtils = processingEnvironment.getElementUtils();
        TypeMirror requiredReturnType = elementUtils.getTypeElement(Boolean.class.getName()).asType();
        List<ExecutableElement> methods = ElementFilter.methodsIn(classElement.getEnclosedElements());
        ExecutableElement match = null;
        for (ExecutableElement e : methods) {
            TypeMirror actualReturnType = e.getReturnType();
            if (e.getAnnotation(annotation) == null || !typeUtils.isAssignable(actualReturnType, requiredReturnType) || e.getParameters().size() != 0 || e.getModifiers().contains((Object)Modifier.STATIC) || !e.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            if (match != null) {
                throw new GenerationException("Multiple methods with @" + annotation.getSimpleName() + " detected.");
            }
            match = e;
        }
        if (match == null) {
            return null;
        }
        return match.getSimpleName().toString();
    }

    private static String getStringMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment, Class annotation) throws GenerationException {
        Types typeUtils = processingEnvironment.getTypeUtils();
        Elements elementUtils = processingEnvironment.getElementUtils();
        TypeMirror requiredReturnType = elementUtils.getTypeElement(String.class.getName()).asType();
        List<ExecutableElement> methods = ElementFilter.methodsIn(classElement.getEnclosedElements());
        ExecutableElement match = null;
        for (ExecutableElement e : methods) {
            TypeMirror actualReturnType = e.getReturnType();
            if (e.getAnnotation(annotation) == null || !typeUtils.isAssignable(actualReturnType, requiredReturnType) || e.getParameters().size() != 0 || e.getModifiers().contains((Object)Modifier.STATIC) || !e.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            if (match != null) {
                throw new GenerationException("Multiple methods with @" + annotation.getSimpleName() + " detected.");
            }
            match = e;
        }
        if (match == null) {
            return null;
        }
        return match.getSimpleName().toString();
    }

    private static ExecutableElement getWidgetMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment, Class annotation) throws GenerationException {
        Types typeUtils = processingEnvironment.getTypeUtils();
        Elements elementUtils = processingEnvironment.getElementUtils();
        TypeMirror requiredReturnType = elementUtils.getTypeElement("com.google.gwt.user.client.ui.IsWidget").asType();
        List<ExecutableElement> methods = ElementFilter.methodsIn(classElement.getEnclosedElements());
        ExecutableElement match = null;
        for (ExecutableElement e : methods) {
            TypeMirror actualReturnType = e.getReturnType();
            if (e.getAnnotation(annotation) == null || !typeUtils.isAssignable(actualReturnType, requiredReturnType) || e.getParameters().size() != 0 || e.getModifiers().contains((Object)Modifier.STATIC) || !e.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            if (match != null) {
                throw new GenerationException("Multiple methods with @" + annotation.getSimpleName() + " detected.");
            }
            match = e;
        }
        if (match == null) {
            return null;
        }
        return match;
    }

    private static String getPopupMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment, Class annotation) throws GenerationException {
        Types typeUtils = processingEnvironment.getTypeUtils();
        Elements elementUtils = processingEnvironment.getElementUtils();
        TypeMirror requiredReturnType = elementUtils.getTypeElement("com.google.gwt.user.client.ui.PopupPanel").asType();
        List<ExecutableElement> methods = ElementFilter.methodsIn(classElement.getEnclosedElements());
        ExecutableElement match = null;
        for (ExecutableElement e : methods) {
            TypeMirror actualReturnType = e.getReturnType();
            if (e.getAnnotation(annotation) == null || !typeUtils.isAssignable(actualReturnType, requiredReturnType) || e.getParameters().size() != 0 || e.getModifiers().contains((Object)Modifier.STATIC) || !e.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            if (match != null) {
                throw new GenerationException("Multiple methods with @" + annotation.getSimpleName() + " detected.");
            }
            match = e;
        }
        if (match == null) {
            return null;
        }
        return match.getSimpleName().toString();
    }

    private static String getDefaultPositionMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment, Class annotation) throws GenerationException {
        Types typeUtils = processingEnvironment.getTypeUtils();
        Elements elementUtils = processingEnvironment.getElementUtils();
        TypeMirror requiredReturnType = elementUtils.getTypeElement(APIModule.getPositionClass().getName()).asType();
        List<ExecutableElement> methods = ElementFilter.methodsIn(classElement.getEnclosedElements());
        ExecutableElement match = null;
        for (ExecutableElement e : methods) {
            TypeMirror actualReturnType = e.getReturnType();
            if (e.getAnnotation(annotation) == null || !typeUtils.isAssignable(actualReturnType, requiredReturnType) || e.getParameters().size() != 0 || e.getModifiers().contains((Object)Modifier.STATIC) || !e.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            if (match != null) {
                throw new GenerationException("Multiple methods with @" + annotation.getSimpleName() + " detected.");
            }
            match = e;
        }
        if (match == null) {
            return null;
        }
        return match.getSimpleName().toString();
    }

    private static String getMenuBarMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment, Class annotation) throws GenerationException {
        Types typeUtils = processingEnvironment.getTypeUtils();
        Elements elementUtils = processingEnvironment.getElementUtils();
        TypeMirror requiredReturnType = elementUtils.getTypeElement("org.uberfire.workbench.model.menu.Menus").asType();
        List<ExecutableElement> methods = ElementFilter.methodsIn(classElement.getEnclosedElements());
        ExecutableElement match = null;
        for (ExecutableElement e : methods) {
            TypeMirror actualReturnType = e.getReturnType();
            if (e.getAnnotation(annotation) == null || !typeUtils.isAssignable(actualReturnType, requiredReturnType) || e.getParameters().size() != 0 || e.getModifiers().contains((Object)Modifier.STATIC) || !e.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            if (match != null) {
                throw new GenerationException("Multiple methods with @" + annotation.getSimpleName() + " detected.");
            }
            match = e;
        }
        if (match == null) {
            return null;
        }
        return match.getSimpleName().toString();
    }

    private static String getToolBarMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment, Class annotation) throws GenerationException {
        Types typeUtils = processingEnvironment.getTypeUtils();
        Elements elementUtils = processingEnvironment.getElementUtils();
        TypeMirror requiredReturnType = elementUtils.getTypeElement("org.uberfire.workbench.model.toolbar.ToolBar").asType();
        List<ExecutableElement> methods = ElementFilter.methodsIn(classElement.getEnclosedElements());
        ExecutableElement match = null;
        for (ExecutableElement e : methods) {
            TypeMirror actualReturnType = e.getReturnType();
            if (e.getAnnotation(annotation) == null || !typeUtils.isAssignable(actualReturnType, requiredReturnType) || e.getParameters().size() != 0 || e.getModifiers().contains((Object)Modifier.STATIC) || !e.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            if (match != null) {
                throw new GenerationException("Multiple methods with @" + annotation.getSimpleName() + " detected.");
            }
            match = e;
        }
        if (match == null) {
            return null;
        }
        return match.getSimpleName().toString();
    }

    private static String getMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment, String expectedReturnType, Class annotation) throws GenerationException {
        Types typeUtils = processingEnvironment.getTypeUtils();
        Elements elementUtils = processingEnvironment.getElementUtils();
        TypeMirror requiredReturnType = elementUtils.getTypeElement(expectedReturnType).asType();
        List<ExecutableElement> methods = ElementFilter.methodsIn(classElement.getEnclosedElements());
        ExecutableElement match = null;
        for (ExecutableElement e : methods) {
            TypeMirror actualReturnType = e.getReturnType();
            if (e.getAnnotation(annotation) == null || !typeUtils.isAssignable(actualReturnType, requiredReturnType) || e.getParameters().size() != 0 || e.getModifiers().contains((Object)Modifier.STATIC) || !e.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            if (match != null) {
                throw new GenerationException("Multiple methods with @" + annotation.getSimpleName() + " detected.");
            }
            match = e;
        }
        if (match == null) {
            return null;
        }
        return match.getSimpleName().toString();
    }

    public static String getSecurityTraitList(Element element) throws GenerationException {
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        HashSet<String> traits = new HashSet<String>(annotationMirrors.size());
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            Element annotationElement = annotationMirror.getAnnotationType().asElement();
            if (annotationElement.getAnnotation(SecurityModule.getSecurityTraitClass()) == null) continue;
            traits.add(annotationElement.asType().toString());
        }
        if (traits.isEmpty()) {
            return null;
        }
        return GeneratorUtils.collectionAsString(traits);
    }

    public static String getRoleList(Element element) throws GenerationException {
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        HashSet<String> result = new HashSet<String>();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (annotationMirror.getAnnotationType().asElement().getAnnotation(SecurityModule.getRolesTypeClass()) == null) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!entry.getKey().getSimpleName().toString().equals("value")) continue;
                result.addAll(GeneratorUtils.extractValue(entry.getValue()));
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        return GeneratorUtils.collectionAsString(result);
    }

    public static <T extends AnnotationValue> List<String> extractValue(final T value) {
        if (value.getValue() instanceof Collection) {
            List varray = (List)value.getValue();
            ArrayList<String> result = new ArrayList<String>(varray.size());
            for (Object active : varray) {
                result.addAll(GeneratorUtils.extractValue((AnnotationValue)active));
            }
            return result;
        }
        return new ArrayList<String>(1){
            {
                super(x0);
                this.add(value.getValue().toString());
            }
        };
    }

    private static String collectionAsString(Collection<String> collection) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> iterator = collection.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            String next = iterator.next();
            sb.append('\"').append(next).append('\"');
            if (i + 1 < collection.size()) {
                sb.append(", ");
            }
            ++i;
        }
        return sb.toString();
    }

    public static String formatAssociatedResources(List<String> resourceTypes) {
        if (resourceTypes == null || resourceTypes.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("@AssociatedResources").append("({\n");
        for (String resourceType : resourceTypes) {
            sb.append("    ").append(resourceType).append(".class").append(",\n");
        }
        sb.delete(sb.length() - 2, sb.length());
        sb.append("\n})\n");
        return sb.toString();
    }
}

