/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.annotations.processors;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.annotations.processors.AbstractGenerator;
import org.uberfire.annotations.processors.GeneratorUtils;
import org.uberfire.annotations.processors.TemplateInformation;
import org.uberfire.annotations.processors.TemplateInformationHelper;
import org.uberfire.annotations.processors.exceptions.GenerationException;
import org.uberfire.annotations.processors.facades.ClientAPIModule;

public class PerspectiveActivityGenerator
extends AbstractGenerator {
    private static final Logger logger = LoggerFactory.getLogger(PerspectiveActivityGenerator.class);
    private Map<String, String> context = new HashMap<String, String>();

    @Override
    public StringBuffer generate(String packageName, PackageElement packageElement, String className, Element element, ProcessingEnvironment processingEnvironment) throws GenerationException {
        logger.debug("Starting code generation for [" + className + "]");
        TypeElement classElement = (TypeElement)element;
        String identifier = ClientAPIModule.getWbPerspectiveScreenIdentifierValueOnClass(classElement);
        boolean isDefault = ClientAPIModule.getWbPerspectiveScreenIsDefaultValueOnClass(classElement);
        boolean isTemplate = ClientAPIModule.getWbPerspectiveScreenIsATemplate(classElement);
        String onStartup0ParameterMethodName = GeneratorUtils.getOnStartupZeroParameterMethodName(classElement, processingEnvironment);
        String onStartup1ParameterMethodName = GeneratorUtils.getOnStartPlaceRequestParameterMethodName(classElement, processingEnvironment);
        String onCloseMethodName = GeneratorUtils.getOnCloseMethodName(classElement, processingEnvironment);
        String onShutdownMethodName = GeneratorUtils.getOnShutdownMethodName(classElement, processingEnvironment);
        String onOpenMethodName = GeneratorUtils.getOnOpenMethodName(classElement, processingEnvironment);
        String getPerspectiveMethodName = GeneratorUtils.getPerspectiveMethodName(classElement, processingEnvironment);
        String getMenuBarMethodName = GeneratorUtils.getMenuBarMethodName(classElement, processingEnvironment);
        String getToolBarMethodName = GeneratorUtils.getToolBarMethodName(classElement, processingEnvironment);
        String securityTraitList = GeneratorUtils.getSecurityTraitList(classElement);
        String rolesList = GeneratorUtils.getRoleList(classElement);
        logger.debug("Package name: " + packageName);
        logger.debug("Class name: " + className);
        logger.debug("Identifier: " + identifier);
        logger.debug("isDefault: " + isDefault);
        logger.debug("isTemplate: " + isTemplate);
        logger.debug("onStartup0ParameterMethodName: " + onStartup0ParameterMethodName);
        logger.debug("onStartup1ParameterMethodName: " + onStartup1ParameterMethodName);
        logger.debug("onCloseMethodName: " + onCloseMethodName);
        logger.debug("onShutdownMethodName: " + onShutdownMethodName);
        logger.debug("onOpenMethodName: " + onOpenMethodName);
        logger.debug("getPerspectiveMethodName: " + getPerspectiveMethodName);
        logger.debug("getMenuBarMethodName: " + getMenuBarMethodName);
        logger.debug("getToolBarMethodName: " + getToolBarMethodName);
        logger.debug("securityTraitList: " + securityTraitList);
        logger.debug("rolesList: " + rolesList);
        if (onStartup0ParameterMethodName != null && onStartup1ParameterMethodName != null) {
            String msg = "Found multiple @OnStartup methods. Each class can declare at most one.";
            throw new GenerationException("Found multiple @OnStartup methods. Each class can declare at most one.");
        }
        if (getPerspectiveMethodName == null && !isTemplate) {
            throw new GenerationException("The WorkbenchPerspective must provide a @Perspective annotated method to return a org.uberfire.client.workbench.model.PerspectiveDefinition.", packageName + "." + className);
        }
        if (isDefault) {
            this.warningIfMoreThanOneDefaultPerspective(processingEnvironment, identifier);
        }
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("packageName", packageName);
        root.put("className", className);
        root.put("identifier", identifier);
        root.put("isTemplate", isTemplate);
        root.put("isDefault", isDefault);
        root.put("realClassName", classElement.getSimpleName().toString());
        root.put("onStartup0ParameterMethodName", onStartup0ParameterMethodName);
        root.put("onStartup1ParameterMethodName", onStartup1ParameterMethodName);
        root.put("onCloseMethodName", onCloseMethodName);
        root.put("onShutdownMethodName", onShutdownMethodName);
        root.put("onOpenMethodName", onOpenMethodName);
        root.put("getPerspectiveMethodName", getPerspectiveMethodName);
        root.put("getMenuBarMethodName", getMenuBarMethodName);
        root.put("getToolBarMethodName", getToolBarMethodName);
        root.put("securityTraitList", securityTraitList);
        root.put("rolesList", rolesList);
        if (isTemplate) {
            PerspectiveActivityGenerator.setupTemplateElements(root, classElement);
        }
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        try {
            Template template = config.getTemplate("perspective.ftl");
            template.process(root, (Writer)bw);
        }
        catch (IOException ioe) {
            throw new GenerationException(ioe);
        }
        catch (TemplateException te) {
            throw new GenerationException(te);
        }
        finally {
            try {
                bw.close();
                sw.close();
            }
            catch (IOException ioe) {
                throw new GenerationException(ioe);
            }
        }
        logger.debug("Successfully generated code for [" + className + "]");
        return sw.getBuffer();
    }

    private void warningIfMoreThanOneDefaultPerspective(ProcessingEnvironment processingEnvironment, String perspectiveName) {
        String defaultPerspectivesName = "defaultPerspectivesName";
        String defaultPerspectives = this.context.get(defaultPerspectivesName);
        if (defaultPerspectives != null) {
            defaultPerspectives = defaultPerspectives + ", " + perspectiveName;
            this.generateMoreThanOneDefaultPerspectiveWarning(processingEnvironment, defaultPerspectives);
            this.context.put(defaultPerspectivesName, defaultPerspectives);
        } else {
            this.context.put(defaultPerspectivesName, perspectiveName);
        }
    }

    private void generateMoreThanOneDefaultPerspectiveWarning(ProcessingEnvironment processingEnvironment, String defaultPerspectives) {
        String msg = "There is more than one default WorkbenchPerspective (" + defaultPerspectives + ") - @WorkbenchPerspective(isDefault = true). One of them will take precedence.";
        processingEnvironment.getMessager().printMessage(Diagnostic.Kind.WARNING, msg);
        logger.warn(msg);
    }

    private static void setupTemplateElements(Map<String, Object> root, TypeElement classElement) throws GenerationException {
        TemplateInformation helper = TemplateInformationHelper.extractWbTemplatePerspectiveInformation(classElement);
        if (helper.getDefaultPanel() != null) {
            root.put("defaultPanel", helper.getDefaultPanel());
        }
        root.put("wbPanels", helper.getTemplateFields());
    }
}

