/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.annotations.processors;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.annotations.processors.AbstractGenerator;
import org.uberfire.annotations.processors.GeneratorUtils;
import org.uberfire.annotations.processors.exceptions.GenerationException;
import org.uberfire.annotations.processors.facades.ClientAPIModule;

public class ContextActivityGenerator
extends AbstractGenerator {
    private static final Logger logger = LoggerFactory.getLogger(ContextActivityGenerator.class);

    @Override
    public StringBuffer generate(String packageName, PackageElement packageElement, String className, Element element, ProcessingEnvironment processingEnvironment) throws GenerationException {
        logger.debug("Starting code generation for [" + className + "]");
        TypeElement classElement = (TypeElement)element;
        String identifier = ClientAPIModule.getWbContextIdentifierValueOnClass(classElement);
        String onOpenMethodName = GeneratorUtils.getOnOpenMethodName(classElement, processingEnvironment);
        String getOnContextAttachPanelDefinitionMethodName = GeneratorUtils.getOnContextAttachPanelDefinitionMethodName(classElement, processingEnvironment);
        String getTitleMethodName = GeneratorUtils.getTitleMethodName(classElement, processingEnvironment);
        ExecutableElement getTitleWidgetMethod = GeneratorUtils.getTitleWidgetMethodName(classElement, processingEnvironment);
        String getTitleWidgetMethodName = getTitleWidgetMethod == null ? null : getTitleWidgetMethod.getSimpleName().toString();
        ExecutableElement getWidgetMethod = GeneratorUtils.getWidgetMethodName(classElement, processingEnvironment);
        String getWidgetMethodName = getWidgetMethod == null ? null : getWidgetMethod.getSimpleName().toString();
        boolean hasUberView = GeneratorUtils.hasUberViewReference(classElement, processingEnvironment, getWidgetMethod);
        boolean isWidget = GeneratorUtils.getIsWidget(classElement, processingEnvironment);
        String securityTraitList = GeneratorUtils.getSecurityTraitList(classElement);
        String rolesList = GeneratorUtils.getRoleList(classElement);
        logger.debug("Package name: " + packageName);
        logger.debug("Class name: " + className);
        logger.debug("Identifier: " + identifier);
        logger.debug("onOpenMethodName: " + onOpenMethodName);
        logger.debug("getOnContextAttachPanelDefinitionMethodName: " + getOnContextAttachPanelDefinitionMethodName);
        logger.debug("getTitleMethodName: " + getTitleMethodName);
        logger.debug("getTitleWidgetMethodName: " + getTitleWidgetMethodName);
        logger.debug("getWidgetMethodName: " + getWidgetMethodName);
        logger.debug("isWidget: " + Boolean.toString(isWidget));
        logger.debug("hasUberView: " + Boolean.toString(hasUberView));
        logger.debug("securityTraitList: " + securityTraitList);
        logger.debug("rolesList: " + rolesList);
        if (!isWidget && getWidgetMethodName == null) {
            throw new GenerationException("The WorkbenchContext must either extend IsWidget or provide a @WorkbenchPartView annotated method to return a com.google.gwt.user.client.ui.IsWidget.", packageName + "." + className);
        }
        if (isWidget && getWidgetMethodName != null) {
            String msg = "The WorkbenchContext both extends com.google.gwt.user.client.ui.IsWidget and provides a @WorkbenchPartView annotated method. The annotated method will take precedence.";
            processingEnvironment.getMessager().printMessage(Diagnostic.Kind.WARNING, "The WorkbenchContext both extends com.google.gwt.user.client.ui.IsWidget and provides a @WorkbenchPartView annotated method. The annotated method will take precedence.");
            logger.warn("The WorkbenchContext both extends com.google.gwt.user.client.ui.IsWidget and provides a @WorkbenchPartView annotated method. The annotated method will take precedence.");
        }
        if (getTitleMethodName == null) {
            throw new GenerationException("The WorkbenchContext must provide a @WorkbenchPartTitle annotated method to return a java.lang.String.", packageName + "." + className);
        }
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("packageName", packageName);
        root.put("className", className);
        root.put("identifier", identifier);
        root.put("realClassName", classElement.getSimpleName().toString());
        root.put("onOpenMethodName", onOpenMethodName);
        root.put("getOnContextAttachPanelDefinitionMethodName", getOnContextAttachPanelDefinitionMethodName);
        root.put("getTitleMethodName", getTitleMethodName);
        root.put("getTitleWidgetMethodName", getTitleWidgetMethodName);
        root.put("getWidgetMethodName", getWidgetMethodName);
        root.put("isWidget", isWidget);
        root.put("hasUberView", hasUberView);
        root.put("securityTraitList", securityTraitList);
        root.put("rolesList", rolesList);
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        try {
            Template template = config.getTemplate("activityContext.ftl");
            template.process(root, (Writer)bw);
        }
        catch (IOException ioe) {
            throw new GenerationException(ioe);
        }
        catch (TemplateException te) {
            throw new GenerationException(te);
        }
        finally {
            try {
                bw.close();
                sw.close();
            }
            catch (IOException ioe) {
                throw new GenerationException(ioe);
            }
        }
        logger.debug("Successfully generated code for [" + className + "]");
        return sw.getBuffer();
    }
}

