/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.annotations.processors;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.annotations.processors.GenerationCompleteCallback;
import org.uberfire.annotations.processors.PopupActivityGenerator;
import org.uberfire.annotations.processors.exceptions.GenerationException;
import org.uberfire.annotations.processors.facades.ClientAPIModule;

@SupportedAnnotationTypes(value={"org.uberfire.client.annotations.WorkbenchPopup"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class WorkbenchPopupProcessor
extends AbstractProcessor {
    private static final Logger logger = LoggerFactory.getLogger(WorkbenchPopupProcessor.class);
    private final PopupActivityGenerator activityGenerator = new PopupActivityGenerator();
    private GenerationCompleteCallback callback = null;

    public WorkbenchPopupProcessor() {
    }

    WorkbenchPopupProcessor(GenerationCompleteCallback callback) {
        this.callback = callback;
        logger.info("GenerationCompleteCallback has been provided. Generated source code will not be compiled and hence classes will not be available.");
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return false;
        }
        if (roundEnv.errorRaised()) {
            return false;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(ClientAPIModule.getWorkbenchPopupClass())) {
            if (element.getKind() != ElementKind.CLASS) continue;
            TypeElement classElement = (TypeElement)element;
            PackageElement packageElement = (PackageElement)classElement.getEnclosingElement();
            logger.info("Discovered class [" + classElement.getSimpleName() + "]");
            String packageName = packageElement.getQualifiedName().toString();
            String classNameActivity = classElement.getSimpleName() + "Activity";
            try {
                logger.info("Generating code for [" + classNameActivity + "]");
                StringBuffer activityCode = this.activityGenerator.generate(packageName, packageElement, classNameActivity, classElement, this.processingEnv);
                if (this.callback == null) {
                    this.writeCode(packageName, classNameActivity, activityCode);
                    continue;
                }
                this.callback.generationComplete(activityCode.toString());
            }
            catch (GenerationException ge) {
                String msg = ge.getMessage();
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
                logger.error(msg);
            }
        }
        return true;
    }

    private void writeCode(String packageName, String className, StringBuffer code) {
        try {
            JavaFileObject jfo = this.processingEnv.getFiler().createSourceFile(packageName + "." + className, new Element[0]);
            Writer w = jfo.openWriter();
            BufferedWriter bw = new BufferedWriter(w);
            bw.append(code);
            bw.close();
            w.close();
        }
        catch (IOException ioe) {
            logger.error(ioe.getMessage(), (Throwable)ioe);
        }
    }
}

