/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.annotations.processors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleAnnotationValueVisitor6;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.uberfire.annotations.processors.exceptions.GenerationException;
import org.uberfire.annotations.processors.facades.APIModule;
import org.uberfire.annotations.processors.facades.BackendModule;
import org.uberfire.annotations.processors.facades.ClientAPIModule;
import org.uberfire.annotations.processors.facades.SecurityModule;

public class GeneratorUtils {
    private static final String[] NO_PARAMS = new String[0];
    private static final String[] ANY_PARAMS = new String[0];

    public static ExecutableElement getOnStartupMethodForNonEditors(TypeElement classElement, ProcessingEnvironment processingEnvironment) {
        Types typeUtils = processingEnvironment.getTypeUtils();
        NoType requiredReturnType = typeUtils.getNoType(TypeKind.VOID);
        List<ExecutableElement> onStartupMethods = GeneratorUtils.getAnnotatedMethods(classElement, processingEnvironment, APIModule.getOnStartupClass(), requiredReturnType, ANY_PARAMS);
        Elements elementUtils = processingEnvironment.getElementUtils();
        ExecutableElement zeroArgMethod = null;
        ExecutableElement oneArgMethod = null;
        for (ExecutableElement m : onStartupMethods) {
            if (GeneratorUtils.doParametersMatch(typeUtils, elementUtils, m, NO_PARAMS)) {
                zeroArgMethod = m;
                continue;
            }
            if (GeneratorUtils.doParametersMatch(typeUtils, elementUtils, m, new String[]{APIModule.getPlaceRequestClass()})) {
                oneArgMethod = m;
                continue;
            }
            processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, GeneratorUtils.formatProblemsList(APIModule.getOnStartupClass(), Collections.singletonList("take no arguments or one argument of type " + APIModule.getPlaceRequestClass())));
        }
        if (zeroArgMethod != null && oneArgMethod != null) {
            processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, "Found multiple @OnStartup methods. Each class can declare at most one.", zeroArgMethod);
        }
        if (oneArgMethod != null) {
            return oneArgMethod;
        }
        return zeroArgMethod;
    }

    public static ExecutableElement getOnStartupMethodForEditors(TypeElement classElement, ProcessingEnvironment processingEnvironment) {
        Types typeUtils = processingEnvironment.getTypeUtils();
        NoType requiredReturnType = typeUtils.getNoType(TypeKind.VOID);
        List<ExecutableElement> onStartupMethods = GeneratorUtils.getAnnotatedMethods(classElement, processingEnvironment, APIModule.getOnStartupClass(), requiredReturnType, ANY_PARAMS);
        Elements elementUtils = processingEnvironment.getElementUtils();
        ExecutableElement oneArgMethod = null;
        ExecutableElement twoArgMethod = null;
        for (ExecutableElement m : onStartupMethods) {
            if (GeneratorUtils.doParametersMatch(typeUtils, elementUtils, m, new String[]{BackendModule.getPathClass()})) {
                oneArgMethod = m;
                continue;
            }
            if (GeneratorUtils.doParametersMatch(typeUtils, elementUtils, m, new String[]{BackendModule.getPathClass(), APIModule.getPlaceRequestClass()})) {
                twoArgMethod = m;
                continue;
            }
            processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, GeneratorUtils.formatProblemsList(APIModule.getOnStartupClass(), Collections.singletonList("take one argument of type " + BackendModule.getPathClass() + " and an optional second argument of type " + APIModule.getPlaceRequestClass())));
        }
        if (oneArgMethod != null && twoArgMethod != null) {
            processingEnvironment.getMessager().printMessage(Diagnostic.Kind.WARNING, "There is also an @OnStartup(Path, PlaceRequest) method in this class. That method takes precedence over this one.", oneArgMethod);
        }
        if (twoArgMethod != null) {
            return twoArgMethod;
        }
        return oneArgMethod;
    }

    public static String getOnContextAttachPanelDefinitionMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getVoidMethodName(classElement, processingEnvironment, new String[]{APIModule.getPanelDefinitionClass()}, APIModule.getOnContextAttachClass());
    }

    public static String getOnMayCloseMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getBooleanMethodName(classElement, processingEnvironment, APIModule.getOnMayCloseClass());
    }

    public static String getOnCloseMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getVoidMethodName(classElement, processingEnvironment, APIModule.getOnCloseClass());
    }

    public static String getOnShutdownMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getVoidMethodName(classElement, processingEnvironment, APIModule.getOnShutdownlass());
    }

    public static String getOnOpenMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getVoidMethodName(classElement, processingEnvironment, APIModule.getOnOpenClass());
    }

    public static String getOnLostFocusMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getVoidMethodName(classElement, processingEnvironment, APIModule.getOnLostFocusClass());
    }

    public static String getOnFocusMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getVoidMethodName(classElement, processingEnvironment, APIModule.getOnFocusClass());
    }

    public static String getDefaultPositionMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getDefaultPositionMethodName(classElement, processingEnvironment, ClientAPIModule.getDefaultPositionClass());
    }

    public static String getTitleMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getStringMethodName(classElement, processingEnvironment, ClientAPIModule.getWorkbenchPartTitleClass());
    }

    public static String getContextIdMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getStringMethodName(classElement, processingEnvironment, ClientAPIModule.getWorkbenchContextIdClass());
    }

    public static ExecutableElement getTitleWidgetMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getWidgetMethodName(classElement, processingEnvironment, ClientAPIModule.getWorkbenchPartTitleDecorationsClass());
    }

    public static ExecutableElement getWidgetMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getWidgetMethodName(classElement, processingEnvironment, ClientAPIModule.getWorkbenchPartViewClass());
    }

    public static boolean getIsWidget(TypeElement classElement, ProcessingEnvironment processingEnvironment) {
        Types typeUtils = processingEnvironment.getTypeUtils();
        Elements elementUtils = processingEnvironment.getElementUtils();
        TypeMirror requiredReturnType = elementUtils.getTypeElement("com.google.gwt.user.client.ui.IsWidget").asType();
        return typeUtils.isAssignable(classElement.asType(), requiredReturnType);
    }

    public static boolean hasUberViewReference(TypeElement classElement, ProcessingEnvironment processingEnvironment, ExecutableElement getWidgetMethod) {
        if (getWidgetMethod == null) {
            return false;
        }
        Types typeUtils = processingEnvironment.getTypeUtils();
        Elements elementUtils = processingEnvironment.getElementUtils();
        TypeMirror requiredReturnType = elementUtils.getTypeElement("org.uberfire.client.mvp.UberView").asType();
        return typeUtils.isAssignable(typeUtils.erasure(getWidgetMethod.getReturnType()), requiredReturnType);
    }

    public static String getPopupMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getPopupMethodName(classElement, processingEnvironment, ClientAPIModule.getWorkbenchPartViewClass());
    }

    public static boolean getIsPopup(TypeElement classElement, ProcessingEnvironment processingEnvironment) {
        Types typeUtils = processingEnvironment.getTypeUtils();
        Elements elementUtils = processingEnvironment.getElementUtils();
        TypeMirror requiredReturnType = elementUtils.getTypeElement("com.google.gwt.user.client.ui.PopupPanel").asType();
        return typeUtils.isAssignable(classElement.asType(), requiredReturnType);
    }

    public static String getIsDirtyMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getBooleanMethodName(classElement, processingEnvironment, APIModule.getIsDirtyClass());
    }

    public static String getOnSaveMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getVoidMethodName(classElement, processingEnvironment, APIModule.getOnSaveClass());
    }

    public static String getMenuBarMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getMenuBarMethodName(classElement, processingEnvironment, ClientAPIModule.getWorkbenchMenuClass());
    }

    public static String getToolBarMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getToolBarMethodName(classElement, processingEnvironment, ClientAPIModule.getWorkbenchToolBarClass());
    }

    public static String getPerspectiveMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getMethodName(classElement, processingEnvironment, "org.uberfire.workbench.model.PerspectiveDefinition", ClientAPIModule.getPerspectiveClass());
    }

    public static String getSplashFilterMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getMethodName(classElement, processingEnvironment, "org.uberfire.workbench.model.SplashScreenFilter", ClientAPIModule.getSplashFilterClass());
    }

    public static String getBodyHeightMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getMethodName(classElement, processingEnvironment, "java.lang.Integer", ClientAPIModule.getSplashBodyHeightClass());
    }

    public static String getInterceptMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment) throws GenerationException {
        return GeneratorUtils.getMethodName(classElement, processingEnvironment, "java.lang.Boolean", ClientAPIModule.getInterceptClass());
    }

    public static String getBeanActivatorClassName(TypeElement classElement, ProcessingEnvironment processingEnvironment) {
        AnnotationMirror activatedByAnnotation = GeneratorUtils.getAnnotation(processingEnvironment.getElementUtils(), classElement, "org.jboss.errai.ioc.client.api.ActivatedBy");
        if (activatedByAnnotation != null) {
            return GeneratorUtils.extractAnnotationStringValue(processingEnvironment.getElementUtils(), activatedByAnnotation, "value");
        }
        return null;
    }

    public static String getOwningPerspectivePlaceRequest(TypeElement screenOrEditorClass, ProcessingEnvironment processingEnvironment) throws GenerationException {
        AnnotationValue owningPerspectiveParam;
        TypeElement owningPerspectiveType;
        Elements elementUtils = processingEnvironment.getElementUtils();
        Types typeUtils = processingEnvironment.getTypeUtils();
        AnnotationMirror screenOrEditorAnnotation = GeneratorUtils.getAnnotation(elementUtils, screenOrEditorClass, "org.uberfire.client.annotations.WorkbenchScreen");
        if (screenOrEditorAnnotation == null) {
            screenOrEditorAnnotation = GeneratorUtils.getAnnotation(elementUtils, screenOrEditorClass, "org.uberfire.client.annotations.WorkbenchEditor");
        }
        if ((owningPerspectiveType = (TypeElement)typeUtils.asElement((TypeMirror)(owningPerspectiveParam = GeneratorUtils.extractAnnotationPropertyValue(elementUtils, screenOrEditorAnnotation, "owningPerspective")).getValue())) == null) {
            return null;
        }
        String owningPerspectivePlace = ClientAPIModule.getWbPerspectiveScreenIdentifierValueOnClass(owningPerspectiveType);
        if (owningPerspectivePlace.equals("")) {
            processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, "owningPerspective must be a class annotated with @WorkbenchPerspective.", screenOrEditorClass, screenOrEditorAnnotation, owningPerspectiveParam);
            return null;
        }
        return owningPerspectivePlace;
    }

    private static String getVoidMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment, String annotationName) throws GenerationException {
        Types typeUtils = processingEnvironment.getTypeUtils();
        NoType requiredReturnType = typeUtils.getNoType(TypeKind.VOID);
        ExecutableElement match = GeneratorUtils.getUniqueAnnotatedMethod(classElement, processingEnvironment, annotationName, requiredReturnType, NO_PARAMS);
        if (match == null) {
            return null;
        }
        return match.getSimpleName().toString();
    }

    private static String getVoidMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment, String[] parameterTypes, String annotationName) throws GenerationException {
        Types typeUtils = processingEnvironment.getTypeUtils();
        Elements elementUtils = processingEnvironment.getElementUtils();
        NoType requiredReturnType = typeUtils.getNoType(TypeKind.VOID);
        List<ExecutableElement> methods = ElementFilter.methodsIn(classElement.getEnclosedElements());
        ExecutableElement match = null;
        for (ExecutableElement e : methods) {
            TypeMirror actualReturnType = e.getReturnType();
            if (GeneratorUtils.getAnnotation(elementUtils, e, annotationName) == null || !typeUtils.isSameType(actualReturnType, requiredReturnType) || !GeneratorUtils.doParametersMatch(typeUtils, elementUtils, e, parameterTypes) || e.getModifiers().contains((Object)Modifier.STATIC) || !e.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            if (match != null) {
                throw new GenerationException("Multiple methods with @" + GeneratorUtils.fqcnToSimpleName(annotationName) + " detected.");
            }
            match = e;
        }
        if (match == null) {
            return null;
        }
        return match.getSimpleName().toString();
    }

    private static boolean doParametersMatch(Types typeUtils, Elements elementUtils, ExecutableElement e, String[] requiredParameterTypes) {
        if (requiredParameterTypes == ANY_PARAMS) {
            return true;
        }
        if (e.getParameters().size() != requiredParameterTypes.length) {
            return false;
        }
        ArrayList<TypeMirror> requiredTypes = new ArrayList<TypeMirror>();
        for (String parameterType : requiredParameterTypes) {
            requiredTypes.add(elementUtils.getTypeElement(parameterType).asType());
        }
        for (int i = 0; i < requiredTypes.size(); ++i) {
            TypeMirror requiredType;
            TypeMirror actualType = e.getParameters().get(i).asType();
            if (typeUtils.isAssignable(actualType, requiredType = (TypeMirror)requiredTypes.get(i))) continue;
            return false;
        }
        return true;
    }

    private static String getBooleanMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment, String annotationName) throws GenerationException {
        Elements elementUtils = processingEnvironment.getElementUtils();
        TypeMirror requiredReturnType = elementUtils.getTypeElement(Boolean.class.getName()).asType();
        ExecutableElement match = GeneratorUtils.getUniqueAnnotatedMethod(classElement, processingEnvironment, annotationName, requiredReturnType, NO_PARAMS);
        if (match == null) {
            return null;
        }
        return match.getSimpleName().toString();
    }

    private static String getStringMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment, String annotationName) throws GenerationException {
        Elements elementUtils = processingEnvironment.getElementUtils();
        ExecutableElement match = GeneratorUtils.getUniqueAnnotatedMethod(classElement, processingEnvironment, annotationName, elementUtils.getTypeElement(String.class.getName()).asType(), NO_PARAMS);
        if (match == null) {
            return null;
        }
        return match.getSimpleName().toString();
    }

    private static ExecutableElement getWidgetMethodName(TypeElement originalClassElement, ProcessingEnvironment processingEnvironment, String annotationName) throws GenerationException {
        Elements elementUtils = processingEnvironment.getElementUtils();
        return GeneratorUtils.getUniqueAnnotatedMethod(originalClassElement, processingEnvironment, annotationName, elementUtils.getTypeElement("com.google.gwt.user.client.ui.IsWidget").asType(), NO_PARAMS);
    }

    private static ExecutableElement getUniqueAnnotatedMethod(TypeElement originalClassElement, ProcessingEnvironment processingEnvironment, String annotationName, TypeMirror requiredReturnType, String[] requiredParameterTypes) {
        List<ExecutableElement> matches = GeneratorUtils.getAnnotatedMethods(originalClassElement, processingEnvironment, annotationName, requiredReturnType, requiredParameterTypes);
        if (matches.size() == 1) {
            return matches.get(0);
        }
        if (matches.size() > 1) {
            for (ExecutableElement match : matches) {
                processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, "Found multiple methods annotated with @" + GeneratorUtils.fqcnToSimpleName(annotationName) + ". There should only be one.", match);
            }
        }
        return null;
    }

    private static List<ExecutableElement> getAnnotatedMethods(TypeElement originalClassElement, ProcessingEnvironment processingEnvironment, String annotationName, TypeMirror requiredReturnType, String[] requiredParameterTypes) {
        Types typeUtils = processingEnvironment.getTypeUtils();
        Elements elementUtils = processingEnvironment.getElementUtils();
        TypeElement classElement = originalClassElement;
        while (true) {
            List<ExecutableElement> methods = ElementFilter.methodsIn(classElement.getEnclosedElements());
            ArrayList<ExecutableElement> matches = new ArrayList<ExecutableElement>();
            for (ExecutableElement e : methods) {
                TypeMirror actualReturnType = e.getReturnType();
                if (GeneratorUtils.getAnnotation(elementUtils, e, annotationName) == null) continue;
                ArrayList<String> problems = new ArrayList<String>();
                if (!typeUtils.isAssignable(actualReturnType, requiredReturnType)) {
                    problems.add("return " + requiredReturnType);
                }
                if (!GeneratorUtils.doParametersMatch(typeUtils, elementUtils, e, requiredParameterTypes)) {
                    if (requiredParameterTypes.length == 0) {
                        problems.add("take no parameters");
                    } else {
                        StringBuilder sb = new StringBuilder();
                        sb.append("take ").append(requiredParameterTypes).append(" parameters of type (");
                        boolean first = true;
                        for (String p : requiredParameterTypes) {
                            if (!first) {
                                sb.append(", ");
                            }
                            sb.append(p);
                            first = false;
                        }
                        sb.append(")");
                        problems.add(sb.toString());
                    }
                }
                if (e.getModifiers().contains((Object)Modifier.STATIC)) {
                    problems.add("be non-static");
                }
                if (e.getModifiers().contains((Object)Modifier.PRIVATE)) {
                    problems.add("be non-private");
                }
                if (problems.isEmpty()) {
                    matches.add(e);
                    continue;
                }
                processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, GeneratorUtils.formatProblemsList(annotationName, problems), e);
            }
            if (!matches.isEmpty()) {
                return matches;
            }
            TypeMirror superclass = classElement.getSuperclass();
            if (!(superclass instanceof DeclaredType)) break;
            classElement = (TypeElement)((DeclaredType)superclass).asElement();
        }
        return Collections.emptyList();
    }

    static String formatProblemsList(String annotationFqcn, List<String> problems) {
        StringBuilder msg = new StringBuilder();
        msg.append("Methods annotated with @").append(GeneratorUtils.fqcnToSimpleName(annotationFqcn)).append(" must ");
        for (int i = 0; i < problems.size(); ++i) {
            if (problems.size() > 2 && i > 0) {
                msg.append(", ");
            }
            if (problems.size() == 2 && i == 1) {
                msg.append(" and ");
            }
            if (problems.size() > 2 && i == problems.size() - 1) {
                msg.append("and ");
            }
            msg.append(problems.get(i));
        }
        return msg.toString();
    }

    private static String getPopupMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment, String annotationName) throws GenerationException {
        Types typeUtils = processingEnvironment.getTypeUtils();
        Elements elementUtils = processingEnvironment.getElementUtils();
        TypeMirror requiredReturnType = elementUtils.getTypeElement("com.google.gwt.user.client.ui.PopupPanel").asType();
        List<ExecutableElement> methods = ElementFilter.methodsIn(classElement.getEnclosedElements());
        ExecutableElement match = null;
        for (ExecutableElement e : methods) {
            TypeMirror actualReturnType = e.getReturnType();
            if (GeneratorUtils.getAnnotation(elementUtils, e, annotationName) == null || !typeUtils.isAssignable(actualReturnType, requiredReturnType) || e.getParameters().size() != 0 || e.getModifiers().contains((Object)Modifier.STATIC) || !e.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            if (match != null) {
                throw new GenerationException("Multiple methods with @" + GeneratorUtils.fqcnToSimpleName(annotationName) + " detected.");
            }
            match = e;
        }
        if (match == null) {
            return null;
        }
        return match.getSimpleName().toString();
    }

    private static String getDefaultPositionMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment, String annotationName) throws GenerationException {
        Types typeUtils = processingEnvironment.getTypeUtils();
        Elements elementUtils = processingEnvironment.getElementUtils();
        TypeMirror requiredReturnType = elementUtils.getTypeElement(APIModule.getPositionClass()).asType();
        List<ExecutableElement> methods = ElementFilter.methodsIn(classElement.getEnclosedElements());
        ExecutableElement match = null;
        for (ExecutableElement e : methods) {
            TypeMirror actualReturnType = e.getReturnType();
            if (GeneratorUtils.getAnnotation(elementUtils, e, annotationName) == null || !typeUtils.isAssignable(actualReturnType, requiredReturnType) || e.getParameters().size() != 0 || e.getModifiers().contains((Object)Modifier.STATIC) || !e.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            if (match != null) {
                throw new GenerationException("Multiple methods with @" + GeneratorUtils.fqcnToSimpleName(annotationName) + " detected.");
            }
            match = e;
        }
        if (match == null) {
            return null;
        }
        return match.getSimpleName().toString();
    }

    public static AnnotationMirror getAnnotation(Elements elementUtils, Element annotationTarget, String annotationName) {
        for (AnnotationMirror annotationMirror : elementUtils.getAllAnnotationMirrors(annotationTarget)) {
            if (!annotationName.contentEquals(GeneratorUtils.getQualifiedName(annotationMirror))) continue;
            return annotationMirror;
        }
        return null;
    }

    public static Name getQualifiedName(AnnotationMirror annotation) {
        return ((TypeElement)annotation.getAnnotationType().asElement()).getQualifiedName();
    }

    private static String getMenuBarMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment, String annotationName) throws GenerationException {
        Types typeUtils = processingEnvironment.getTypeUtils();
        Elements elementUtils = processingEnvironment.getElementUtils();
        TypeMirror requiredReturnType = elementUtils.getTypeElement("org.uberfire.workbench.model.menu.Menus").asType();
        List<ExecutableElement> methods = ElementFilter.methodsIn(classElement.getEnclosedElements());
        ExecutableElement match = null;
        for (ExecutableElement e : methods) {
            TypeMirror actualReturnType = e.getReturnType();
            if (GeneratorUtils.getAnnotation(elementUtils, e, annotationName) == null || !typeUtils.isAssignable(actualReturnType, requiredReturnType) || e.getParameters().size() != 0 || e.getModifiers().contains((Object)Modifier.STATIC) || !e.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            if (match != null) {
                throw new GenerationException("Multiple methods with @" + GeneratorUtils.fqcnToSimpleName(annotationName) + " detected.");
            }
            match = e;
        }
        if (match == null) {
            return null;
        }
        return match.getSimpleName().toString();
    }

    private static String getToolBarMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment, String annotationName) throws GenerationException {
        Types typeUtils = processingEnvironment.getTypeUtils();
        Elements elementUtils = processingEnvironment.getElementUtils();
        TypeMirror requiredReturnType = elementUtils.getTypeElement("org.uberfire.workbench.model.toolbar.ToolBar").asType();
        List<ExecutableElement> methods = ElementFilter.methodsIn(classElement.getEnclosedElements());
        ExecutableElement match = null;
        for (ExecutableElement e : methods) {
            TypeMirror actualReturnType = e.getReturnType();
            if (GeneratorUtils.getAnnotation(elementUtils, e, annotationName) == null || !typeUtils.isAssignable(actualReturnType, requiredReturnType) || e.getParameters().size() != 0 || e.getModifiers().contains((Object)Modifier.STATIC) || !e.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            if (match != null) {
                throw new GenerationException("Multiple methods with @" + GeneratorUtils.fqcnToSimpleName(annotationName) + " detected.");
            }
            match = e;
        }
        if (match == null) {
            return null;
        }
        return match.getSimpleName().toString();
    }

    private static String getMethodName(TypeElement classElement, ProcessingEnvironment processingEnvironment, String expectedReturnType, String annotationName) throws GenerationException {
        Elements elementUtils = processingEnvironment.getElementUtils();
        TypeMirror requiredReturnType = elementUtils.getTypeElement(expectedReturnType).asType();
        ExecutableElement match = GeneratorUtils.getUniqueAnnotatedMethod(classElement, processingEnvironment, annotationName, requiredReturnType, NO_PARAMS);
        if (match == null) {
            return null;
        }
        return match.getSimpleName().toString();
    }

    public static String getSecurityTraitList(Elements elementUtils, Element element) throws GenerationException {
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        HashSet<String> traits = new HashSet<String>(annotationMirrors.size());
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            Element annotationElement = annotationMirror.getAnnotationType().asElement();
            if (GeneratorUtils.getAnnotation(elementUtils, annotationElement, SecurityModule.getSecurityTraitClass()) == null) continue;
            traits.add(((Object)annotationElement.asType()).toString());
        }
        if (traits.isEmpty()) {
            return null;
        }
        return GeneratorUtils.collectionAsString(traits);
    }

    public static String getRoleList(Elements elementUtils, Element element) throws GenerationException {
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        HashSet<String> result = new HashSet<String>();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (GeneratorUtils.getAnnotation(elementUtils, annotationMirror.getAnnotationType().asElement(), SecurityModule.getRolesTypeClass()) == null) continue;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!entry.getKey().getSimpleName().toString().equals("value")) continue;
                result.addAll(GeneratorUtils.extractValue(entry.getValue()));
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        return GeneratorUtils.collectionAsString(result);
    }

    public static Collection<String> extractValue(AnnotationValue value) {
        if (value.getValue() instanceof Collection) {
            List varray = (List)value.getValue();
            ArrayList<String> result = new ArrayList<String>(varray.size());
            for (Object active : varray) {
                result.addAll(GeneratorUtils.extractValue((AnnotationValue)active));
            }
            return result;
        }
        return Collections.singleton(value.getValue().toString());
    }

    public static List<AnnotationMirror> extractAnnotationsFromAnnotation(Elements elementUtils, Element element, String annotationName, String paramName) {
        AnnotationMirror am = GeneratorUtils.getAnnotation(elementUtils, element, annotationName);
        AnnotationValue nestedAnnotations = GeneratorUtils.extractAnnotationPropertyValue(elementUtils, am, paramName);
        if (nestedAnnotations == null) {
            return Collections.emptyList();
        }
        final ArrayList<AnnotationMirror> result = new ArrayList<AnnotationMirror>();
        nestedAnnotations.accept(new SimpleAnnotationValueVisitor6<Void, Void>(){

            @Override
            public Void visitArray(List<? extends AnnotationValue> vals, Void x) {
                for (AnnotationValue annotationValue : vals) {
                    annotationValue.accept(new SimpleAnnotationValueVisitor6<Void, Void>(){

                        @Override
                        public Void visitAnnotation(AnnotationMirror am, Void x) {
                            result.add(am);
                            return null;
                        }
                    }, null);
                }
                return null;
            }
        }, null);
        return result;
    }

    private static String collectionAsString(Collection<String> collection) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> iterator = collection.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            String next = iterator.next();
            sb.append('\"').append(next).append('\"');
            if (i + 1 < collection.size()) {
                sb.append(", ");
            }
            ++i;
        }
        return sb.toString();
    }

    public static String formatAssociatedResources(Collection<String> resourceTypes) {
        if (resourceTypes == null || resourceTypes.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("@AssociatedResources").append("({\n");
        for (String resourceType : resourceTypes) {
            sb.append("    ").append(resourceType).append(".class").append(",\n");
        }
        sb.delete(sb.length() - 2, sb.length());
        sb.append("\n})\n");
        return sb.toString();
    }

    private static String fqcnToSimpleName(String fqcn) {
        int lastIndexOfDot = fqcn.lastIndexOf(46);
        if (lastIndexOfDot != -1) {
            return fqcn.substring(lastIndexOfDot + 1);
        }
        return fqcn;
    }

    public static boolean debugLoggingEnabled() {
        return Boolean.parseBoolean(System.getProperty("org.uberfire.processors.debug", "false"));
    }

    public static String extractAnnotationStringValue(Elements elementUtils, AnnotationMirror annotation, CharSequence paramName) {
        AnnotationValue av = GeneratorUtils.extractAnnotationPropertyValue(elementUtils, annotation, paramName);
        if (av != null && av.getValue() != null) {
            return av.getValue().toString();
        }
        return null;
    }

    static AnnotationValue extractAnnotationPropertyValue(Elements elementUtils, AnnotationMirror annotation, CharSequence annotationProperty) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> annotationParams = elementUtils.getElementValuesWithDefaults(annotation);
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> param : annotationParams.entrySet()) {
            if (!param.getKey().getSimpleName().contentEquals(annotationProperty)) continue;
            return param.getValue();
        }
        return null;
    }
}

