/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.annotations.processors;

import java.io.IOException;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import org.uberfire.annotations.processors.AbstractErrorAbsorbingProcessor;
import org.uberfire.annotations.processors.GenerationCompleteCallback;
import org.uberfire.annotations.processors.PopupActivityGenerator;
import org.uberfire.annotations.processors.exceptions.GenerationException;
import org.uberfire.annotations.processors.facades.ClientAPIModule;

@SupportedAnnotationTypes(value={"org.uberfire.client.annotations.WorkbenchPopup"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class WorkbenchPopupProcessor
extends AbstractErrorAbsorbingProcessor {
    private final PopupActivityGenerator activityGenerator;
    private GenerationCompleteCallback callback = null;

    public WorkbenchPopupProcessor() {
        PopupActivityGenerator ag = null;
        try {
            ag = new PopupActivityGenerator();
        }
        catch (Throwable t) {
            this.rememberInitializationError(t);
        }
        this.activityGenerator = ag;
    }

    WorkbenchPopupProcessor(GenerationCompleteCallback callback) {
        this();
        this.callback = callback;
        System.out.println("GenerationCompleteCallback has been provided. Generated source code will not be compiled and hence classes will not be available.");
    }

    @Override
    public boolean processWithExceptions(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws IOException {
        if (roundEnv.processingOver()) {
            return false;
        }
        if (roundEnv.errorRaised()) {
            return false;
        }
        Messager messager = this.processingEnv.getMessager();
        Elements elementUtils = this.processingEnv.getElementUtils();
        for (Element element : roundEnv.getElementsAnnotatedWith(elementUtils.getTypeElement(ClientAPIModule.getWorkbenchPopupClass()))) {
            if (element.getKind() != ElementKind.CLASS) continue;
            TypeElement classElement = (TypeElement)element;
            PackageElement packageElement = (PackageElement)classElement.getEnclosingElement();
            messager.printMessage(Diagnostic.Kind.NOTE, "Discovered class [" + classElement.getSimpleName() + "]");
            String packageName = packageElement.getQualifiedName().toString();
            String classNameActivity = classElement.getSimpleName() + "Activity";
            try {
                messager.printMessage(Diagnostic.Kind.NOTE, "Generating code for [" + classNameActivity + "]");
                StringBuffer activityCode = this.activityGenerator.generate(packageName, packageElement, classNameActivity, classElement, this.processingEnv);
                if (this.callback == null) {
                    this.writeCode(packageName, classNameActivity, activityCode);
                    continue;
                }
                this.callback.generationComplete(activityCode.toString());
            }
            catch (GenerationException ge) {
                String msg = ge.getMessage();
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, classElement);
            }
        }
        return true;
    }
}

