/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.relocated.freemarker.template.utility;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.uberfire.relocated.freemarker.core.Environment;
import org.uberfire.relocated.freemarker.core.ParseException;

public class StringUtil {
    private static final char[] ESCAPES = StringUtil.createEscapes();

    public static String HTMLEnc(String s) {
        return StringUtil.XMLEncNA(s);
    }

    public static String XMLEnc(String s) {
        return StringUtil.XMLOrXHTMLEnc(s, "&apos;");
    }

    public static String XHTMLEnc(String s) {
        return StringUtil.XMLOrXHTMLEnc(s, "&#39;");
    }

    private static String XMLOrXHTMLEnc(String s, String aposReplacement) {
        int ln = s.length();
        for (int i = 0; i < ln; ++i) {
            char c = s.charAt(i);
            if (c != '<' && c != '>' && c != '&' && c != '\"' && c != '\'') continue;
            StringBuffer b = new StringBuffer(s.substring(0, i));
            switch (c) {
                case '<': {
                    b.append("&lt;");
                    break;
                }
                case '>': {
                    b.append("&gt;");
                    break;
                }
                case '&': {
                    b.append("&amp;");
                    break;
                }
                case '\"': {
                    b.append("&quot;");
                    break;
                }
                case '\'': {
                    b.append(aposReplacement);
                }
            }
            int next = ++i;
            while (i < ln) {
                c = s.charAt(i);
                if (c == '<' || c == '>' || c == '&' || c == '\"' || c == '\'') {
                    b.append(s.substring(next, i));
                    switch (c) {
                        case '<': {
                            b.append("&lt;");
                            break;
                        }
                        case '>': {
                            b.append("&gt;");
                            break;
                        }
                        case '&': {
                            b.append("&amp;");
                            break;
                        }
                        case '\"': {
                            b.append("&quot;");
                            break;
                        }
                        case '\'': {
                            b.append(aposReplacement);
                        }
                    }
                    next = i + 1;
                }
                ++i;
            }
            if (next < ln) {
                b.append(s.substring(next));
            }
            s = b.toString();
            break;
        }
        return s;
    }

    public static String XMLEncNA(String s) {
        int ln = s.length();
        for (int i = 0; i < ln; ++i) {
            char c = s.charAt(i);
            if (c != '<' && c != '>' && c != '&' && c != '\"') continue;
            StringBuffer b = new StringBuffer(s.substring(0, i));
            switch (c) {
                case '<': {
                    b.append("&lt;");
                    break;
                }
                case '>': {
                    b.append("&gt;");
                    break;
                }
                case '&': {
                    b.append("&amp;");
                    break;
                }
                case '\"': {
                    b.append("&quot;");
                }
            }
            int next = ++i;
            while (i < ln) {
                c = s.charAt(i);
                if (c == '<' || c == '>' || c == '&' || c == '\"') {
                    b.append(s.substring(next, i));
                    switch (c) {
                        case '<': {
                            b.append("&lt;");
                            break;
                        }
                        case '>': {
                            b.append("&gt;");
                            break;
                        }
                        case '&': {
                            b.append("&amp;");
                            break;
                        }
                        case '\"': {
                            b.append("&quot;");
                        }
                    }
                    next = i + 1;
                }
                ++i;
            }
            if (next < ln) {
                b.append(s.substring(next));
            }
            s = b.toString();
            break;
        }
        return s;
    }

    public static String XMLEncQAttr(String s) {
        int ln = s.length();
        for (int i = 0; i < ln; ++i) {
            char c = s.charAt(i);
            if (c != '<' && c != '&' && c != '\"') continue;
            StringBuffer b = new StringBuffer(s.substring(0, i));
            switch (c) {
                case '<': {
                    b.append("&lt;");
                    break;
                }
                case '&': {
                    b.append("&amp;");
                    break;
                }
                case '\"': {
                    b.append("&quot;");
                }
            }
            int next = ++i;
            while (i < ln) {
                c = s.charAt(i);
                if (c == '<' || c == '&' || c == '\"') {
                    b.append(s.substring(next, i));
                    switch (c) {
                        case '<': {
                            b.append("&lt;");
                            break;
                        }
                        case '&': {
                            b.append("&amp;");
                            break;
                        }
                        case '\"': {
                            b.append("&quot;");
                        }
                    }
                    next = i + 1;
                }
                ++i;
            }
            if (next < ln) {
                b.append(s.substring(next));
            }
            s = b.toString();
            break;
        }
        return s;
    }

    public static String XMLEncNQG(String s) {
        int ln = s.length();
        for (int i = 0; i < ln; ++i) {
            char c = s.charAt(i);
            if (c != '<' && (c != '>' || i <= 1 || s.charAt(i - 1) != ']' || s.charAt(i - 2) != ']') && c != '&') continue;
            StringBuffer b = new StringBuffer(s.substring(0, i));
            switch (c) {
                case '<': {
                    b.append("&lt;");
                    break;
                }
                case '>': {
                    b.append("&gt;");
                    break;
                }
                case '&': {
                    b.append("&amp;");
                    break;
                }
                default: {
                    throw new RuntimeException("Bug: unexpected char");
                }
            }
            int next = ++i;
            while (i < ln) {
                c = s.charAt(i);
                if (c == '<' || c == '>' && i > 1 && s.charAt(i - 1) == ']' && s.charAt(i - 2) == ']' || c == '&') {
                    b.append(s.substring(next, i));
                    switch (c) {
                        case '<': {
                            b.append("&lt;");
                            break;
                        }
                        case '>': {
                            b.append("&gt;");
                            break;
                        }
                        case '&': {
                            b.append("&amp;");
                            break;
                        }
                        default: {
                            throw new RuntimeException("Bug: unexpected char");
                        }
                    }
                    next = i + 1;
                }
                ++i;
            }
            if (next < ln) {
                b.append(s.substring(next));
            }
            s = b.toString();
            break;
        }
        return s;
    }

    public static String RTFEnc(String s) {
        int ln = s.length();
        for (int i = 0; i < ln; ++i) {
            char c = s.charAt(i);
            if (c != '\\' && c != '{' && c != '}') continue;
            StringBuffer b = new StringBuffer(s.substring(0, i));
            switch (c) {
                case '\\': {
                    b.append("\\\\");
                    break;
                }
                case '{': {
                    b.append("\\{");
                    break;
                }
                case '}': {
                    b.append("\\}");
                }
            }
            int next = ++i;
            while (i < ln) {
                c = s.charAt(i);
                if (c == '\\' || c == '{' || c == '}') {
                    b.append(s.substring(next, i));
                    switch (c) {
                        case '\\': {
                            b.append("\\\\");
                            break;
                        }
                        case '{': {
                            b.append("\\{");
                            break;
                        }
                        case '}': {
                            b.append("\\}");
                        }
                    }
                    next = i + 1;
                }
                ++i;
            }
            if (next < ln) {
                b.append(s.substring(next));
            }
            s = b.toString();
            break;
        }
        return s;
    }

    public static String URLEnc(String s, String charset) throws UnsupportedEncodingException {
        char c;
        int i;
        int ln = s.length();
        for (i = 0; i < ln && ((c = s.charAt(i)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '-' || c == '.' || c == '!' || c == '~' || c >= '\'' && c <= '*'); ++i) {
        }
        if (i == ln) {
            return s;
        }
        StringBuffer b = new StringBuffer(ln + ln / 3 + 2);
        b.append(s.substring(0, i));
        int encstart = i++;
        while (i < ln) {
            char c2 = s.charAt(i);
            if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 == '_' || c2 == '-' || c2 == '.' || c2 == '!' || c2 == '~' || c2 >= '\'' && c2 <= '*') {
                if (encstart != -1) {
                    byte[] o = s.substring(encstart, i).getBytes(charset);
                    for (int j = 0; j < o.length; ++j) {
                        b.append('%');
                        byte bc = o[j];
                        int c1 = bc & 0xF;
                        int c22 = bc >> 4 & 0xF;
                        b.append((char)(c22 < 10 ? c22 + 48 : c22 - 10 + 65));
                        b.append((char)(c1 < 10 ? c1 + 48 : c1 - 10 + 65));
                    }
                    encstart = -1;
                }
                b.append(c2);
            } else if (encstart == -1) {
                encstart = i;
            }
            ++i;
        }
        if (encstart != -1) {
            byte[] o = s.substring(encstart, i).getBytes(charset);
            for (int j = 0; j < o.length; ++j) {
                b.append('%');
                byte bc = o[j];
                int c1 = bc & 0xF;
                int c2 = bc >> 4 & 0xF;
                b.append((char)(c2 < 10 ? c2 + 48 : c2 - 10 + 65));
                b.append((char)(c1 < 10 ? c1 + 48 : c1 - 10 + 65));
            }
        }
        return b.toString();
    }

    private static char[] createEscapes() {
        char[] escapes = new char[93];
        for (int i = 0; i < 32; ++i) {
            escapes[i] = '\u0001';
        }
        escapes[92] = 92;
        escapes[39] = 39;
        escapes[34] = 34;
        escapes[60] = 108;
        escapes[62] = 103;
        escapes[38] = 97;
        escapes[8] = 98;
        escapes[9] = 116;
        escapes[10] = 110;
        escapes[12] = 102;
        escapes[13] = 114;
        escapes[36] = 36;
        return escapes;
    }

    public static String FTLStringLiteralEnc(String s) {
        StringBuffer buf = null;
        int l = s.length();
        int el = ESCAPES.length;
        block4: for (int i = 0; i < l; ++i) {
            char c = s.charAt(i);
            if (c < el) {
                char escape = ESCAPES[c];
                switch (escape) {
                    case '\u0000': {
                        if (buf == null) continue block4;
                        buf.append(c);
                        break;
                    }
                    case '\u0001': {
                        if (buf == null) {
                            buf = new StringBuffer(s.length() + 3);
                            buf.append(s.substring(0, i));
                        }
                        buf.append("\\x00");
                        int c2 = c >> 4 & 0xF;
                        c = (char)(c & 0xF);
                        buf.append((char)(c2 < 10 ? c2 + 48 : c2 - 10 + 65));
                        buf.append((char)(c < '\n' ? c + 48 : c - 10 + 65));
                        break;
                    }
                    default: {
                        if (buf == null) {
                            buf = new StringBuffer(s.length() + 2);
                            buf.append(s.substring(0, i));
                        }
                        buf.append('\\');
                        buf.append(escape);
                        break;
                    }
                }
                continue;
            }
            if (buf == null) continue;
            buf.append(c);
        }
        return buf == null ? s : buf.toString();
    }

    public static String FTLStringLiteralDec(String s) throws ParseException {
        int idx = s.indexOf(92);
        if (idx == -1) {
            return s;
        }
        int lidx = s.length() - 1;
        int bidx = 0;
        StringBuffer buf = new StringBuffer(lidx);
        do {
            buf.append(s.substring(bidx, idx));
            if (idx >= lidx) {
                throw new ParseException("The last character of string literal is backslash", 0, 0);
            }
            char c = s.charAt(idx + 1);
            switch (c) {
                case '\"': {
                    buf.append('\"');
                    bidx = idx + 2;
                    break;
                }
                case '\'': {
                    buf.append('\'');
                    bidx = idx + 2;
                    break;
                }
                case '\\': {
                    buf.append('\\');
                    bidx = idx + 2;
                    break;
                }
                case 'n': {
                    buf.append('\n');
                    bidx = idx + 2;
                    break;
                }
                case 'r': {
                    buf.append('\r');
                    bidx = idx + 2;
                    break;
                }
                case 't': {
                    buf.append('\t');
                    bidx = idx + 2;
                    break;
                }
                case 'f': {
                    buf.append('\f');
                    bidx = idx + 2;
                    break;
                }
                case 'b': {
                    buf.append('\b');
                    bidx = idx + 2;
                    break;
                }
                case 'g': {
                    buf.append('>');
                    bidx = idx + 2;
                    break;
                }
                case 'l': {
                    buf.append('<');
                    bidx = idx + 2;
                    break;
                }
                case 'a': {
                    buf.append('&');
                    bidx = idx + 2;
                    break;
                }
                case '{': {
                    buf.append('{');
                    bidx = idx + 2;
                    break;
                }
                case 'x': {
                    int z;
                    int x = idx += 2;
                    int y = 0;
                    int n = z = lidx > idx + 3 ? idx + 3 : lidx;
                    while (idx <= z) {
                        char b = s.charAt(idx);
                        if (b >= '0' && b <= '9') {
                            y <<= 4;
                            y += b - 48;
                        } else if (b >= 'a' && b <= 'f') {
                            y <<= 4;
                            y += b - 97 + 10;
                        } else {
                            if (b < 'A' || b > 'F') break;
                            y <<= 4;
                            y += b - 65 + 10;
                        }
                        ++idx;
                    }
                    if (x >= idx) {
                        throw new ParseException("Invalid \\x escape in a string literal", 0, 0);
                    }
                    buf.append((char)y);
                    bidx = idx;
                    break;
                }
                default: {
                    throw new ParseException("Invalid escape sequence (\\" + c + ") in a string literal", 0, 0);
                }
            }
        } while ((idx = s.indexOf(92, bidx)) != -1);
        buf.append(s.substring(bidx));
        return buf.toString();
    }

    public static Locale deduceLocale(String input) {
        Locale locale = Locale.getDefault();
        if (input.charAt(0) == '\"') {
            input = input.substring(1, input.length() - 1);
        }
        StringTokenizer st = new StringTokenizer(input, ",_ ");
        String lang = "";
        String country = "";
        if (st.hasMoreTokens()) {
            lang = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            country = st.nextToken();
        }
        locale = !st.hasMoreTokens() ? new Locale(lang, country) : new Locale(lang, country, st.nextToken());
        return locale;
    }

    public static String capitalize(String s) {
        StringTokenizer st = new StringTokenizer(s, " \t\r\n", true);
        StringBuffer buf = new StringBuffer(s.length());
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            buf.append(tok.substring(0, 1).toUpperCase());
            buf.append(tok.substring(1).toLowerCase());
        }
        return buf.toString();
    }

    public static boolean getYesNo(String s) {
        if (s.startsWith("\"")) {
            s = s.substring(1, s.length() - 1);
        }
        if (s.equalsIgnoreCase("n") || s.equalsIgnoreCase("no") || s.equalsIgnoreCase("f") || s.equalsIgnoreCase("false")) {
            return false;
        }
        if (s.equalsIgnoreCase("y") || s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("t") || s.equalsIgnoreCase("true")) {
            return true;
        }
        throw new IllegalArgumentException("Illegal boolean value: " + s);
    }

    public static String[] split(String s, char c) {
        int ln = s.length();
        int i = 0;
        int cnt = 1;
        while ((i = s.indexOf(c, i)) != -1) {
            ++cnt;
            ++i;
        }
        String[] res = new String[cnt];
        i = 0;
        int b = 0;
        while (b <= ln) {
            int e = s.indexOf(c, b);
            if (e == -1) {
                e = ln;
            }
            res[i++] = s.substring(b, e);
            b = e + 1;
        }
        return res;
    }

    public static String[] split(String s, String sep, boolean caseInsensitive) {
        String splitString = caseInsensitive ? sep.toLowerCase() : sep;
        String input = caseInsensitive ? s.toLowerCase() : s;
        int ln = s.length();
        int sln = sep.length();
        if (sln == 0) {
            throw new IllegalArgumentException("The separator string has 0 length");
        }
        int i = 0;
        int cnt = 1;
        while ((i = input.indexOf(splitString, i)) != -1) {
            ++cnt;
            i += sln;
        }
        String[] res = new String[cnt];
        i = 0;
        int b = 0;
        while (b <= ln) {
            int e = input.indexOf(splitString, b);
            if (e == -1) {
                e = ln;
            }
            res[i++] = s.substring(b, e);
            b = e + sln;
        }
        return res;
    }

    public static String replace(String text, String oldsub, String newsub, boolean caseInsensitive, boolean firstOnly) {
        int oln = oldsub.length();
        if (oln == 0) {
            int nln = newsub.length();
            if (nln == 0) {
                return text;
            }
            if (firstOnly) {
                return newsub + text;
            }
            int tln = text.length();
            StringBuffer buf = new StringBuffer(tln + (tln + 1) * nln);
            buf.append(newsub);
            for (int i = 0; i < tln; ++i) {
                buf.append(text.charAt(i));
                buf.append(newsub);
            }
            return buf.toString();
        }
        String input = caseInsensitive ? text.toLowerCase() : text;
        int e = input.indexOf(oldsub = caseInsensitive ? oldsub.toLowerCase() : oldsub);
        if (e == -1) {
            return text;
        }
        int b = 0;
        int tln = text.length();
        StringBuffer buf = new StringBuffer(tln + Math.max(newsub.length() - oln, 0) * 3);
        do {
            buf.append(text.substring(b, e));
            buf.append(newsub);
        } while ((e = input.indexOf(oldsub, b = e + oln)) != -1 && !firstOnly);
        buf.append(text.substring(b));
        return buf.toString();
    }

    public static String chomp(String s) {
        if (s.endsWith("\r\n")) {
            return s.substring(0, s.length() - 2);
        }
        if (s.endsWith("\r") || s.endsWith("\n")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static String jQuote(Object obj) {
        return StringUtil.jQuote(obj != null ? obj.toString() : null);
    }

    public static String jQuote(String s) {
        if (s == null) {
            return "null";
        }
        int ln = s.length();
        StringBuffer b = new StringBuffer(ln + 4);
        b.append('\"');
        for (int i = 0; i < ln; ++i) {
            char c = s.charAt(i);
            if (c == '\"') {
                b.append("\\\"");
                continue;
            }
            if (c == '\\') {
                b.append("\\\\");
                continue;
            }
            if (c < ' ') {
                if (c == '\n') {
                    b.append("\\n");
                    continue;
                }
                if (c == '\r') {
                    b.append("\\r");
                    continue;
                }
                if (c == '\f') {
                    b.append("\\f");
                    continue;
                }
                if (c == '\b') {
                    b.append("\\b");
                    continue;
                }
                if (c == '\t') {
                    b.append("\\t");
                    continue;
                }
                b.append("\\u00");
                int x = c / 16;
                b.append((char)(x < 10 ? x + 48 : x - 10 + 65));
                x = c & 0xF;
                b.append((char)(x < 10 ? x + 48 : x - 10 + 65));
                continue;
            }
            b.append(c);
        }
        b.append('\"');
        return b.toString();
    }

    public static String jQuoteNoXSS(Object obj) {
        return StringUtil.jQuoteNoXSS(obj != null ? obj.toString() : null);
    }

    public static String jQuoteNoXSS(String s) {
        if (s == null) {
            return "null";
        }
        int ln = s.length();
        StringBuffer b = new StringBuffer(ln + 4);
        b.append('\"');
        for (int i = 0; i < ln; ++i) {
            char c = s.charAt(i);
            if (c == '\"') {
                b.append("\\\"");
                continue;
            }
            if (c == '\\') {
                b.append("\\\\");
                continue;
            }
            if (c == '<') {
                b.append("\\u003C");
                continue;
            }
            if (c < ' ') {
                if (c == '\n') {
                    b.append("\\n");
                    continue;
                }
                if (c == '\r') {
                    b.append("\\r");
                    continue;
                }
                if (c == '\f') {
                    b.append("\\f");
                    continue;
                }
                if (c == '\b') {
                    b.append("\\b");
                    continue;
                }
                if (c == '\t') {
                    b.append("\\t");
                    continue;
                }
                b.append("\\u00");
                int x = c / 16;
                b.append((char)(x < 10 ? x + 48 : x - 10 + 65));
                x = c & 0xF;
                b.append((char)(x < 10 ? x + 48 : x - 10 + 65));
                continue;
            }
            b.append(c);
        }
        b.append('\"');
        return b.toString();
    }

    public static String javaStringEnc(String s) {
        int ln = s.length();
        for (int i = 0; i < ln; ++i) {
            char c = s.charAt(i);
            if (c != '\"' && c != '\\' && c >= ' ') continue;
            StringBuffer b = new StringBuffer(ln + 4);
            b.append(s.substring(0, i));
            while (true) {
                if (c == '\"') {
                    b.append("\\\"");
                } else if (c == '\\') {
                    b.append("\\\\");
                } else if (c < ' ') {
                    if (c == '\n') {
                        b.append("\\n");
                    } else if (c == '\r') {
                        b.append("\\r");
                    } else if (c == '\f') {
                        b.append("\\f");
                    } else if (c == '\b') {
                        b.append("\\b");
                    } else if (c == '\t') {
                        b.append("\\t");
                    } else {
                        b.append("\\u00");
                        int x = c / 16;
                        b.append((char)(x < 10 ? x + 48 : x - 10 + 97));
                        x = c & 0xF;
                        b.append((char)(x < 10 ? x + 48 : x - 10 + 97));
                    }
                } else {
                    b.append(c);
                }
                if (++i >= ln) {
                    return b.toString();
                }
                c = s.charAt(i);
            }
        }
        return s;
    }

    public static String javaScriptStringEnc(String s) {
        int ln = s.length();
        for (int i = 0; i < ln; ++i) {
            char c = s.charAt(i);
            if (c != '\"' && c != '\'' && c != '\\' && c != '>' && c >= ' ') continue;
            StringBuffer b = new StringBuffer(ln + 4);
            b.append(s.substring(0, i));
            while (true) {
                if (c == '\"') {
                    b.append("\\\"");
                } else if (c == '\'') {
                    b.append("\\'");
                } else if (c == '\\') {
                    b.append("\\\\");
                } else if (c == '>') {
                    b.append("\\>");
                } else if (c < ' ') {
                    if (c == '\n') {
                        b.append("\\n");
                    } else if (c == '\r') {
                        b.append("\\r");
                    } else if (c == '\f') {
                        b.append("\\f");
                    } else if (c == '\b') {
                        b.append("\\b");
                    } else if (c == '\t') {
                        b.append("\\t");
                    } else {
                        b.append("\\x");
                        int x = c / 16;
                        b.append((char)(x < 10 ? x + 48 : x - 10 + 65));
                        x = c & 0xF;
                        b.append((char)(x < 10 ? x + 48 : x - 10 + 65));
                    }
                } else {
                    b.append(c);
                }
                if (++i >= ln) {
                    return b.toString();
                }
                c = s.charAt(i);
            }
        }
        return s;
    }

    public static String jsonStringEnc(String s) {
        int ln = s.length();
        for (int i = 0; i < ln; ++i) {
            char c = s.charAt(i);
            if (c != '\"' && c != '\\' && c >= ' ' && (c != '/' || i <= 0 || s.charAt(i - 1) != '<') && (c != '>' || i <= 1 || s.charAt(i - 1) != ']' || s.charAt(i - 2) != ']')) continue;
            StringBuffer b = new StringBuffer(ln + 4);
            b.append(s.substring(0, i));
            while (true) {
                if (c == '\"') {
                    b.append("\\\"");
                } else if (c == '\\') {
                    b.append("\\\\");
                } else if (c == '/' && i > 0 && s.charAt(i - 1) == '<') {
                    b.append("\\/");
                } else if (c == '>' && i > 1 && s.charAt(i - 1) == ']' && s.charAt(i - 2) == ']') {
                    b.append("\\u003E");
                } else if (c < ' ') {
                    if (c == '\n') {
                        b.append("\\n");
                    } else if (c == '\r') {
                        b.append("\\r");
                    } else if (c == '\f') {
                        b.append("\\f");
                    } else if (c == '\b') {
                        b.append("\\b");
                    } else if (c == '\t') {
                        b.append("\\t");
                    } else {
                        b.append("\\u00");
                        int x = c / 16;
                        b.append((char)(x < 10 ? x + 48 : x - 10 + 65));
                        x = c & 0xF;
                        b.append((char)(x < 10 ? x + 48 : x - 10 + 65));
                    }
                } else {
                    b.append(c);
                }
                if (++i >= ln) {
                    return b.toString();
                }
                c = s.charAt(i);
            }
        }
        return s;
    }

    public static Map parseNameValuePairList(String s, String defaultValue) throws java.text.ParseException {
        HashMap<String, String> map;
        block18: {
            String key;
            int keyStart;
            map = new HashMap<String, String>();
            char c = ' ';
            int ln = s.length();
            int p = 0;
            while (true) {
                String value;
                if (p < ln && Character.isWhitespace(c = (char)s.charAt(p))) {
                    ++p;
                    continue;
                }
                if (p == ln) break block18;
                keyStart = p;
                while (p < ln && (Character.isLetterOrDigit(c = s.charAt(p)) || c == '_')) {
                    ++p;
                }
                if (keyStart == p) {
                    throw new java.text.ParseException("Expecting letter, digit or \"_\" here, (the first character of the key) but found " + StringUtil.jQuote(String.valueOf(c)) + " at position " + p + ".", p);
                }
                key = s.substring(keyStart, p);
                while (p < ln && Character.isWhitespace(c = s.charAt(p))) {
                    ++p;
                }
                if (p == ln) {
                    if (defaultValue == null) {
                        throw new java.text.ParseException("Expecting \":\", but reached the end of the string  at position " + p + ".", p);
                    }
                    value = defaultValue;
                } else if (c != ':') {
                    if (defaultValue == null || c != ',') {
                        throw new java.text.ParseException("Expecting \":\" here, but found " + StringUtil.jQuote(String.valueOf(c)) + " at position " + p + ".", p);
                    }
                    ++p;
                    value = defaultValue;
                } else {
                    ++p;
                    while (p < ln && Character.isWhitespace(c = s.charAt(p))) {
                        ++p;
                    }
                    if (p == ln) {
                        throw new java.text.ParseException("Expecting the value of the key here, but reached the end of the string  at position " + p + ".", p);
                    }
                    int valueStart = p;
                    while (p < ln && (Character.isLetterOrDigit(c = s.charAt(p)) || c == '_')) {
                        ++p;
                    }
                    if (valueStart == p) {
                        throw new java.text.ParseException("Expecting letter, digit or \"_\" here, (the first character of the value) but found " + StringUtil.jQuote(String.valueOf(c)) + " at position " + p + ".", p);
                    }
                    value = s.substring(valueStart, p);
                    while (p < ln && Character.isWhitespace(c = s.charAt(p))) {
                        ++p;
                    }
                    if (p < ln) {
                        if (c != ',') {
                            throw new java.text.ParseException("Excpecting \",\" or the end of the string here, but found " + StringUtil.jQuote(String.valueOf(c)) + " at position " + p + ".", p);
                        }
                        ++p;
                    }
                }
                if (map.put(key, value) != null) break;
            }
            throw new java.text.ParseException("Dublicated key: " + StringUtil.jQuote(key), keyStart);
        }
        return map;
    }

    public static boolean isXMLID(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (i == 0 && (c == '-' || c == '.' || Character.isDigit(c))) {
                return false;
            }
            if (Character.isLetterOrDigit(c) || c == ':' || c == '_' || c == '-' || c == '.') continue;
            return false;
        }
        return true;
    }

    public static boolean matchesName(String qname, String nodeName, String nsURI, Environment env) {
        String defaultNS = env.getDefaultNS();
        if (defaultNS != null && defaultNS.equals(nsURI)) {
            return qname.equals(nodeName) || qname.equals("D:" + nodeName);
        }
        if ("".equals(nsURI)) {
            if (defaultNS != null) {
                return qname.equals("N:" + nodeName);
            }
            return qname.equals(nodeName) || qname.equals("N:" + nodeName);
        }
        String prefix = env.getPrefixForNamespace(nsURI);
        if (prefix == null) {
            return false;
        }
        return qname.equals(prefix + ":" + nodeName);
    }

    public static String leftPad(String s, int minLength) {
        return StringUtil.leftPad(s, minLength, ' ');
    }

    public static String leftPad(String s, int minLength, char filling) {
        int ln = s.length();
        if (minLength <= ln) {
            return s;
        }
        StringBuffer res = new StringBuffer(minLength);
        int dif = minLength - ln;
        for (int i = 0; i < dif; ++i) {
            res.append(filling);
        }
        res.append(s);
        return res.toString();
    }

    public static String leftPad(String s, int minLength, String filling) {
        int i;
        int ln = s.length();
        if (minLength <= ln) {
            return s;
        }
        StringBuffer res = new StringBuffer(minLength);
        int dif = minLength - ln;
        int fln = filling.length();
        if (fln == 0) {
            throw new IllegalArgumentException("The \"filling\" argument can't be 0 length string.");
        }
        int cnt = dif / fln;
        for (i = 0; i < cnt; ++i) {
            res.append(filling);
        }
        cnt = dif % fln;
        for (i = 0; i < cnt; ++i) {
            res.append(filling.charAt(i));
        }
        res.append(s);
        return res.toString();
    }

    public static String rightPad(String s, int minLength) {
        return StringUtil.rightPad(s, minLength, ' ');
    }

    public static String rightPad(String s, int minLength, char filling) {
        int ln = s.length();
        if (minLength <= ln) {
            return s;
        }
        StringBuffer res = new StringBuffer(minLength);
        res.append(s);
        int dif = minLength - ln;
        for (int i = 0; i < dif; ++i) {
            res.append(filling);
        }
        return res.toString();
    }

    public static String rightPad(String s, int minLength, String filling) {
        int i;
        int ln = s.length();
        if (minLength <= ln) {
            return s;
        }
        StringBuffer res = new StringBuffer(minLength);
        res.append(s);
        int dif = minLength - ln;
        int fln = filling.length();
        if (fln == 0) {
            throw new IllegalArgumentException("The \"filling\" argument can't be 0 length string.");
        }
        int start = ln % fln;
        int end = fln - start <= dif ? fln : start + dif;
        for (int i2 = start; i2 < end; ++i2) {
            res.append(filling.charAt(i2));
        }
        int cnt = (dif -= end - start) / fln;
        for (i = 0; i < cnt; ++i) {
            res.append(filling);
        }
        cnt = dif % fln;
        for (i = 0; i < cnt; ++i) {
            res.append(filling.charAt(i));
        }
        return res.toString();
    }

    public static int versionStringToInt(String version) {
        version = version.trim();
        int[] parts = new int[3];
        int partIdx = 0;
        boolean valid = false;
        for (int i = 0; i < version.length(); ++i) {
            char c = version.charAt(i);
            if (c >= '0' && c <= '9') {
                parts[partIdx] = parts[partIdx] * 10 + (c - 48);
                valid = true;
                continue;
            }
            if (c != '.' || partIdx == 2) break;
            ++partIdx;
        }
        if (!valid) {
            throw new IllegalArgumentException("A version number string " + StringUtil.jQuote(version) + " must start with a number.");
        }
        return parts[0] * 1000000 + parts[1] * 1000 + parts[2];
    }
}

