/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.relocated.freemarker.core;

import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.uberfire.relocated.freemarker.core.BuiltIn;
import org.uberfire.relocated.freemarker.core.Environment;
import org.uberfire.relocated.freemarker.core.EvaluationUtil;
import org.uberfire.relocated.freemarker.core.InvalidReferenceException;
import org.uberfire.relocated.freemarker.core.NonDateException;
import org.uberfire.relocated.freemarker.template.AdapterTemplateModel;
import org.uberfire.relocated.freemarker.template.SimpleScalar;
import org.uberfire.relocated.freemarker.template.TemplateDateModel;
import org.uberfire.relocated.freemarker.template.TemplateException;
import org.uberfire.relocated.freemarker.template.TemplateMethodModelEx;
import org.uberfire.relocated.freemarker.template.TemplateModel;
import org.uberfire.relocated.freemarker.template.TemplateModelException;
import org.uberfire.relocated.freemarker.template.TemplateScalarModel;
import org.uberfire.relocated.freemarker.template.utility.DateUtil;
import org.uberfire.relocated.freemarker.template.utility.StringUtil;
import org.uberfire.relocated.freemarker.template.utility.UnrecognizedTimeZoneException;

abstract class DateBuiltins {
    static /* synthetic */ Class class$java$util$TimeZone;

    DateBuiltins() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class iso_BI
    extends AbstractISOBI {
        iso_BI(String biName, boolean showOffset, int accuracy) {
            super(biName, showOffset, accuracy);
        }

        protected TemplateModel calculateResult(Date date, int dateType, Environment env) throws TemplateException {
            this.checkDateTypeNotUnknown(dateType, env);
            return new Result(date, dateType, env);
        }

        class Result
        implements TemplateMethodModelEx {
            private final Date date;
            private final int dateType;
            private final Environment env;

            Result(Date date, int dateType, Environment env) {
                this.date = date;
                this.dateType = dateType;
                this.env = env;
            }

            public Object exec(List args) throws TemplateModelException {
                TimeZone tzArg;
                Object adaptedObj;
                if (args.size() != 1) {
                    throw new TemplateModelException("?" + iso_BI.this.biName + "(...) expects exactly 1 argument, but had " + args.size() + ".");
                }
                TemplateModel tzArgTM = (TemplateModel)args.get(0);
                if (tzArgTM instanceof AdapterTemplateModel && (adaptedObj = ((AdapterTemplateModel)tzArgTM).getAdaptedObject(class$java$util$TimeZone == null ? (class$java$util$TimeZone = DateBuiltins.class$("java.util.TimeZone")) : class$java$util$TimeZone)) instanceof TimeZone) {
                    tzArg = (TimeZone)adaptedObj;
                } else if (tzArgTM instanceof TemplateScalarModel) {
                    String tzName = ((TemplateScalarModel)tzArgTM).getAsString();
                    try {
                        tzArg = DateUtil.getTimeZone(tzName);
                    }
                    catch (UnrecognizedTimeZoneException e) {
                        throw new TemplateModelException("The time zone string specified for ?" + iso_BI.this.biName + "(...) is not recognized as a valid time zone name: " + StringUtil.jQuote(tzName));
                    }
                } else {
                    throw new TemplateModelException("The argument to ?" + iso_BI.this.biName + "(...) must be a String or a " + "java.util.TimeZone but it was a " + (tzArgTM != null ? tzArgTM.getClass().getName() : "null") + ".");
                }
                return new SimpleScalar(DateUtil.dateToISO8601String(this.date, this.dateType != 1, this.dateType != 2, iso_BI.this.showOffset && this.dateType != 2, iso_BI.this.accuracy, tzArg, this.env.getISOBuiltInCalendar()));
            }
        }
    }

    static class iso_tz_BI
    extends AbstractISOBI {
        private final boolean useUTC;

        iso_tz_BI(String biName, boolean showOffset, int accuracy, boolean useUTC) {
            super(biName, showOffset, accuracy);
            this.useUTC = useUTC;
        }

        protected TemplateModel calculateResult(Date date, int dateType, Environment env) throws TemplateException {
            this.checkDateTypeNotUnknown(dateType, env);
            return new SimpleScalar(DateUtil.dateToISO8601String(date, dateType != 1, dateType != 2, this.showOffset && dateType != 2, this.accuracy, this.useUTC ? DateUtil.UTC : env.getTimeZone(), env.getISOBuiltInCalendar()));
        }
    }

    static abstract class AbstractISOBI
    extends DateBuiltin {
        protected final String biName;
        protected final boolean showOffset;
        protected final int accuracy;

        protected AbstractISOBI(String biName, boolean showOffset, int accuracy) {
            this.biName = biName;
            this.showOffset = showOffset;
            this.accuracy = accuracy;
        }

        protected void checkDateTypeNotUnknown(int dateType, Environment env) throws TemplateException {
            if (dateType == 0) {
                throw new TemplateException("Unknown date type: ?" + this.biName + " needs a date value " + "where it's known if it's a date-only, time-only, or " + "date+time value. Use ?time, ?date or ?datetime " + "before ? " + this.biName + " to estabilish that.", env);
            }
        }
    }

    static abstract class DateBuiltin
    extends BuiltIn {
        DateBuiltin() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (model instanceof TemplateDateModel) {
                TemplateDateModel tdm = (TemplateDateModel)model;
                return this.calculateResult(EvaluationUtil.getDate(tdm, this.target, env), tdm.getDateType(), env);
            }
            if (model == null) {
                throw new InvalidReferenceException(this.target + " is undefined.", env);
            }
            throw new NonDateException(this.target + " should be a date, time, or date+time, but it's a(n) " + model.getClass().getName(), env);
        }

        protected abstract TemplateModel calculateResult(Date var1, int var2, Environment var3) throws TemplateException;
    }
}

