/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.relocated.freemarker.core;

import org.uberfire.relocated.freemarker.core.Environment;
import org.uberfire.relocated.freemarker.core.Expression;
import org.uberfire.relocated.freemarker.core.ParseException;
import org.uberfire.relocated.freemarker.core.TemplateElement;
import org.uberfire.relocated.freemarker.template.Template;
import org.uberfire.relocated.freemarker.template.TemplateBooleanModel;
import org.uberfire.relocated.freemarker.template.TemplateException;
import org.uberfire.relocated.freemarker.template.TemplateModel;
import org.uberfire.relocated.freemarker.template.TemplateNumberModel;
import org.uberfire.relocated.freemarker.template.TemplateScalarModel;

final class PropertySetting
extends TemplateElement {
    private final String key;
    private final Expression value;

    PropertySetting(String key, Expression value) {
        this.key = key;
        this.value = value;
    }

    void setLocation(Template template, int beginColumn, int beginLine, int endColumn, int endLine) throws ParseException {
        super.setLocation(template, beginColumn, beginLine, endColumn, endLine);
        if (!(this.key.equals("locale") || this.key.equals("number_format") || this.key.equals("time_format") || this.key.equals("date_format") || this.key.equals("datetime_format") || this.key.equals("time_zone") || this.key.equals("boolean_format") || this.key.equals("classic_compatible") || this.key.equals("url_escaping_charset"))) {
            throw new ParseException("Error " + this.getStartLocation() + "\nInvalid setting name, or it is not allowed to change " + "the value of the setting with FTL: " + this.key, beginLine, beginColumn);
        }
    }

    void accept(Environment env) throws TemplateException {
        TemplateModel mval = this.value.getAsTemplateModel(env);
        String strval = mval instanceof TemplateScalarModel ? ((TemplateScalarModel)mval).getAsString() : (mval instanceof TemplateBooleanModel ? (((TemplateBooleanModel)mval).getAsBoolean() ? "true" : "false") : (mval instanceof TemplateNumberModel ? ((TemplateNumberModel)mval).getAsNumber().toString() : this.value.getStringValue(env)));
        env.setSetting(this.key, strval);
    }

    public String getCanonicalForm() {
        return "<#setting " + this.key + "=" + this.value.getCanonicalForm() + "/>";
    }

    public String getDescription() {
        return "setting " + this.key + " set to " + "\"" + this.value + "\" " + "[" + this.getStartLocation() + "]";
    }
}

