/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.relocated.freemarker.core;

import org.uberfire.relocated.freemarker.core.Environment;
import org.uberfire.relocated.freemarker.core.Expression;
import org.uberfire.relocated.freemarker.core.InvalidReferenceException;
import org.uberfire.relocated.freemarker.core.ParseException;
import org.uberfire.relocated.freemarker.core.Token;
import org.uberfire.relocated.freemarker.template.Template;
import org.uberfire.relocated.freemarker.template.TemplateException;
import org.uberfire.relocated.freemarker.template.TemplateModel;
import org.uberfire.relocated.freemarker.template.utility.StringUtil;

public abstract class TemplateObject {
    private Template template;
    int beginColumn;
    int beginLine;
    int endColumn;
    int endLine;

    final void setLocation(Template template, Token begin, Token end) throws ParseException {
        this.setLocation(template, begin.beginColumn, begin.beginLine, end.endColumn, end.endLine);
    }

    final void setLocation(Template template, Token begin, TemplateObject end) throws ParseException {
        this.setLocation(template, begin.beginColumn, begin.beginLine, end.endColumn, end.endLine);
    }

    final void setLocation(Template template, TemplateObject begin, Token end) throws ParseException {
        this.setLocation(template, begin.beginColumn, begin.beginLine, end.endColumn, end.endLine);
    }

    final void setLocation(Template template, TemplateObject begin, TemplateObject end) throws ParseException {
        this.setLocation(template, begin.beginColumn, begin.beginLine, end.endColumn, end.endLine);
    }

    public final int getBeginColumn() {
        return this.beginColumn;
    }

    public final int getBeginLine() {
        return this.beginLine;
    }

    public final int getEndColumn() {
        return this.endColumn;
    }

    public final int getEndLine() {
        return this.endLine;
    }

    void setLocation(Template template, int beginColumn, int beginLine, int endColumn, int endLine) throws ParseException {
        this.template = template;
        this.beginColumn = beginColumn;
        this.beginLine = beginLine;
        this.endColumn = endColumn;
        this.endLine = endLine;
    }

    static void assertNonNull(TemplateModel model, Expression exp, Environment env) throws InvalidReferenceException {
        if (model == null) {
            throw new InvalidReferenceException("Expression " + exp + " is undefined " + exp.getStartLocation() + ".", env);
        }
    }

    static TemplateException invalidTypeException(TemplateModel model, Expression exp, Environment env, String expected) throws TemplateException {
        TemplateObject.assertNonNull(model, exp, env);
        return new TemplateException("Expected " + expected + ". " + exp + " evaluated instead to " + model.getClass().getName() + " " + exp.getStartLocation() + ".", env);
    }

    public String getStartLocation() {
        String templateName = this.template != null ? this.template.getName() : "input";
        return "on line " + this.beginLine + ", column " + this.beginColumn + " in " + templateName;
    }

    public String getStartLocationQuoted() {
        String templateName = this.template != null ? StringUtil.jQuoteNoXSS(this.template.getName()) : "input";
        return "on line " + this.beginLine + ", column " + this.beginColumn + " in " + templateName;
    }

    public String getEndLocation() {
        String templateName = this.template != null ? this.template.getName() : "input";
        return "on line " + this.endLine + ", column " + this.endColumn + " in " + templateName;
    }

    public String getEndLocationQuoted() {
        String templateName = this.template != null ? StringUtil.jQuoteNoXSS(this.template.getName()) : "input";
        return "on line " + this.endLine + ", column " + this.endColumn + " in " + templateName;
    }

    public final String getSource() {
        if (this.template != null) {
            return this.template.getSource(this.beginColumn, this.beginLine, this.endColumn, this.endLine);
        }
        return this.getCanonicalForm();
    }

    public String toString() {
        try {
            return this.getSource();
        }
        catch (Exception e) {
            return this.getCanonicalForm();
        }
    }

    public boolean contains(int column, int line) {
        if (line < this.beginLine || line > this.endLine) {
            return false;
        }
        if (line == this.beginLine && column < this.beginColumn) {
            return false;
        }
        return line != this.endLine || column <= this.endColumn;
    }

    public Template getTemplate() {
        return this.template;
    }

    TemplateObject copyLocationFrom(TemplateObject from) {
        this.template = from.template;
        this.beginColumn = from.beginColumn;
        this.beginLine = from.beginLine;
        this.endColumn = from.endColumn;
        this.endLine = from.endLine;
        return this;
    }

    public abstract String getCanonicalForm();
}

