/*
 * Decompiled with CFR 0.152.
 */
package net.balusc.util;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectConverter {
    private static final Map<String, Method> CONVERTERS;

    private ObjectConverter() {
    }

    public static <T> T convert(Object from, Class<T> to) {
        if (from == null) {
            return null;
        }
        if (to.isAssignableFrom(from.getClass())) {
            return to.cast(from);
        }
        String converterId = from.getClass().getName() + "_" + to.getName();
        Method converter = CONVERTERS.get(converterId);
        if (converter == null) {
            throw new UnsupportedOperationException("Cannot convert from " + from.getClass().getName() + " to " + to.getName() + ". Requested converter does not exist.");
        }
        try {
            if (to.isPrimitive()) {
                return (T)converter.invoke(to, from);
            }
            return to.cast(converter.invoke(to, from));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot convert from " + from.getClass().getName() + " to " + to.getName() + ". Conversion failed with " + e.getMessage(), e);
        }
    }

    public static Boolean integerToBoolean(Integer value) {
        return value == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    public static Integer booleanToInteger(Boolean value) {
        return value != false ? Integer.valueOf(1) : Integer.valueOf(0);
    }

    public static BigDecimal doubleToBigDecimal(Double value) {
        return new BigDecimal(value);
    }

    public static Double bigDecimalToDouble(BigDecimal value) {
        return new Double(value.doubleValue());
    }

    public static String integerToString(Integer value) {
        return value.toString();
    }

    public static Integer stringToInteger(String value) {
        return Integer.valueOf(value);
    }

    public static Long stringToLong(String value) {
        return Long.valueOf(value);
    }

    public static long stringToLongPrimitive(String value) {
        return ObjectConverter.stringToLong(value);
    }

    public static String booleanToString(Boolean value) {
        return value.toString();
    }

    public static Boolean stringToBoolean(String value) {
        return Boolean.valueOf(value);
    }

    public static Integer longToInteger(Long value) {
        return value.intValue();
    }

    public static Float doubleToFloat(Double value) {
        return Float.valueOf(value.floatValue());
    }

    public static Float stringToFloat(String value) {
        return Float.valueOf(Float.parseFloat(value));
    }

    public static Double stringToDouble(String value) {
        return Double.parseDouble(value);
    }

    public static long longToPrimitive(Long value) {
        if (value == null) {
            return 0L;
        }
        return value;
    }

    public static String longToString(Long value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static String longToString(Double value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static String longToString(Date value) {
        if (value == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat();
        return sdf.format(value);
    }

    public static int integerToPrimitive(Integer value) {
        if (value == null) {
            return 0;
        }
        return value;
    }

    public static double doubleToPrimitive(Double value) {
        if (value == null) {
            return 0.0;
        }
        return value;
    }

    public static double floatToPrimitive(Float value) {
        if (value == null) {
            return 0.0;
        }
        return value.floatValue();
    }

    static {
        Method[] methods;
        CONVERTERS = new HashMap<String, Method>();
        for (Method method : methods = ObjectConverter.class.getDeclaredMethods()) {
            if (method.getParameterTypes().length != 1) continue;
            CONVERTERS.put(method.getParameterTypes()[0].getName() + "_" + method.getReturnType().getName(), method);
        }
    }
}

