/*
 * Decompiled with CFR 0.152.
 */
package org.ucmtwine;

import intradoc.common.ExecutionContext;
import intradoc.common.ServiceException;
import intradoc.common.SystemUtils;
import intradoc.data.DataBinder;
import intradoc.data.DataException;
import intradoc.data.Workspace;
import intradoc.io.zip.IdcZipFile;
import intradoc.shared.FilterImplementor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import org.ucmtwine.proxy.injector.FilterInjector;
import org.ucmtwine.proxy.injector.IdocScriptInjector;
import org.ucmtwine.proxy.injector.ServiceInjector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bootstrapper
implements FilterImplementor {
    public int doFilter(Workspace ws, DataBinder binder, ExecutionContext ctx) throws DataException, ServiceException {
        String configFileName = (String)ctx.getCachedObject("filterParameter");
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            Enumeration<URL> propFiles = cl.getResources(configFileName);
            if (!propFiles.hasMoreElements()) {
                propFiles = this.getResources11g(cl, configFileName);
            }
            while (propFiles.hasMoreElements()) {
                URL propFile = propFiles.nextElement();
                if (SystemUtils.m_verbose) {
                    SystemUtils.trace((String)"twine", (String)("Loading config file: " + propFile.toString()));
                }
                FilterInjector filterInjector = new FilterInjector();
                filterInjector.injectClasses(propFile);
                ServiceInjector serviceInjector = new ServiceInjector();
                serviceInjector.injectClasses(propFile);
                IdocScriptInjector scriptInjector = new IdocScriptInjector();
                scriptInjector.injectClasses(propFile);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0;
    }

    private Enumeration<URL> getResources11g(ClassLoader classLoader, String configFileName) {
        ArrayList<URL> newProps = new ArrayList<URL>();
        if (classLoader.getClass().getSimpleName().equalsIgnoreCase("IdcClassLoader")) {
            try {
                Field field = classLoader.getClass().getField("m_zipfiles");
                Map zipFiles = (Map)field.get(classLoader);
                for (Map.Entry entry : zipFiles.entrySet()) {
                    if (((IdcZipFile)entry.getValue()).m_entries.get(configFileName) == null) continue;
                    String jarFile = (String)entry.getKey();
                    if (!jarFile.startsWith("/")) {
                        jarFile = "/" + jarFile;
                    }
                    try {
                        URL u = new URL("jar:file:" + (String)entry.getKey() + "!/" + configFileName);
                        newProps.add(u);
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return Collections.enumeration(newProps);
    }
}

