/*
 * Decompiled with CFR 0.152.
 */
package org.ucmtwine.parameter;

import intradoc.data.DataBinder;
import intradoc.data.DataResultSet;
import intradoc.data.ResultSet;
import intradoc.provider.Provider;
import intradoc.server.Service;
import java.util.Date;
import net.balusc.util.ObjectConverter;
import org.ucmtwine.parameter.IParameter;
import org.ucmtwine.parameter.types.BooleanParameter;
import org.ucmtwine.parameter.types.DateParameter;
import org.ucmtwine.parameter.types.DoubleParameter;
import org.ucmtwine.parameter.types.FloatParameter;
import org.ucmtwine.parameter.types.InjectedParameter;
import org.ucmtwine.parameter.types.IntegerParameter;
import org.ucmtwine.parameter.types.LongParameter;
import org.ucmtwine.parameter.types.ProviderParameter;
import org.ucmtwine.parameter.types.ResultSetParameter;
import org.ucmtwine.parameter.types.StringParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Parameter
implements IParameter {
    public static final int GRAMMAR_ELEMENT_UNSPECIFIED = -1;
    protected String name;
    protected boolean required = true;
    protected Class<?> type;

    protected Parameter() {
        this.name = "";
    }

    protected Parameter(Class<?> type) {
        this.type = type;
        this.name = "";
    }

    protected Parameter(String name, Class<?> type) {
        this.name = name;
        this.type = type;
    }

    public static Parameter create(String name) {
        return Parameter.create(name, String.class, true);
    }

    public static Parameter create(Class<?> type) {
        return Parameter.create("", type, true);
    }

    public static Parameter create(String name, Class<?> type, boolean required) throws IllegalArgumentException {
        Parameter p;
        if (InjectedParameter.isValidType(type)) {
            return new InjectedParameter(name, type);
        }
        if (type.isPrimitive() && !required) {
            String msg = "Parameter [" + name + "] found with non-nullable type. Use a wrapper type or change to required";
            throw new IllegalArgumentException(msg);
        }
        if (type == String.class) {
            p = new StringParameter(name, type);
        } else if (type == Integer.class || type == Integer.TYPE) {
            p = new IntegerParameter(name, type);
        } else if (type == Long.class || type == Long.TYPE) {
            p = new LongParameter(name, type);
        } else if (type == Float.class || type == Float.TYPE) {
            p = new FloatParameter(name, type);
        } else if (type == Double.class || type == Double.TYPE) {
            p = new DoubleParameter(name, type);
        } else if (type == Date.class) {
            p = new DateParameter(name, type);
        } else if (type == ResultSet.class || type == DataResultSet.class) {
            p = new ResultSetParameter(name, type);
        } else if (type == Boolean.class || type == Boolean.TYPE) {
            p = new BooleanParameter(name, type);
        } else if (type == Provider.class) {
            p = new ProviderParameter(name);
        } else {
            throw new IllegalArgumentException("Parameter type " + type.getName() + " is not valid");
        }
        p.setRequired(required);
        return p;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean optional) {
        this.required = optional;
    }

    public String getStringValue(DataBinder binder) {
        if (this.name == null || this.name.equals("")) {
            return null;
        }
        String value = binder.getLocal(this.name);
        if (value == null && this.required) {
            throw new IllegalArgumentException("Parameter " + this.name + " is required");
        }
        return value;
    }

    @Override
    public abstract Object getBinderValue(Service var1) throws IllegalAccessException;

    @Override
    public Object getArgumentValue(Object object, Service service) throws ClassCastException {
        return ObjectConverter.convert(object, this.type);
    }

    @Override
    public String toActionString() {
        return this.getType().getName() + "," + this.getName() + "," + String.valueOf(this.isRequired());
    }

    public static boolean parseRequiredString(String requiredString) {
        return Boolean.parseBoolean(requiredString) || requiredString.equalsIgnoreCase("required");
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }
}

