/*
 * Decompiled with CFR 0.152.
 */
package org.ucmtwine.parameter;

import intradoc.common.ExecutionContext;
import intradoc.common.SystemUtils;
import intradoc.data.DataBinder;
import intradoc.data.Workspace;
import intradoc.server.Service;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.ucmtwine.annotation.Binder;
import org.ucmtwine.parameter.IParameter;
import org.ucmtwine.parameter.Parameter;
import org.ucmtwine.parameter.types.InjectedParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterMarshaller {
    public static final int EXTRA_FUNC_DEF_VALUES = 3;
    private List<IParameter> parameters;

    public ParameterMarshaller() {
        this.parameters = new ArrayList<IParameter>();
    }

    public ParameterMarshaller(Method method) throws IllegalArgumentException {
        this.parameters = ParameterMarshaller.createList(method);
    }

    public List<IParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<IParameter> parameters) {
        this.parameters = parameters;
    }

    private static List<IParameter> createList(Method method) {
        ArrayList<IParameter> parameters = new ArrayList<IParameter>();
        Class<?>[] paramTypes = method.getParameterTypes();
        Annotation[][] methodAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < methodAnnotations.length; ++i) {
            boolean paramRequired = true;
            String paramName = "";
            Class<?> paramClass = paramTypes[i];
            for (Annotation a : methodAnnotations[i]) {
                if (!(a instanceof Binder)) continue;
                paramName = ((Binder)a).name();
                paramRequired = ((Binder)a).required();
                break;
            }
            parameters.add(Parameter.create(paramName, paramClass, paramRequired));
        }
        return parameters;
    }

    public Class<?>[] getTypeArray() {
        Class[] typeArray = new Class[this.parameters.size()];
        for (int i = 0; i < this.parameters.size(); ++i) {
            typeArray[i] = this.parameters.get(i).getType();
        }
        return typeArray;
    }

    public int getParameterCount(boolean includeInjected) {
        int count = 0;
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (this.parameters.get(i) instanceof InjectedParameter) {
                if (!includeInjected) continue;
                ++count;
                continue;
            }
            ++count;
        }
        return count;
    }

    public int[] getFunctionDefinitionArray(int functionOffset, int maxParams, int returnType) {
        int[] definition = new int[maxParams + 3];
        int paramCount = this.getParameterCount(false);
        int fullParamCount = this.getParameterCount(true);
        definition[0] = functionOffset;
        if (paramCount > maxParams) {
            throw new IllegalStateException("Attempted to get function definition table when supplied max parameter count " + maxParams + " is smaller than real param count " + paramCount);
        }
        definition[1] = paramCount;
        int j = 2;
        for (int i = 0; i < fullParamCount; ++i) {
            if (this.parameters.get(i) instanceof InjectedParameter) continue;
            definition[j] = this.parameters.get(i).getGrammarElementType();
            ++j;
        }
        while (j < definition.length - 1) {
            definition[j] = -1;
            ++j;
        }
        definition[definition.length - 1] = returnType;
        return definition;
    }

    public Object[] getValueArray(Object[] arguments, Service service) {
        Object[] paramArray = new Object[this.parameters.size()];
        int argumentIndex = 0;
        for (int i = 0; i < this.parameters.size(); ++i) {
            IParameter p = this.parameters.get(i);
            try {
                if (p instanceof InjectedParameter) {
                    paramArray[i] = p.getArgumentValue(null, service);
                    continue;
                }
                paramArray[i] = p.getArgumentValue(arguments[argumentIndex], service);
                ++argumentIndex;
                continue;
            }
            catch (ClassCastException e) {
                SystemUtils.trace((String)"twine", (String)("getArgumentValue failed on parameter " + (i + 1) + ": " + e.getMessage()));
            }
        }
        return paramArray;
    }

    public Object[] getValueArray(Workspace ws, DataBinder binder, ExecutionContext ctx) {
        Object[] paramArray = new Object[this.parameters.size()];
        for (int i = 0; i < this.parameters.size(); ++i) {
            IParameter p = this.parameters.get(i);
            try {
                if (p.getType() == Workspace.class) {
                    paramArray[i] = ws;
                    continue;
                }
                if (p.getType() == DataBinder.class) {
                    paramArray[i] = binder;
                    continue;
                }
                if (p.getType().isAssignableFrom(ExecutionContext.class)) {
                    paramArray[i] = ctx;
                    continue;
                }
                paramArray[i] = null;
                continue;
            }
            catch (ClassCastException e) {
                SystemUtils.trace((String)"twine", (String)("getArgumentValue failed on parameter " + (i + 1) + ": " + e.getMessage()));
            }
        }
        return paramArray;
    }

    public Object[] getValueArray(Service service) {
        Object[] paramArray = new Object[this.parameters.size()];
        for (int i = 0; i < this.parameters.size(); ++i) {
            IParameter p = this.parameters.get(i);
            try {
                paramArray[i] = p.getBinderValue(service);
                continue;
            }
            catch (IllegalAccessException e) {
                SystemUtils.trace((String)"twine", (String)("getValue failed on parameter " + (i + 1) + ": " + e.getMessage()));
            }
        }
        return paramArray;
    }
}

