/*
 * Decompiled with CFR 0.152.
 */
package org.ucmtwine.parameter.types;

import intradoc.server.Service;
import org.ucmtwine.parameter.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanParameter
extends Parameter {
    public BooleanParameter() {
        super(Boolean.class);
    }

    public BooleanParameter(Class<?> type) {
        super(type);
    }

    public BooleanParameter(String name, Class<?> type) {
        super(name, type);
    }

    @Override
    public Object getBinderValue(Service service) {
        String binderValue = this.getStringValue(service.getBinder());
        return this.parseStringValue(binderValue);
    }

    private Boolean parseStringValue(String binderValue) {
        Boolean val = null;
        if (binderValue != null) {
            val = binderValue.equals("1") ? new Boolean(true) : new Boolean(binderValue);
        }
        return val;
    }

    @Override
    public Object getArgumentValue(Object object, Service service) throws ClassCastException {
        if (object == null) {
            return null;
        }
        if (object.getClass() == Long.class) {
            return (Long)object == 1L;
        }
        if (object.getClass() == String.class) {
            return this.parseStringValue((String)object);
        }
        return super.getArgumentValue(object, service);
    }

    @Override
    public int getGrammarElementType() {
        return 1;
    }
}

