/*
 * Decompiled with CFR 0.152.
 */
package org.ucmtwine.parameter.types;

import intradoc.data.DataBinder;
import intradoc.server.Service;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.ucmtwine.parameter.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateParameter
extends Parameter {
    public DateParameter(String name) {
        super(name, Date.class);
    }

    public DateParameter(String name, Class<?> type) {
        super(name, type);
    }

    @Override
    public Object getBinderValue(Service service) {
        String dateString = this.getStringValue(service.getBinder());
        Date date = null;
        if (dateString != null) {
            date = this.getFromString(service.getBinder(), dateString);
        }
        return date;
    }

    private Date getFromString(DataBinder binder, String dateString) {
        Date d;
        block2: {
            d = null;
            SimpleDateFormat dateFormat = new SimpleDateFormat(binder.m_blDateFormat.toSimplePattern());
            try {
                d = dateFormat.parse(dateString);
            }
            catch (Exception e) {
                if (dateString == null) break block2;
                throw new IllegalArgumentException("Parameter '" + this.name + "' must be parseable as a date");
            }
        }
        return d;
    }

    @Override
    public Object getArgumentValue(Object object, Service service) throws ClassCastException {
        if (object instanceof String) {
            return this.getFromString(service.getBinder(), (String)object);
        }
        return super.getArgumentValue(object, service);
    }

    @Override
    public int getGrammarElementType() {
        return 3;
    }
}

