/*
 * Decompiled with CFR 0.152.
 */
package org.ucmtwine.parameter.types;

import intradoc.server.Service;
import org.ucmtwine.parameter.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatParameter
extends Parameter {
    public FloatParameter() {
        super("", Float.class);
    }

    public FloatParameter(String name) {
        super(name, Float.class);
    }

    public FloatParameter(String name, Class<?> type) {
        super(name, type);
    }

    @Override
    public Object getBinderValue(Service service) {
        Float value;
        block2: {
            String floatString = this.getStringValue(service.getBinder());
            value = null;
            try {
                value = Float.valueOf(Float.parseFloat(floatString));
            }
            catch (NumberFormatException e) {
                if (floatString == null) break block2;
                throw new IllegalArgumentException("Parameter " + this.name + " must be parseable as a float");
            }
        }
        return value;
    }

    @Override
    public int getGrammarElementType() {
        return 2;
    }
}

