/*
 * Decompiled with CFR 0.152.
 */
package org.ucmtwine.parameter.types;

import intradoc.common.ExecutionContext;
import intradoc.data.DataBinder;
import intradoc.data.Workspace;
import intradoc.server.HttpImplementor;
import intradoc.server.PageMerger;
import intradoc.server.Service;
import intradoc.server.ServiceRequestImplementor;
import intradoc.shared.UserData;
import org.ucmtwine.parameter.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectedParameter
extends Parameter {
    public InjectedParameter(String name, Class<?> type) {
        super(name, type);
    }

    @Override
    public Object getBinderValue(Service service) throws IllegalAccessException {
        return this.getInjectedValue(service);
    }

    @Override
    public Object getArgumentValue(Object object, Service service) throws ClassCastException {
        return this.getInjectedValue(service);
    }

    protected Object getInjectedValue(Service service) {
        if (this.type == UserData.class) {
            return service.getUserData();
        }
        if (this.type == PageMerger.class) {
            return service.getPageMerger();
        }
        if (this.type == DataBinder.class) {
            return service.getBinder();
        }
        if (this.type == HttpImplementor.class) {
            return service.getHttpImplementor();
        }
        if (this.type == ServiceRequestImplementor.class) {
            return service.getRequestImplementor();
        }
        if (this.type == Workspace.class) {
            return service.getWorkspace();
        }
        if (ExecutionContext.class.isAssignableFrom(this.type)) {
            return service;
        }
        throw new IllegalStateException("Injectable type " + this.type.getName() + " not known.");
    }

    @Override
    public int getGrammarElementType() {
        return -1;
    }

    public static boolean isValidType(Class<?> type) {
        return type == UserData.class || ExecutionContext.class.isAssignableFrom(type) || type == PageMerger.class || type == DataBinder.class || type == HttpImplementor.class || type == ServiceRequestImplementor.class || type == Workspace.class;
    }
}

