/*
 * Decompiled with CFR 0.152.
 */
package org.ucmtwine.parameter.types;

import intradoc.server.Service;
import org.ucmtwine.parameter.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerParameter
extends Parameter {
    public IntegerParameter(Class<?> type) {
        super(type);
    }

    public IntegerParameter() {
        super(Integer.class);
    }

    public IntegerParameter(String name) {
        super(name, Boolean.class);
    }

    public IntegerParameter(String name, Class<?> type) {
        super(name, type);
    }

    @Override
    public Object getBinderValue(Service service) {
        String integerString = this.getStringValue(service.getBinder());
        return this.parseStringValue(integerString);
    }

    private Object parseStringValue(String integerString) {
        Integer value;
        block2: {
            value = null;
            try {
                value = Integer.parseInt(integerString);
            }
            catch (NumberFormatException e) {
                if (integerString == null) break block2;
                throw new IllegalArgumentException("Parameter " + this.name + " must be parseable as an integer");
            }
        }
        return value;
    }

    @Override
    public Object getArgumentValue(Object object, Service service) throws ClassCastException {
        if (object == null) {
            return null;
        }
        if (object.getClass() == String.class) {
            return this.parseStringValue((String)object);
        }
        return super.getArgumentValue(object, service);
    }

    @Override
    public int getGrammarElementType() {
        return 1;
    }
}

