/*
 * Decompiled with CFR 0.152.
 */
package org.ucmtwine.parameter.types;

import intradoc.provider.Provider;
import intradoc.provider.Providers;
import intradoc.server.Service;
import org.ucmtwine.parameter.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProviderParameter
extends Parameter {
    public ProviderParameter() {
        super("", Provider.class);
    }

    public ProviderParameter(String name) {
        super(name, Provider.class);
    }

    public ProviderParameter(String name, Class<?> type) {
        super(name, type);
    }

    @Override
    public Object getBinderValue(Service service) {
        String providerName = this.getStringValue(service.getBinder());
        Provider provider = Providers.getProvider((String)providerName);
        if (this.required && provider == null) {
            throw new IllegalArgumentException("Provider '" + providerName + "' could not be found.");
        }
        if (provider != null && provider.isInError() && this.required) {
            throw new IllegalArgumentException("The provider '" + providerName + "' is not configured correctly!");
        }
        return provider;
    }

    @Override
    public Object getArgumentValue(Object object, Service service) throws ClassCastException {
        Provider provider;
        if (object instanceof String && (provider = Providers.getProvider((String)((String)object))) != null) {
            return provider;
        }
        return null;
    }

    @Override
    public int getGrammarElementType() {
        return 0;
    }
}

