/*
 * Decompiled with CFR 0.152.
 */
package org.ucmtwine.parameter.types;

import intradoc.data.DataResultSet;
import intradoc.data.ResultSet;
import intradoc.server.Service;
import org.ucmtwine.parameter.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetParameter
extends Parameter {
    public ResultSetParameter() {
        super("", DataResultSet.class);
    }

    public ResultSetParameter(String name) {
        super(name, DataResultSet.class);
    }

    public ResultSetParameter(String name, Class<?> type) {
        super(name, type);
    }

    @Override
    public Object getBinderValue(Service service) {
        DataResultSet drs = this.getResultSet(this.name, service);
        if (this.required && drs == null) {
            throw new IllegalArgumentException("ResultSet " + this.name + " is required.");
        }
        return drs;
    }

    @Override
    public Object getArgumentValue(Object object, Service service) throws ClassCastException {
        DataResultSet drs;
        if (object instanceof String && (drs = this.getResultSet((String)object, service)) != null) {
            return drs;
        }
        return null;
    }

    private DataResultSet getResultSet(String name, Service service) {
        ResultSet rs = service.getBinder().getResultSet(name);
        DataResultSet drs = new DataResultSet();
        if (rs != null) {
            drs.copy(rs);
            return drs;
        }
        return null;
    }

    @Override
    public int getGrammarElementType() {
        return 0;
    }
}

