/*
 * Decompiled with CFR 0.152.
 */
package org.ucmtwine.proxy;

import intradoc.common.ExecutionContext;
import intradoc.common.LocaleUtils;
import intradoc.common.ScriptExtensionsAdaptor;
import intradoc.common.ScriptInfo;
import intradoc.common.ServiceException;
import intradoc.common.SystemUtils;
import intradoc.server.Service;
import intradoc.server.script.ScriptExtensionUtils;
import intradoc.shared.UserData;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import net.balusc.util.ObjectConverter;
import org.ucmtwine.annotation.IdocFunction;
import org.ucmtwine.annotation.IdocVariable;
import org.ucmtwine.parameter.ParameterMarshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptProxy
extends ScriptExtensionsAdaptor {
    private List<Class<?>[]> functionParameterTypes;
    private List<Class<?>[]> variableParameterTypes;
    private List<String> functionMethodNames;
    private List<String> variableMethodNames;
    private Class<?> m_class;
    private Method[] functionMethods;
    public static final int RETURN_VOID = -1;
    public static final int RETURN_STRING = 0;
    public static final int RETURN_BOOLEAN = 1;
    public static final int RETURN_INTEGER = 2;
    public static final int RETURN_FLOAT = 3;
    public static final int NONE = -1;

    public ScriptProxy(Class<?> klass) {
        this.m_class = klass;
        this.generateDefinitions();
    }

    private void generateDefinitions() {
        this.functionParameterTypes = new ArrayList<Class<?>[]>();
        this.functionMethodNames = new ArrayList<String>();
        this.variableParameterTypes = new ArrayList<Class<?>[]>();
        this.variableMethodNames = new ArrayList<String>();
        ArrayList<String> functionNames = new ArrayList<String>();
        ArrayList<ParameterMarshaller> functionParams = new ArrayList<ParameterMarshaller>();
        ArrayList<Integer> functionReturnTypes = new ArrayList<Integer>();
        ArrayList<String> variableNames = new ArrayList<String>();
        ArrayList<Integer> variableReturnTypes = new ArrayList<Integer>();
        Method[] ms = this.m_class.getDeclaredMethods();
        this.functionMethods = new Method[ms.length];
        TreeMap<String, Method> methods = new TreeMap<String, Method>();
        for (Method m : ms) {
            methods.put(m.getName(), m);
        }
        int functionCounter = 0;
        for (String methodName : methods.keySet()) {
            Method m;
            m = (Method)methods.get(methodName);
            IdocFunction functionInfo = m.getAnnotation(IdocFunction.class);
            if (functionInfo != null) {
                if (functionInfo.name().equals("")) {
                    functionNames.add(m.getName());
                } else {
                    functionNames.add(functionInfo.name());
                }
                this.functionMethodNames.add(m.getName());
                this.functionMethods[functionCounter] = m;
                functionParams.add(new ParameterMarshaller(m));
                functionReturnTypes.add(this.getFunctionReturnType(m));
                this.functionParameterTypes.add(m.getParameterTypes());
                ++functionCounter;
                continue;
            }
            IdocVariable varInfo = m.getAnnotation(IdocVariable.class);
            if (varInfo == null) continue;
            if (varInfo.name().equals("")) {
                variableNames.add(m.getName());
            } else {
                variableNames.add(varInfo.name());
            }
            this.variableMethodNames.add(m.getName());
            variableReturnTypes.add(this.getVariableReturnType(m));
            this.variableParameterTypes.add(m.getParameterTypes());
        }
        this.writeVariableTables(variableNames, variableReturnTypes);
        this.writeFunctionTables(functionNames, functionParams, functionReturnTypes);
    }

    private void writeVariableTables(List<String> variableNames, List<Integer> variableReturnTypes) {
        this.m_variableTable = variableNames.toArray(new String[variableNames.size()]);
        this.m_variableDefinitionTable = new int[variableNames.size()][2];
        for (int i = 0; i < variableNames.size(); ++i) {
            this.m_variableDefinitionTable[i][0] = i;
            this.m_variableDefinitionTable[i][1] = variableReturnTypes.get(i);
        }
    }

    private void writeFunctionTables(List<String> functionNames, List<ParameterMarshaller> functionParams, List<Integer> returnTypes) {
        int i;
        this.m_functionTable = functionNames.toArray(new String[functionNames.size()]);
        int maxParams = 0;
        for (i = 0; i < functionParams.size(); ++i) {
            int paramCount = functionParams.get(i).getParameterCount(false);
            if (paramCount <= maxParams) continue;
            maxParams = paramCount;
        }
        this.m_functionDefinitionTable = new int[functionParams.size()][maxParams + 3];
        for (i = 0; i < functionParams.size(); ++i) {
            this.m_functionDefinitionTable[i] = functionParams.get(i).getFunctionDefinitionArray(i, maxParams, returnTypes.get(i));
        }
    }

    public Integer getFunctionReturnType(Method m) {
        Class<?> type = m.getReturnType();
        if (type == Void.class || type == Void.TYPE) {
            return -1;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return 1;
        }
        if (type == Integer.class || type == Integer.TYPE || type == Long.class || type == Long.TYPE) {
            return 2;
        }
        if (type == Float.class || type == Float.TYPE || type == Double.class || type == Double.TYPE) {
            return 3;
        }
        return 0;
    }

    public Integer getVariableReturnType(Method m) {
        if (m.getReturnType() == Boolean.class || m.getReturnType() == Boolean.TYPE) {
            return 1;
        }
        return 0;
    }

    public boolean evaluateFunction(ScriptInfo info, Object[] args, ExecutionContext context) throws ServiceException {
        int[] config = (int[])info.m_entry;
        String functionCalled = info.m_key;
        int functionIndex = config[0];
        int nargs = args.length - 1;
        int allowedParams = config[1];
        if (allowedParams >= 0 && allowedParams != nargs) {
            String msg = LocaleUtils.encodeMessage((String)"csScriptEvalNotEnoughArgs", null, (Object)functionCalled, (Object)("" + allowedParams));
            throw new IllegalArgumentException(msg);
        }
        UserData userData = (UserData)context.getCachedObject("UserData");
        if (userData == null) {
            String msg = LocaleUtils.encodeMessage((String)"csUserDataNotAvailable", null, (Object)functionCalled);
            throw new ServiceException(msg);
        }
        if (functionIndex > this.m_functionTable.length) {
            SystemUtils.trace((String)"twine", (String)("Unknown function with index" + functionIndex));
            return false;
        }
        try {
            args[nargs] = this.runFunctionMethod(functionIndex, args, context);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (e instanceof InvocationTargetException) {
                msg = ((InvocationTargetException)e).getTargetException().getMessage();
            }
            msg = "Unable to execute function '" + functionCalled + "()': " + msg;
            SystemUtils.err((Throwable)e, (String)msg);
            SystemUtils.trace((String)"twine", (String)msg);
            throw new ServiceException((Throwable)e);
        }
        return true;
    }

    public Object[] getInjectedValueArray(Method method, Object[] args, ExecutionContext ctx) throws IllegalArgumentException, ServiceException {
        ParameterMarshaller marshaller = new ParameterMarshaller(method);
        if (!(ctx instanceof Service)) {
            throw new ServiceException("Tried to create parameters with injection and not inside a service.");
        }
        return marshaller.getValueArray(args, (Service)ctx);
    }

    public Object runFunctionMethod(int functionIndex, Object[] args, ExecutionContext ctx) throws SecurityException, NoSuchMethodException, IllegalArgumentException, ServiceException, IllegalAccessException, InvocationTargetException {
        Object result;
        Method method = this.functionMethods[functionIndex];
        Object[] params = this.getInjectedValueArray(method, args, ctx);
        try {
            result = method.invoke(this.m_class.newInstance(), params);
        }
        catch (InstantiationException e) {
            throw new ServiceException("Cannot delegate instantiate script context: " + e.getMessage());
        }
        if (result == null) {
            return result;
        }
        return this.convertReturnValue(result);
    }

    private Object convertReturnValue(Object result) {
        if (Boolean.TYPE.isInstance(result) || result instanceof Boolean) {
            return ScriptExtensionUtils.computeReturnObject((int)1, (boolean)((Boolean)result), (int)0, (double)0.0, null);
        }
        if (Long.TYPE.isInstance(result)) {
            return (Long)result;
        }
        if (Integer.TYPE.isInstance(result) || result instanceof Integer) {
            return new Long(((Integer)result).intValue());
        }
        if (Double.TYPE.isInstance(result)) {
            return (Double)result;
        }
        return result;
    }

    public boolean evaluateValue(ScriptInfo info, boolean[] returnBool, String[] returnString, ExecutionContext context, boolean isConditional) throws ServiceException {
        int[] config = (int[])info.m_entry;
        String key = info.m_key;
        if (!(context instanceof Service)) {
            if (config[1] == 1) {
                returnBool[0] = false;
                returnString[0] = "";
                return true;
            }
            throw new ServiceException("Script variable " + key + " must have be evaluated in " + "context of a Service object.");
        }
        UserData userData = (UserData)context.getCachedObject("UserData");
        if (userData == null) {
            throw new ServiceException("Script variable " + key + " must have user data context.");
        }
        int variableIndex = config[0];
        String variableRequested = this.m_variableTable[variableIndex];
        if (variableIndex > this.m_variableTable.length) {
            return false;
        }
        Object result = null;
        try {
            result = this.runVariableMethod(variableIndex, context);
        }
        catch (Exception e) {
            String msg = "Unable to handle variable " + variableRequested + ": " + e.getMessage();
            SystemUtils.err((Throwable)e, (String)msg);
            SystemUtils.trace((String)"twine", (String)msg);
            throw new ServiceException(msg);
        }
        if (isConditional) {
            returnBool[0] = ObjectConverter.convert(result, Boolean.TYPE);
        } else {
            returnString[0] = ObjectConverter.convert(result, String.class);
        }
        return true;
    }

    public Object runVariableMethod(int variableIndex, ExecutionContext ctx) throws SecurityException, NoSuchMethodException, IllegalArgumentException, ServiceException, IllegalAccessException, InvocationTargetException {
        Object result;
        Method method = this.m_class.getMethod(this.variableMethodNames.get(variableIndex), this.variableParameterTypes.get(variableIndex));
        Object[] args = new Object[]{0};
        Object[] params = this.getInjectedValueArray(method, args, ctx);
        try {
            result = method.invoke(this.m_class.newInstance(), params);
        }
        catch (InstantiationException e) {
            throw new ServiceException("Cannot delegate instantiate script context: " + e.getMessage());
        }
        if (result.getClass() == Boolean.TYPE || result.getClass() == Boolean.class) {
            return ScriptExtensionUtils.computeReturnObject((int)1, (boolean)((Boolean)result), (int)0, (double)0.0, null);
        }
        if (result.getClass() == Integer.class || result.getClass() == Integer.TYPE || result.getClass() == Long.TYPE) {
            return (Long)result;
        }
        if (result.getClass() == Double.TYPE) {
            return (Double)result;
        }
        return result;
    }
}

