/*
 * Decompiled with CFR 0.152.
 */
package org.ucmtwine.proxy.injector;

import intradoc.common.Log;
import intradoc.common.ServiceException;
import intradoc.common.SystemUtils;
import intradoc.data.DataException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.ucmtwine.proxy.injector.IClassInjector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseInjector
implements IClassInjector {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Class<?>> enumerateClasses(URL propertiesFile, String prefix) {
        Properties properties = new Properties();
        InputStream is = null;
        try {
            is = propertiesFile.openStream();
            if (is != null) {
                properties.load(is);
            }
        }
        catch (IOException e) {
            Log.warn((String)e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ignore) {}
            }
        }
        ArrayList classes = new ArrayList();
        if (properties.size() > 0) {
            for (Object key : properties.keySet()) {
                if (!key.toString().startsWith(prefix)) continue;
                try {
                    Class<?> klass = Class.forName(properties.get(key).toString());
                    classes.add(klass);
                }
                catch (ClassNotFoundException e) {
                    Log.warn((String)("Unable to find class [" + properties.get(key).toString() + "]"));
                }
            }
        }
        return classes;
    }

    @Override
    public void injectClasses(List<Class<?>> classes) {
        for (Class<?> klass : classes) {
            try {
                this.inject(klass);
            }
            catch (Exception e) {
                String msg = "Failed to inject: " + klass.getName().toString() + " - " + e.getMessage();
                Log.warn((String)msg);
                SystemUtils.trace((String)"twine", (String)msg);
            }
        }
    }

    @Override
    public void injectClasses(URL propertiesFile, String prefix) {
        List<Class<?>> classes = this.enumerateClasses(propertiesFile, prefix);
        this.injectClasses(classes);
    }

    @Override
    public abstract void injectClasses(URL var1);

    @Override
    public abstract void inject(Class<?> var1) throws DataException, ServiceException;
}

