/*
 * Decompiled with CFR 0.152.
 */
package org.ucmtwine.proxy.injector;

import intradoc.data.DataException;
import intradoc.shared.PluginFilterData;
import intradoc.shared.PluginFilters;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Vector;
import org.ucmtwine.annotation.Filter;
import org.ucmtwine.proxy.FilterProxy;
import org.ucmtwine.proxy.injector.BaseInjector;
import org.ucmtwine.proxy.injector.IClassInjector;
import org.ucmtwine.proxy.injector.MethodRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterInjector
extends BaseInjector
implements IClassInjector {
    @Override
    public void injectClasses(URL propertiesFile) {
        this.injectClasses(propertiesFile, "ucm.filter");
    }

    @Override
    public void inject(Class<?> klass) throws DataException {
        Method[] classMethods;
        for (Method method : classMethods = klass.getMethods()) {
            Filter annotation = method.getAnnotation(Filter.class);
            if (annotation == null) continue;
            this.injectFilterMethod(method, annotation);
        }
    }

    private void injectFilterMethod(Method method, Filter annotation) throws DataException {
        if (annotation == null) {
            throw new DataException("Method [" + method.getName() + "] is not an injectable filter.");
        }
        if (method.getReturnType() != Integer.TYPE && method.getReturnType() != Void.TYPE) {
            throw new DataException("Method [" + method.getName() + "] must have a return type of int or void to be a filter.");
        }
        String methodID = MethodRegistry.addMethod(method);
        if (methodID == null) {
            throw new DataException("Could not generate UUID for method " + method.getName());
        }
        Vector<PluginFilterData> filters = new Vector<PluginFilterData>();
        PluginFilterData filter = new PluginFilterData();
        filter.m_order = annotation.loadOrder();
        filter.m_parameter = methodID;
        filter.m_filterType = annotation.event();
        filter.m_location = FilterProxy.class.getName();
        filters.add(filter);
        PluginFilters.registerFilters(filters);
    }
}

