/*
 * Decompiled with CFR 0.152.
 */
package org.ucmtwine.proxy.injector;

import intradoc.data.DataException;
import intradoc.server.ServiceData;
import intradoc.server.ServiceManager;
import java.lang.reflect.Method;
import java.net.URL;
import org.ucmtwine.annotation.ServiceMethod;
import org.ucmtwine.proxy.ServiceProxy;
import org.ucmtwine.proxy.injector.BaseInjector;
import org.ucmtwine.proxy.injector.MethodRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceInjector
extends BaseInjector {
    @Override
    public void injectClasses(URL propertiesFile) {
        this.injectClasses(propertiesFile, "ucm.service");
    }

    @Override
    public void inject(Class<?> klass) throws DataException {
        Method[] classMethods;
        for (Method method : classMethods = klass.getMethods()) {
            ServiceMethod annotation = method.getAnnotation(ServiceMethod.class);
            if (annotation == null) continue;
            ServiceInjector.injectServiceMethod(method, annotation);
        }
    }

    private static void injectServiceMethod(Method method, ServiceMethod annotation) throws DataException {
        ServiceData serviceData = new ServiceData();
        String template = annotation.template();
        int accessLevel = annotation.accessLevel();
        String serviceType = !annotation.type().equals("") ? annotation.type() : null;
        String errorMessage = annotation.errorMessage();
        String subjects = annotation.subjects();
        String serviceName = annotation.name();
        try {
            serviceData.init(serviceName, ServiceProxy.class.getName(), accessLevel, template, serviceType, errorMessage, subjects);
        }
        catch (Exception e) {
            throw new DataException("Cannot create ServiceData object for " + serviceName + " - " + e.getMessage());
        }
        String controlFlags = "";
        String methodHashCode = MethodRegistry.addMethod(method);
        if (methodHashCode == null) {
            throw new DataException("Cannot register method " + method.toString() + " because it has a null hashCode");
        }
        try {
            serviceData.addAction(3, "delegateWithParameters", methodHashCode, controlFlags, "");
        }
        catch (DataException e) {
            throw new DataException("Cannot add defaut action to service" + serviceName + " - " + e.getMessage());
        }
        ServiceManager.putService((String)serviceName, (ServiceData)serviceData);
    }
}

