/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.config;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.uitnet.testing.smartfwk.ui.core.config.webbrowser.WebBrowserType;

public class ChromeDriverConfig {
    private String driverFilePath;
    private Map<String, String> driverCapabilities;

    public ChromeDriverConfig(String seleniumConfigDir, Properties properties) {
        this.init(seleniumConfigDir, properties);
    }

    private void init(String seleniumConfigDir, Properties properties) {
        this.driverFilePath = properties.getProperty("BROWSER_DRIVER_FILENAME");
        if (this.driverFilePath != null && !"".equals(this.driverFilePath.trim())) {
            this.driverFilePath = seleniumConfigDir + File.separator + "web-drivers" + File.separator + WebBrowserType.chrome.name() + File.separator + this.driverFilePath.trim();
        }
        this.driverCapabilities = new LinkedHashMap<String, String>();
        for (Object key : properties.keySet()) {
            String strKey = (String)key;
            if (!strKey.startsWith("DriverCapability.")) continue;
            this.driverCapabilities.put(strKey.substring("DriverCapability.".length()), properties.getProperty(strKey));
        }
    }

    public String getDriverFilePath() {
        return this.driverFilePath;
    }

    public Map<String, String> getDriverCapabilities() {
        return this.driverCapabilities;
    }
}

