/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.config.webbrowser;

import java.io.File;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Point;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.sikuli.basics.Settings;
import org.sikuli.script.OCR;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.config.AppConfig;
import org.uitnet.testing.smartfwk.ui.core.config.ChromeDriverConfig;
import org.uitnet.testing.smartfwk.ui.core.config.FirefoxDriverConfig;
import org.uitnet.testing.smartfwk.ui.core.config.IEDriverConfig;
import org.uitnet.testing.smartfwk.ui.core.config.ProxyConfiguration;
import org.uitnet.testing.smartfwk.ui.core.config.TestConfigManager;
import org.uitnet.testing.smartfwk.ui.core.config.webbrowser.WebBrowser;
import org.uitnet.testing.smartfwk.ui.core.config.webbrowser.WebBrowserType;

public class WebBrowserFactory {
    private static WebBrowserFactory instance = null;
    private Map<String, WebBrowser> appBrowserMap;
    private TestConfigManager testConfigMgr = TestConfigManager.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WebBrowserFactory getInstance() {
        if (instance != null) return instance;
        Class<WebBrowserFactory> clazz = WebBrowserFactory.class;
        synchronized (WebBrowserFactory.class) {
            if (instance != null) return instance;
            instance = new WebBrowserFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private WebBrowserFactory() {
        this.appBrowserMap = new HashMap<String, WebBrowser>(3);
        this.initializeSikuli();
    }

    protected void initializeSikuli() {
        try {
            Map<String, String> settings = this.testConfigMgr.getSikuliSettings().getAllSettings();
            for (String name : settings.keySet()) {
                String value = settings.get(name);
                Field f = Settings.class.getDeclaredField(name);
                if (f.isAccessible()) {
                    f.set(null, this.createObjectFromTypedValue(name, value));
                    continue;
                }
                f.setAccessible(true);
                f.set(null, this.createObjectFromTypedValue(name, value));
                f.setAccessible(false);
            }
            System.out.println("Sikuli OCRDataPath set to: " + this.testConfigMgr.getSikuliSettings().getOcrDataPath());
            OCR.Options ocrOptions = OCR.globalOptions();
            ocrOptions.dataPath(this.testConfigMgr.getSikuliSettings().getOcrDataPath());
        }
        catch (Throwable th) {
            Assert.fail((String)"Failed to initialize the sikuli driver.", (Throwable)th);
        }
    }

    protected Object createObjectFromTypedValue(String propertyName, String typedValue) {
        String[] typeValueArr = typedValue.split(":");
        Assert.assertTrue((typeValueArr.length > 1 ? 1 : 0) != 0, (String)("typedValue format is wrong for property '" + propertyName + "'. It should be <data-type>:<value>"));
        switch (typeValueArr[0]) {
            case "integer": {
                return Integer.parseInt(typeValueArr[1]);
            }
            case "string": {
                return typeValueArr[1];
            }
            case "float": {
                return Float.valueOf(Float.parseFloat(typeValueArr[1]));
            }
            case "double": {
                return Double.parseDouble(typeValueArr[1]);
            }
            case "boolean": {
                return Boolean.parseBoolean(typeValueArr[1]);
            }
        }
        Assert.fail((String)("'" + typeValueArr[0] + "' datatype is not supported for '" + propertyName + "' property."));
        return null;
    }

    public synchronized WebBrowser getAppWebBrowser(String appName, String browserId) {
        AppConfig appConfig = this.testConfigMgr.getAppConfig(appName);
        WebBrowserType type = appConfig.getAppWebBrowser();
        String loginURL = appConfig.getAppLaunchUrl();
        WebBrowser browser = this.appBrowserMap.get(appName + ":" + browserId);
        try {
            switch (type) {
                case firefox: {
                    FirefoxDriverConfig firefoxDriverCfg = this.testConfigMgr.getFirefoxDriverConfig();
                    System.setProperty("webdriver.gecko.driver", firefoxDriverCfg.getDriverFilePath());
                    if (browser == null) {
                        FirefoxDriver firefoxDriver = null;
                        FirefoxProfile firefoxProfile = new FirefoxProfile(new File(firefoxDriverCfg.getProfilePath()));
                        DesiredCapabilities dc = DesiredCapabilities.firefox();
                        this.applyDriverCapabilities((MutableCapabilities)dc, firefoxDriverCfg.getDriverCapabilities());
                        if (appConfig.isEnableWebBrowserExtension()) {
                            for (String extn : firefoxDriverCfg.getBrowserExtensions().values()) {
                                File firebugExtnFile = new File(extn);
                                firefoxProfile.addExtension(firebugExtnFile);
                            }
                            for (String key : firefoxDriverCfg.getBrowserPrefs().keySet()) {
                                firefoxProfile.setPreference(key, firefoxDriverCfg.getBrowserPrefs().get(key));
                            }
                        }
                        FirefoxOptions options = new FirefoxOptions().setProfile(firefoxProfile).setBinary(new FirefoxBinary());
                        Proxy proxy = this.getProxyInfo(appConfig);
                        if (proxy != null) {
                            options.setCapability("proxy", (Object)proxy);
                        }
                        firefoxDriver = new FirefoxDriver(options);
                        browser = new WebBrowser(browserId, appName, appConfig, this.testConfigMgr, this, (WebDriver)firefoxDriver, type);
                        browser.getSeleniumWebDriver().manage().timeouts().setScriptTimeout(60L, TimeUnit.SECONDS);
                        browser.getSeleniumWebDriver().manage().timeouts().pageLoadTimeout(60L, TimeUnit.SECONDS);
                        browser.getSeleniumWebDriver().manage().window().setSize(new Dimension(new Double(appConfig.getBrowserWindowSize().getWidth()).intValue(), new Double(appConfig.getBrowserWindowSize().getHeight()).intValue()));
                        browser.getSeleniumWebDriver().manage().window().setPosition(new Point(0, 0));
                        browser.getSeleniumWebDriver().navigate().to(loginURL);
                        this.appBrowserMap.put(appName + ":" + browserId, browser);
                        break;
                    }
                    browser.setNewInstance(false);
                    break;
                }
                case chrome: {
                    ChromeDriverConfig chromeDriverCfg = this.testConfigMgr.getChromeDriverConfig();
                    System.setProperty("webdriver.chrome.driver", chromeDriverCfg.getDriverFilePath());
                    if (browser == null) {
                        ChromeDriver chromeDriver = null;
                        ChromeOptions chromeOptions = new ChromeOptions();
                        chromeOptions.addArguments(new String[]{"--ignore-certificate-errors", "--test-type=webdriver", "--disable-notifications", "disable-infobars"});
                        chromeOptions.setExperimentalOption("useAutomationExtension", (Object)false);
                        chromeOptions.setExperimentalOption("excludeSwitches", Collections.singletonList("enable-automation"));
                        chromeDriver = appConfig.isEnableWebBrowserExtension() ? new ChromeDriver(chromeOptions) : new ChromeDriver(chromeOptions);
                        browser = new WebBrowser(browserId, appName, appConfig, this.testConfigMgr, this, (WebDriver)chromeDriver, type);
                        browser.getSeleniumWebDriver().manage().window().setSize(new Dimension(new Double(appConfig.getBrowserWindowSize().getWidth()).intValue(), new Double(appConfig.getBrowserWindowSize().getHeight()).intValue()));
                        browser.getSeleniumWebDriver().manage().window().setPosition(new Point(0, 0));
                        browser.getSeleniumWebDriver().navigate().to(loginURL);
                        this.appBrowserMap.put(appName + ":" + browserId, browser);
                        break;
                    }
                    browser.setNewInstance(false);
                    break;
                }
                case internetExplorer: {
                    IEDriverConfig ieDriverCfg = this.testConfigMgr.getIEDriverConfig();
                    System.setProperty("webdriver.ie.driver", ieDriverCfg.getDriverFilePath());
                    if (browser == null) {
                        InternetExplorerOptions ieOptions = new InternetExplorerOptions();
                        this.applyDriverCapabilities((MutableCapabilities)ieOptions, ieDriverCfg.getDriverCapabilities());
                        ieOptions.setCapability("initialBrowserUrl", loginURL);
                        InternetExplorerDriver ieDriver = null;
                        ieDriver = appConfig.isEnableWebBrowserExtension() ? new InternetExplorerDriver(ieOptions) : new InternetExplorerDriver(ieOptions);
                        browser = new WebBrowser(browserId, appName, appConfig, this.testConfigMgr, this, (WebDriver)ieDriver, type);
                        browser.getSeleniumWebDriver().manage().window().setSize(new Dimension(new Double(appConfig.getBrowserWindowSize().getWidth()).intValue(), new Double(appConfig.getBrowserWindowSize().getHeight()).intValue()));
                        browser.getSeleniumWebDriver().manage().window().setPosition(new Point(0, 0));
                        this.appBrowserMap.put(appName + ":" + browserId, browser);
                        break;
                    }
                    browser.setNewInstance(false);
                    break;
                }
                case remoteWebDriverProvider: {
                    if (browser == null) {
                        RemoteWebDriver webDriver = appConfig.getRemoteWebDriverProvider().createRemoteWebDriver();
                        browser = new WebBrowser(browserId, appName, appConfig, this.testConfigMgr, this, (WebDriver)webDriver, type);
                        browser.getSeleniumWebDriver().manage().window().setPosition(new Point(0, 0));
                        browser.getSeleniumWebDriver().manage().window().setSize(new Dimension(new Double(appConfig.getBrowserWindowSize().getWidth()).intValue(), new Double(appConfig.getBrowserWindowSize().getHeight()).intValue()));
                        browser.getSeleniumWebDriver().navigate().to(loginURL);
                        this.appBrowserMap.put(appName + ":" + browserId, browser);
                        break;
                    }
                    browser.setNewInstance(false);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Web browser '" + (Object)((Object)type) + "' is not supported.");
                }
            }
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to initialize " + type.name() + " web browser. Going to exit... "), (Throwable)ex);
            System.exit(1);
        }
        return browser;
    }

    public void destroyAppWebBrowser(String appName, String browserId) {
        WebBrowser browser = this.appBrowserMap.get(appName + ":" + browserId);
        if (browser != null) {
            browser.getSeleniumWebDriver().quit();
            this.appBrowserMap.remove(appName + ":" + browserId);
        }
    }

    public void destroyAllWebBrowser(String appName) {
        LinkedList<String> remBrowsers = new LinkedList<String>();
        for (String browser : this.appBrowserMap.keySet()) {
            if (!browser.startsWith(appName)) continue;
            remBrowsers.add(browser);
        }
        for (String browser : remBrowsers) {
            this.appBrowserMap.get(browser).getSeleniumWebDriver().quit();
            this.appBrowserMap.remove(browser);
        }
    }

    public void destroyAllWebBrowser() {
        LinkedList<String> remBrowsers = new LinkedList<String>();
        for (String browser : this.appBrowserMap.keySet()) {
            remBrowsers.add(browser);
        }
        for (String browser : remBrowsers) {
            this.appBrowserMap.get(browser).getSeleniumWebDriver().quit();
            this.appBrowserMap.remove(browser);
        }
    }

    private Proxy getProxyInfo(AppConfig appConfig) {
        ProxyConfiguration proxyConfig = appConfig.getProxyConfig();
        Proxy proxy = new Proxy();
        switch (proxyConfig.getProxyConfigType()) {
            case NO_PROXY: {
                proxy = null;
                break;
            }
            case AUTO_DETECT: {
                proxy.setProxyType(Proxy.ProxyType.AUTODETECT);
                proxy.setAutodetect(true);
                break;
            }
            case USE_SYSTEM_PROXY: {
                proxy.setProxyType(Proxy.ProxyType.SYSTEM);
                break;
            }
            case MANUAL_PROXY: {
                proxy.setProxyType(Proxy.ProxyType.MANUAL);
                proxy.setHttpProxy(proxyConfig.getHttpProxyHostname() + ":" + proxyConfig.getHttpProxyPort());
                proxy.setSslProxy(proxyConfig.getSslProxyHostname() + ":" + proxyConfig.getSslProxyPort());
                proxy.setFtpProxy(proxyConfig.getFtpProxyHostname() + ":" + proxyConfig.getFtpProxyPort());
                proxy.setSocksProxy(proxyConfig.getSocksHostname() + ":" + proxyConfig.getSocksPort());
                proxy.setSocksUsername(proxyConfig.getSocksUsername());
                proxy.setSocksPassword(proxyConfig.getSocksPassword());
                proxy.setNoProxy(proxyConfig.getNoProxyFor());
            }
        }
        return proxy;
    }

    private void applyDriverCapabilities(MutableCapabilities capabilities, Map<String, String> config) {
        Iterator<String> iterator = config.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            String strKey = key = iterator.next();
            String value = config.get(strKey);
            String[] typedValue = value.split(":");
            switch (typedValue[0]) {
                case "boolean": {
                    capabilities.setCapability(strKey, Boolean.parseBoolean(typedValue[1].trim()));
                    break;
                }
                case "string": {
                    capabilities.setCapability(strKey, typedValue[1].trim());
                    break;
                }
                case "integer": {
                    capabilities.setCapability(strKey, (Object)Integer.parseInt(typedValue[1].trim()));
                    break;
                }
                case "float": {
                    capabilities.setCapability(strKey, (Object)Float.valueOf(Float.parseFloat(typedValue[1].trim())));
                    break;
                }
                case "double": {
                    capabilities.setCapability(strKey, (Object)Double.parseDouble(typedValue[1].trim()));
                }
            }
        }
    }
}

