/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.objects;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.openqa.selenium.Keys;
import org.sikuli.script.Button;
import org.sikuli.script.Location;
import org.sikuli.script.Match;
import org.sikuli.script.Region;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.commons.ImageSection;
import org.uitnet.testing.smartfwk.ui.core.config.webbrowser.WebBrowser;
import org.uitnet.testing.smartfwk.ui.core.objects.ImageObject;
import org.uitnet.testing.smartfwk.ui.core.objects.NewTextLocation;
import org.uitnet.testing.smartfwk.ui.core.objects.UIObjectValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.scrollbar.Scrollbar;
import org.uitnet.testing.smartfwk.ui.core.objects.validator.mechanisms.TextValidationMechanism;
import org.uitnet.testing.smartfwk.ui.core.utils.ClipboardUtil;

public class ImageObjectValidator
extends UIObjectValidator {
    protected ImageObject imgLocator;

    public ImageObjectValidator(WebBrowser browser, ImageObject locator, Region region) {
        super(browser, locator, region);
        this.imgLocator = locator;
    }

    @Override
    public ImageObject getUIObject() {
        return this.imgLocator;
    }

    public Match findElement(int numRetries) {
        Match match = null;
        for (int i = 0; i <= numRetries; ++i) {
            try {
                match = this.region.find((Object)this.imgLocator.getImage());
                Assert.assertNotNull((Object)match, (String)("Unable to find element '" + this.imgLocator.getDisplayName() + "'."));
                break;
            }
            catch (Throwable th) {
                if (i == numRetries) {
                    Assert.fail((String)("Unable to find element '" + this.imgLocator.getDisplayName() + "'. Reason timeout(waited for " + numRetries * 2 + " seconds)."), (Throwable)th);
                    break;
                }
                this.browser.waitForSeconds(2);
                continue;
            }
        }
        return match;
    }

    public Match findElementNoException(int numRetries) {
        Match match = null;
        for (int i = 0; i <= numRetries; ++i) {
            block4: {
                try {
                    match = this.region.find((Object)this.imgLocator.getImage());
                    if (match != null) {
                    }
                    break block4;
                }
                catch (Throwable th) {
                    match = null;
                    if (i != numRetries) break block4;
                }
                break;
            }
            this.browser.waitForSeconds(2);
        }
        return match;
    }

    @Override
    public List<Match> findElements(int numRetries) {
        LinkedList<Match> list = new LinkedList<Match>();
        for (int i = 0; i <= numRetries; ++i) {
            try {
                Iterator matches = this.region.findAll((Object)this.imgLocator.getImage());
                Assert.assertNotNull((Object)matches, (String)("Unable to find elements for '" + this.imgLocator.getDisplayName() + "'."));
                while (matches.hasNext()) {
                    list.add((Match)matches.next());
                }
                Assert.assertTrue((list.size() > 0 ? 1 : 0) != 0, (String)("Unable to find elements for '" + this.imgLocator.getDisplayName() + "' locator."));
                break;
            }
            catch (Throwable th) {
                if (i == numRetries) {
                    Assert.fail((String)("Unable to find elements for '" + this.uiObject.getDisplayName() + "' locator. Reason timeout(waited for " + numRetries * 2 + " seconds)."), (Throwable)th);
                    break;
                }
                this.browser.waitForSeconds(2);
                continue;
            }
        }
        return list;
    }

    @Override
    public ImageObjectValidator scrollElementOnViewport(Scrollbar scrollbar) {
        if (scrollbar == null) {
            return this;
        }
        return this;
    }

    @Override
    public boolean isPresent(int numRetries) {
        boolean elemPresent = false;
        Match match = null;
        match = this.findElementNoException(numRetries);
        if (match != null) {
            elemPresent = true;
        }
        return elemPresent;
    }

    @Override
    public boolean isVisible(int numRetries) {
        return this.isPresent(numRetries);
    }

    @Override
    public void click(int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.click();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse click on element '" + this.imgLocator.getDisplayName() + "'."), (Throwable)th);
        }
    }

    protected Location getImageSection(Match imageMatch, ImageSection imageSection) {
        switch (imageSection) {
            case topLeft: {
                return imageMatch.getTopLeft();
            }
            case topRight: {
                return imageMatch.getTopRight();
            }
            case bottomLeft: {
                return imageMatch.getBottomLeft();
            }
            case bottomRight: {
                return imageMatch.getBottomRight();
            }
            case center: {
                return imageMatch.getCenter();
            }
        }
        return null;
    }

    public void click(ImageSection imageSection, int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            this.getImageSection(match, imageSection).click();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse click on element '" + this.imgLocator.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void doubleClick(int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.doubleClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse double click on element '" + this.imgLocator.getDisplayName() + "'."), (Throwable)th);
        }
    }

    public void doubleClick(ImageSection imageSection, int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            this.getImageSection(match, imageSection).doubleClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse double click on element '" + this.imgLocator.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void rightClick(int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.rightClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse right click on element '" + this.imgLocator.getDisplayName() + "'."), (Throwable)th);
        }
    }

    public void rightClick(ImageSection imageSection, int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            this.getImageSection(match, imageSection).rightClick();
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse right click on element '" + this.imgLocator.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void clickAndHold(int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.mouseDown(Button.LEFT);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse clickAndHold on element '" + this.imgLocator.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void release(int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.mouseUp(Button.LEFT);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform mouse release on element '" + this.imgLocator.getDisplayName() + "'."), (Throwable)th);
        }
    }

    public void dragAndDrop(ImageObject target, Region targetRegion, int numRetries) {
        try {
            Match sourceElem = this.findElement(numRetries);
            Match targetElem = target.getValidator(this.browser, targetRegion).findElement(numRetries);
            Assert.assertNotNull((Object)sourceElem, (String)("Failed to find element '" + this.imgLocator.getDisplayName() + "'."));
            Assert.assertNotNull((Object)targetElem, (String)("Failed to find element '" + target.getDisplayName() + "'."));
            sourceElem.dropAt((Object)targetElem);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform dragAndDrop from source '" + this.imgLocator.getDisplayName() + "' to target '" + target.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void performKeyDown(Keys keys, int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.click();
            match.keyDown(this.seleniumToSikuliKeyConverter(keys));
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform keyDown('" + this.seleniumToSikuliKeyConverter(keys) + "') on element '" + this.imgLocator.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void performKeyUp(Keys keys, int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.click();
            match.keyUp(this.seleniumToSikuliKeyConverter(keys));
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform keyUp ('" + this.seleniumToSikuliKeyConverter(keys) + "') on element '" + this.imgLocator.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void performKeyPressed(Keys keys, int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.click();
            match.keyDown(this.seleniumToSikuliKeyConverter(keys));
            match.keyUp(this.seleniumToSikuliKeyConverter(keys));
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform keyPressed ('" + this.seleniumToSikuliKeyConverter(keys) + "') on element '" + this.imgLocator.getDisplayName() + "'."), (Throwable)th);
        }
    }

    @Override
    public void typeText(String text, NewTextLocation location, int numRetries) {
        try {
            Match match = this.findElement(numRetries);
            match.click();
            switch (location) {
                case start: {
                    match.type("\ue008");
                    break;
                }
                case end: {
                    match.type("\ue007");
                    break;
                }
                case replace: {
                    match.type("a", 2);
                }
            }
            match.type(text);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to perform keyPressed on element '" + this.imgLocator.getDisplayName() + "'."), (Throwable)th);
        }
    }

    public void validateValue(String expectedValue, TextValidationMechanism validationMechanism, int numRetries) {
        Match match = this.findElement(numRetries);
        this.validateTextValue(match.text(), expectedValue, validationMechanism);
    }

    public String getText(int numRetries) {
        Match match = this.findElement(numRetries);
        return match.text();
    }

    public String getEditableFieldTextUsingClipboard(int numRetries) {
        Match match = this.findElement(numRetries);
        match.click();
        match.type("a", 2);
        match.type("c", 2);
        match.click();
        String contents = ClipboardUtil.getContents();
        ClipboardUtil.clearContents();
        return contents;
    }
}

