/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.standard.domobj;

import java.util.LinkedList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.sikuli.script.Region;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.commons.ItemList;
import org.uitnet.testing.smartfwk.ui.core.config.webbrowser.WebBrowser;
import org.uitnet.testing.smartfwk.ui.core.objects.DOMObject;
import org.uitnet.testing.smartfwk.ui.core.objects.DOMObjectValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.NewTextLocation;
import org.uitnet.testing.smartfwk.ui.core.objects.listbox.ListBoxValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.scrollbar.Scrollbar;
import org.uitnet.testing.smartfwk.ui.core.objects.validator.mechanisms.TextValidationMechanism;
import org.uitnet.testing.smartfwk.ui.standard.domobj.ListBoxSD;

public class ListBoxValidatorSD
extends ListBoxValidator {
    protected DOMObjectValidator domObjValidator;

    public ListBoxValidatorSD(WebBrowser browser, ListBoxSD uiObject, Region region) {
        super(browser, uiObject, region);
        this.domObjValidator = new DOMObjectValidator(browser, new DOMObject(uiObject.getDisplayName(), uiObject.getLocatorXPath()), region);
    }

    @Override
    public void validateDisabled(int numRetries) {
        Assert.assertTrue((boolean)this.domObjValidator.isDisabled(numRetries), (String)("'" + this.uiObject.getDisplayName() + "' element is not disabled."));
    }

    @Override
    public void validateEnabled(int numRetries) {
        Assert.assertFalse((boolean)this.domObjValidator.isDisabled(numRetries), (String)("'" + this.uiObject.getDisplayName() + "' element is not enabled."));
    }

    @Override
    public void typeText(String textToType, NewTextLocation location, int numRetries) {
        this.domObjValidator.typeText(textToType, location, numRetries);
    }

    @Override
    public boolean isPresent(int numRetries) {
        return this.domObjValidator.isPresent(numRetries);
    }

    @Override
    public boolean isVisible(int numRetries) {
        return this.domObjValidator.isVisible(numRetries);
    }

    @Override
    public void click(int numRetries) {
        this.domObjValidator.click(numRetries);
    }

    @Override
    public void doubleClick(int numRetries) {
        this.domObjValidator.doubleClick(numRetries);
    }

    @Override
    public void rightClick(int numRetries) {
        this.domObjValidator.rightClick(numRetries);
    }

    @Override
    public void clickAndHold(int numRetries) {
        this.domObjValidator.clickAndHold(numRetries);
    }

    @Override
    public void release(int numRetries) {
        this.domObjValidator.release(numRetries);
    }

    @Override
    public void performKeyDown(Keys keys, int numRetries) {
        this.domObjValidator.performKeyDown(keys, numRetries);
    }

    @Override
    public void performKeyUp(Keys keys, int numRetries) {
        this.domObjValidator.performKeyUp(keys, numRetries);
    }

    @Override
    public void performKeyPressed(Keys keys, int numRetries) {
        this.domObjValidator.performKeyPressed(keys, numRetries);
    }

    @Override
    public ListBoxValidatorSD scrollElementOnViewport(Scrollbar scrollbar) {
        this.domObjValidator.scrollElementOnViewport(scrollbar);
        return this;
    }

    @Override
    public void validateSelectedItem(String expectedSelectedValue, TextValidationMechanism validationMechanism, int numRetries) {
        WebElement selectElement = this.domObjValidator.findElement(numRetries);
        List options = selectElement.findElements(By.xpath((String)"./option"));
        Assert.assertNotNull((Object)options, (String)("Failed to find items for ListBox '" + this.uiObject.getDisplayName() + "'."));
        Assert.assertTrue((options.size() > 0 ? 1 : 0) != 0, (String)("Failed to find items in ListBox '" + this.uiObject.getDisplayName() + "'. Found 0 items."));
        boolean found = false;
        for (WebElement option : options) {
            String optionTextValue = option.getText();
            if (optionTextValue == null || !option.isSelected() || !this.matchTextValue(optionTextValue.trim(), expectedSelectedValue, validationMechanism)) continue;
            found = true;
            break;
        }
        if (!found) {
            Assert.fail((String)("Failed to find selected item '" + expectedSelectedValue + "' in ListBox '" + this.uiObject.getDisplayName() + "'."));
        }
    }

    @Override
    public String getSelectedItem(int numRetries) {
        WebElement selectElement = this.domObjValidator.findElement(numRetries);
        List options = selectElement.findElements(By.xpath((String)"./option"));
        Assert.assertNotNull((Object)options, (String)("Failed to find items for ListBox '" + this.uiObject.getDisplayName() + "'."));
        Assert.assertTrue((options.size() > 0 ? 1 : 0) != 0, (String)("Failed to find items in ListBox '" + this.uiObject.getDisplayName() + "'. Found 0 items."));
        for (WebElement option : options) {
            String optionTextValue = option.getText();
            if (optionTextValue == null || !option.isSelected()) continue;
            return optionTextValue;
        }
        return null;
    }

    @Override
    public List<String> getSelectedItems(int numRetries) {
        WebElement selectElement = this.domObjValidator.findElement(numRetries);
        List options = selectElement.findElements(By.xpath((String)"./option"));
        Assert.assertNotNull((Object)options, (String)("Failed to find items for ListBox '" + this.uiObject.getDisplayName() + "'."));
        Assert.assertTrue((options.size() > 0 ? 1 : 0) != 0, (String)("Failed to find items in ListBox '" + this.uiObject.getDisplayName() + "'. Found 0 items."));
        LinkedList<String> selectedItems = new LinkedList<String>();
        for (WebElement option : options) {
            String optionTextValue = option.getText();
            if (optionTextValue == null || !option.isSelected()) continue;
            selectedItems.add(optionTextValue);
        }
        return selectedItems;
    }

    @Override
    public void selectFirstItem(int numRetries) {
        WebElement selectElement = this.domObjValidator.findElement(numRetries);
        List options = selectElement.findElements(By.xpath((String)"./option"));
        Assert.assertNotNull((Object)options, (String)("Failed to find items for ListBox '" + this.uiObject.getDisplayName() + "'."));
        Assert.assertTrue((options.size() > 0 ? 1 : 0) != 0, (String)("Failed to find items in ListBox '" + this.uiObject.getDisplayName() + "'. Found 0 items."));
        ((WebElement)options.get(0)).click();
    }

    @Override
    public void selectLastItem(int numRetries) {
        WebElement selectElement = this.domObjValidator.findElement(numRetries);
        List options = selectElement.findElements(By.xpath((String)"./option"));
        Assert.assertNotNull((Object)options, (String)("Failed to find items for ListBox '" + this.uiObject.getDisplayName() + "'."));
        Assert.assertTrue((options.size() > 0 ? 1 : 0) != 0, (String)("Failed to find items in ListBox '" + this.uiObject.getDisplayName() + "'. Found 0 items."));
        ((WebElement)options.get(options.size() - 1)).click();
    }

    @Override
    public void selectItem(String itemName, int numRetries) {
        WebElement selectElement = this.domObjValidator.findElement(numRetries);
        List options = selectElement.findElements(By.xpath((String)"./option"));
        Assert.assertNotNull((Object)options, (String)("Failed to find items for ListBox '" + this.uiObject.getDisplayName() + "'."));
        boolean found = false;
        for (WebElement option : options) {
            String optionTextValue = option.getText();
            if (optionTextValue != null && itemName.equals(optionTextValue.trim())) {
                if (!option.isSelected()) {
                    option.click();
                }
                found = true;
                continue;
            }
            if (!option.isSelected()) continue;
            option.click();
        }
        if (!found) {
            Assert.fail((String)("Failed to find item '" + itemName + "' in ListBox '" + this.uiObject.getDisplayName() + "'."));
        }
    }

    @Override
    public void selectItems(ItemList<String> itemsToBeSelected, int numRetries) {
        WebElement selectElement = this.domObjValidator.findElement(numRetries);
        List options = selectElement.findElements(By.xpath((String)"./option"));
        Assert.assertNotNull((Object)options, (String)("Failed to find items for ListBox '" + this.uiObject.getDisplayName() + "'."));
        LinkedList<String> foundItemList = new LinkedList<String>();
        for (WebElement option : options) {
            String optionTextValue = option.getText();
            if (optionTextValue == null || !itemsToBeSelected.getItems().contains(optionTextValue.trim())) continue;
            option.click();
            foundItemList.add(optionTextValue.trim());
        }
        if (foundItemList.size() != itemsToBeSelected.size()) {
            itemsToBeSelected.removeAll(foundItemList);
            Assert.fail((String)("Failed to find item(s) '" + itemsToBeSelected + "' in ListBox '" + this.uiObject.getDisplayName() + "'."));
        }
    }

    @Override
    public void validateItemsPresent(ItemList<String> items, int numRetries) {
        WebElement selectElement = this.domObjValidator.findElement(numRetries);
        List options = selectElement.findElements(By.xpath((String)"./option"));
        Assert.assertNotNull((Object)options, (String)("Failed to find items for ListBox '" + this.uiObject.getDisplayName() + "'."));
        Assert.assertTrue((options.size() > 0 ? 1 : 0) != 0, (String)("Failed to find items in ListBox '" + this.uiObject.getDisplayName() + "'. Found 0 items."));
        for (String item : items.getItems()) {
            boolean found = false;
            for (WebElement option : options) {
                String optionTextValue = option.getText();
                if (optionTextValue == null || !this.matchTextValue(optionTextValue.trim(), item, TextValidationMechanism.exactMatchWithExpectedValue)) continue;
                found = true;
                break;
            }
            if (found) continue;
            Assert.fail((String)("Failed to find item '" + item + "' in ListBox '" + this.uiObject.getDisplayName() + "'."));
        }
    }

    @Override
    public void validateItemsNotPresent(ItemList<String> items, int numRetries) {
        WebElement selectElement = this.domObjValidator.findElement(numRetries);
        List options = selectElement.findElements(By.xpath((String)"./option"));
        Assert.assertNotNull((Object)options, (String)("Failed to find items for ListBox '" + this.uiObject.getDisplayName() + "'."));
        Assert.assertTrue((options.size() > 0 ? 1 : 0) != 0, (String)("Failed to find items in ListBox '" + this.uiObject.getDisplayName() + "'. Found 0 items."));
        for (String item : items.getItems()) {
            boolean found = false;
            for (WebElement option : options) {
                String optionTextValue = option.getText();
                if (optionTextValue == null || !this.matchTextValue(optionTextValue.trim(), item, TextValidationMechanism.exactMatchWithExpectedValue)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            Assert.fail((String)("Item '" + item + "' is present in ListBox '" + this.uiObject.getDisplayName() + "'."));
        }
    }

    public WebElement findElement(int numRetries) {
        return this.domObjValidator.findElement(numRetries);
    }

    public WebElement findElementNoException(int numRetries) {
        return this.domObjValidator.findElementNoException(numRetries);
    }

    @Override
    public List<WebElement> findElements(int numRetries) {
        return this.domObjValidator.findElements(numRetries);
    }
}

