/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core;

import io.cucumber.java.Scenario;
import java.awt.Point;
import java.awt.Rectangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.config.AppConfig;
import org.uitnet.testing.smartfwk.ui.core.config.TestConfigManager;
import org.uitnet.testing.smartfwk.ui.core.config.UserProfile;
import org.uitnet.testing.smartfwk.ui.core.config.database.orm.OrmDatabaseQueryHandler;
import org.uitnet.testing.smartfwk.ui.core.config.webbrowser.WebBrowser;
import org.uitnet.testing.smartfwk.ui.core.objects.logon.LoginPageValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.logon.LoginSuccessPageValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.webpage.WebPage;
import org.uitnet.testing.smartfwk.ui.core.utils.ScreenCaptureUtil;

public abstract class AbstractUITestHelper {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected boolean logonTest = false;
    protected TestConfigManager testConfigManager = TestConfigManager.getInstance();
    protected String initAppName;
    protected String initUserProfileName;
    protected String initWebBrowserId;
    protected static WebBrowser initWebBrowser;
    protected WebPage initWebPage;
    protected AppConfig initAppConfig;
    protected UserProfile initUserProfile;
    protected String activeUserProfileName;

    protected AbstractUITestHelper() {
    }

    public void init(String appName, String webBrowserId, WebPage webPage, String userProfileName) {
        this.initAppConfig = this.testConfigManager.getAppConfig(appName);
        if (userProfileName == null || "".equals(userProfileName.trim())) {
            this.initUserProfileName = "";
            this.activeUserProfileName = "";
        } else {
            this.initUserProfileName = userProfileName;
            this.activeUserProfileName = userProfileName;
            this.initUserProfile = this.testConfigManager.getAppConfig(appName).getUserProfile(userProfileName);
        }
        this.initAppName = appName;
        this.initWebPage = webPage;
        this.initWebBrowserId = webBrowserId;
    }

    public void scenarioSetup() {
    }

    public void scenarioTearDown() {
    }

    public String getInitAppName() {
        return this.initAppName;
    }

    public String getInitUserProfileName() {
        return this.initUserProfileName;
    }

    protected LoginPageValidator createNewLoginPageValidator(WebBrowser browser) {
        String loginPageValidatorCls = this.testConfigManager.getAppConfig(browser.getAppName()).getAppLoginPageValidatorClass();
        LoginPageValidator loginPageValidator = null;
        try {
            loginPageValidator = (LoginPageValidator)Class.forName(loginPageValidatorCls).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            loginPageValidator.setInitParams(browser);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to load login page validator class '" + loginPageValidatorCls + "'."), (Throwable)th);
        }
        return loginPageValidator;
    }

    protected LoginSuccessPageValidator createNewLoginSuccessPageValidator(WebBrowser browser) {
        String loginSuccessPageValidatorCls = this.testConfigManager.getAppConfig(browser.getAppName()).getAppLoginSuccessPageValidatorClass();
        LoginSuccessPageValidator loginSuccessPageValidator = null;
        try {
            loginSuccessPageValidator = (LoginSuccessPageValidator)Class.forName(loginSuccessPageValidatorCls).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            loginSuccessPageValidator.setInitParams(browser);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to load login page validator class '" + loginSuccessPageValidatorCls + "'."), (Throwable)th);
        }
        return loginSuccessPageValidator;
    }

    public void checkLogoutAndLoginAgain(String userProfileName) {
        initWebBrowser = this.testConfigManager.getWebBrowser(this.initAppName, this.initWebBrowserId);
        LoginPageValidator loginPageValidator = this.createNewLoginPageValidator(initWebBrowser);
        LoginSuccessPageValidator loginSuccessPageValidator = this.createNewLoginSuccessPageValidator(initWebBrowser);
        if (loginPageValidator.isLoginPageVisible(userProfileName)) {
            loginPageValidator.login(userProfileName);
            loginSuccessPageValidator.validate(userProfileName);
        } else if (!loginSuccessPageValidator.isLoginSuccessPageVisible(userProfileName)) {
            loginPageValidator.login(userProfileName);
            loginSuccessPageValidator.validate(userProfileName);
        }
        if (this.initWebPage != null) {
            this.initWebPage.getValidator(initWebBrowser, null).openWebPage();
        }
    }

    public TestConfigManager getTestConfigManager() {
        return TestConfigManager.getInstance();
    }

    public AppConfig getAppConfig(String appName) {
        return this.testConfigManager.getAppConfig(appName);
    }

    public String getActiveUserProfileName() {
        return this.activeUserProfileName;
    }

    public void setActiveUserProfileName(String userProfileName) {
        if (!this.activeUserProfileName.equals(userProfileName)) {
            this.relogin(userProfileName);
            this.activeUserProfileName = userProfileName;
        } else {
            this.checkLogoutAndLoginAgain(userProfileName);
            this.activeUserProfileName = userProfileName;
        }
    }

    private void relogin(String userProfileName) {
        this.logoutAndNoQuit();
        this.checkLogoutAndLoginAgain(userProfileName);
    }

    public void relogin() {
        this.logoutAndNoQuit();
        this.checkLogoutAndLoginAgain(this.activeUserProfileName);
    }

    public void logoutAndNoQuit() {
        initWebBrowser = this.testConfigManager.getWebBrowser(this.initAppName, this.initWebBrowserId);
        LoginPageValidator loginPageValidator = this.createNewLoginPageValidator(initWebBrowser);
        LoginSuccessPageValidator loginSuccessPageValidator = this.createNewLoginSuccessPageValidator(initWebBrowser);
        if (loginSuccessPageValidator.isLoginSuccessPageVisible(this.activeUserProfileName)) {
            loginSuccessPageValidator.logout(this.activeUserProfileName);
            loginPageValidator.validate(this.activeUserProfileName);
        }
    }

    public void logoutAndQuit() {
        this.logoutAndNoQuit();
        initWebBrowser.quit();
    }

    public WebBrowser getInitWebBrowser() {
        return initWebBrowser;
    }

    public WebPage getInitWebPage() {
        return this.initWebPage;
    }

    public OrmDatabaseQueryHandler getDatabaseQueryHandler(String appName, String dbProfileName) {
        return this.testConfigManager.getDatabaseQueryHandler(appName, dbProfileName);
    }

    public void captureScreenshot(Scenario scenario) {
        String fileNameHint = this.prepareScreenshotFileName(scenario) + "-" + scenario.getStatus();
        Rectangle screenArea = null;
        if (initWebBrowser != null) {
            screenArea = new Rectangle(new Point(0, 0), initWebBrowser.getWindowSize());
        }
        ScreenCaptureUtil.capture(this.testConfigManager.getAppScreenCaptureDirectory(), null, fileNameHint, screenArea);
    }

    public void captureScreenshot(Scenario scenario, String status) {
        String fileNameHint = this.prepareScreenshotFileName(scenario);
        if (status != null) {
            fileNameHint = fileNameHint + "-" + status;
        }
        Rectangle screenArea = null;
        if (initWebBrowser != null) {
            screenArea = new Rectangle(new Point(0, 0), initWebBrowser.getWindowSize());
        }
        ScreenCaptureUtil.capture(this.testConfigManager.getAppScreenCaptureDirectory(), null, fileNameHint, screenArea);
    }

    public void captureScreenshot(String fileNameHint) {
        Rectangle screenArea = null;
        if (initWebBrowser != null) {
            screenArea = new Rectangle(new Point(0, 0), initWebBrowser.getWindowSize());
        }
        ScreenCaptureUtil.capture(this.testConfigManager.getAppScreenCaptureDirectory(), null, fileNameHint, screenArea);
    }

    private String prepareScreenshotFileName(Scenario scenario) {
        String[] idParts = scenario.getId().split("/");
        String fileName = idParts[idParts.length - 1].replace(".", "-").replace(":", "-ScenarioLine(") + ")";
        return fileName;
    }
}

