/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.config;

import java.awt.Dimension;
import java.io.File;
import java.io.FileReader;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.config.ApiConfig;
import org.uitnet.testing.smartfwk.ui.core.config.DatabaseProfile;
import org.uitnet.testing.smartfwk.ui.core.config.ProxyConfiguration;
import org.uitnet.testing.smartfwk.ui.core.config.UserProfile;
import org.uitnet.testing.smartfwk.ui.core.config.webbrowser.RemoteWebDriverProvider;
import org.uitnet.testing.smartfwk.ui.core.config.webbrowser.WebBrowserType;
import org.uitnet.testing.smartfwk.ui.core.utils.ScreenCaptureUtil;

public class AppConfig {
    private String appName;
    private String appConfigDir;
    private String appLaunchUrl;
    private String appLoginPageValidatorClass;
    private String appLoginSuccessPageValidatorClass;
    private String remoteWebDriverProviderClass;
    private RemoteWebDriverProvider remoteWebDriverProvider;
    private WebBrowserType appWebBrowser;
    private boolean enableWebBrowserExtension;
    private Dimension browserWindowSize;
    private String userProfileConfigDir;
    private Map<String, UserProfile> userProfiles;
    private String dbProfileConfigDir;
    private Map<String, DatabaseProfile> dbProfiles;
    private ProxyConfiguration proxyConfig;
    private Map<String, String> additionalProps;
    private ApiConfig apiConfig;

    public AppConfig(String appName, Properties properties, String appConfigDir) {
        this.appName = appName;
        this.appConfigDir = appConfigDir;
        this.userProfiles = new LinkedHashMap<String, UserProfile>();
        this.dbProfiles = new LinkedHashMap<String, DatabaseProfile>();
        this.additionalProps = new LinkedHashMap<String, String>();
        this.initAppConfig(appName, properties);
    }

    private void initAppConfig(String appName, Properties properties) {
        String[] arr;
        String propValue = properties.getProperty("APPLICATION_NAME");
        if (propValue == null || !appName.equals(propValue.trim())) {
            Assert.fail((String)("FATAL: Application name '" + propValue + "' specified in file is not same as configured in TestConfig.properties file '" + appName + "'. Exiting ..."));
            System.exit(1);
        }
        this.appLaunchUrl = properties.getProperty("APP_LAUNCH_URL");
        if (this.appLaunchUrl == null || "".equals(this.appLaunchUrl.trim())) {
            Assert.fail((String)("FATAL: Please specify APP_LAUNCH_URL in AppConfig.properties. AppName: " + appName + ". Exiting ..."));
            System.exit(1);
        } else {
            this.appLaunchUrl = this.appLaunchUrl.trim();
        }
        this.appLoginPageValidatorClass = properties.getProperty("APP_LOGIN_PAGE_VALIDATOR_CLASS");
        if (this.appLoginPageValidatorClass == null || "".equals(this.appLoginPageValidatorClass.trim())) {
            Assert.fail((String)("FATAL: Please specify APP_LOGIN_PAGE_VALIDATOR_CLASS in AppConfig.properties. AppName: " + appName + ". Exiting ..."));
            System.exit(1);
        } else {
            this.appLoginPageValidatorClass = this.appLoginPageValidatorClass.trim();
        }
        this.appLoginSuccessPageValidatorClass = properties.getProperty("APP_LOGIN_SUCCESS_PAGE_VALIDATOR_CLASS");
        if (this.appLoginSuccessPageValidatorClass == null || "".equals(this.appLoginSuccessPageValidatorClass.trim())) {
            Assert.fail((String)("FATAL: Please specify APP_LOGIN_SUCCESS_PAGE_VALIDATOR_CLASS in AppConfig.properties. AppName: " + appName + ". Exiting ..."));
            System.exit(1);
        } else {
            this.appLoginSuccessPageValidatorClass = this.appLoginSuccessPageValidatorClass.trim();
        }
        propValue = properties.getProperty("APP_WEB_BROWSER");
        if (propValue == null || "".equals(propValue.trim())) {
            Assert.fail((String)("FATAL: Please specify APP_WEB_BROWSER in AppConfig.properties. AppName: " + appName + ". Exiting ..."));
            System.exit(1);
        } else {
            this.appWebBrowser = WebBrowserType.valueOf(propValue.trim());
        }
        propValue = properties.getProperty("ENABLE_BROWSER_EXTENSIONS");
        if (propValue == null || "".equals(propValue.trim())) {
            Assert.fail((String)("FATAL: Please specify ENABLE_BROWSER_EXTENSIONS in AppConfig.properties. AppName: " + appName + ". Exiting ..."));
            System.exit(1);
        } else {
            this.enableWebBrowserExtension = Boolean.valueOf(propValue.trim());
        }
        propValue = properties.getProperty("BROWSER_WINDOW_SIZE");
        if (propValue == null || "".equals(propValue.trim()) || !propValue.contains("x")) {
            Assert.fail((String)("FATAL: Please specify correct BROWSER_WINDOW_SIZE in AppConfig.properties. AppName: " + appName + ". Exiting ..."));
            System.exit(1);
        } else {
            String[] wh = propValue.split("x");
            try {
                int browserWidth = Integer.parseInt(wh[0].trim());
                int browserHeight = Integer.parseInt(wh[1].trim());
                Dimension screenSize = ScreenCaptureUtil.getScreenSize();
                if ((double)browserWidth > screenSize.getWidth()) {
                    Assert.fail((String)("FATAL: please specify the BROWSER_WINDOW_SIZE(browserWidth) <= screenWidth in AppConfig.properties. AppName: " + appName + ". Exiting ..."));
                    System.exit(1);
                } else if ((double)browserHeight > screenSize.getHeight()) {
                    Assert.fail((String)("FATAL: please specify the BROWSER_WINDOW_SIZE(browserHeight) <= screenHeight in AppConfig.properties. AppName: " + appName + ". Exiting ..."));
                    System.exit(1);
                }
                this.browserWindowSize = new Dimension(browserWidth, browserHeight);
            }
            catch (Exception ex) {
                Assert.fail((String)("FATAL: Please specify correct BROWSER_WINDOW_SIZE in AppConfig.properties. AppName: " + appName + ". Exiting ..."));
                System.exit(1);
            }
        }
        this.userProfileConfigDir = properties.getProperty("USER_PROFILE_CONFIG_DIR");
        if (this.userProfileConfigDir == null || "".equals(this.userProfileConfigDir.trim())) {
            Assert.fail((String)("FATAL: Please specify USER_PROFILE_CONFIG_DIR in AppConfig.properties. AppName: " + appName + ". Exiting ..."));
            System.exit(1);
        } else {
            this.userProfileConfigDir = this.appConfigDir + File.separator + appName + File.separator + this.userProfileConfigDir.trim();
        }
        propValue = properties.getProperty("USER_PROFILE_NAMES");
        if (propValue == null || "".equals(propValue.trim())) {
            Assert.fail((String)("FATAL: Please specify USER_PROFILE_NAMES in AppConfig.properties. AppName: " + appName + ". Exiting ..."));
            System.exit(1);
        } else {
            String[] browserHeight = arr = propValue.split(",");
            int screenSize = browserHeight.length;
            for (int i = 0; i < screenSize; ++i) {
                String item = browserHeight[i];
                String keyStr = item.trim();
                if ("".equals(keyStr)) continue;
                this.userProfiles.put(keyStr, null);
            }
            if (this.userProfiles.size() == 0) {
                Assert.fail((String)("FATAL: Please specify atleast one user profile (USER_PROFILE_NAMES) in AppConfig.properties. AppName: " + appName + ". Exiting ..."));
                System.exit(1);
            }
            this.initUserProfiles();
        }
        this.dbProfileConfigDir = properties.getProperty("DB_PROFILE_CONFIG_DIR");
        if (this.dbProfileConfigDir != null && !"".equals(this.dbProfileConfigDir.trim())) {
            this.dbProfileConfigDir = this.appConfigDir + File.separator + appName + File.separator + this.dbProfileConfigDir.trim();
        }
        if ((propValue = properties.getProperty("DB_PROFILE_NAMES")) != null && !"".equals(propValue.trim())) {
            for (String item : arr = propValue.split(",")) {
                String keyStr = item.trim();
                if ("".equals(keyStr)) continue;
                this.dbProfiles.put(keyStr, null);
            }
            this.initDatabaseProfiles();
        }
        this.proxyConfig = new ProxyConfiguration(appName, properties);
        for (Object key : properties.keySet()) {
            String keyStr = String.valueOf(key);
            if (!keyStr.startsWith("_")) continue;
            this.additionalProps.put(keyStr, properties.getProperty(keyStr));
        }
        this.remoteWebDriverProviderClass = properties.getProperty("REMOTE_WEB_DRIVER_PROVIDER_CLASS");
        if (this.remoteWebDriverProviderClass == null || "".equals(this.remoteWebDriverProviderClass.trim())) {
            this.remoteWebDriverProviderClass = null;
        } else {
            this.remoteWebDriverProviderClass = this.remoteWebDriverProviderClass.trim();
            try {
                this.remoteWebDriverProvider = (RemoteWebDriverProvider)Class.forName(this.remoteWebDriverProviderClass).newInstance();
                this.remoteWebDriverProvider.setAppConfig(this);
            }
            catch (Exception ex) {
                Assert.fail((String)("Failed to instantiate remote web driver class '" + this.remoteWebDriverProviderClass + "' defined in application '" + appName + "'."), (Throwable)ex);
            }
        }
        String apiConfigFile = this.appConfigDir + File.separator + this.appName + File.separator + "ApiConfig.properties";
        Properties apiConfigProps = new Properties();
        try (FileReader fr = new FileReader(apiConfigFile);){
            apiConfigProps.load(fr);
            this.apiConfig = new ApiConfig(apiConfigFile, apiConfigProps);
        }
        catch (Exception ex) {
            Assert.fail((String)("Failed to load ApiConfig.properties file for application '" + this.appName + "'."), (Throwable)ex);
        }
    }

    public ApiConfig getApiConfig() {
        return this.apiConfig;
    }

    private void initUserProfiles() {
        String currProfileName = null;
        try {
            Iterator<String> iterator = this.userProfiles.keySet().iterator();
            while (iterator.hasNext()) {
                String profileName;
                currProfileName = profileName = iterator.next();
                String configFile = this.userProfileConfigDir + File.separator + currProfileName + ".properties";
                FileReader fileReader = new FileReader(configFile);
                Properties properties = new Properties();
                properties.load(fileReader);
                fileReader.close();
                UserProfile userProfile = new UserProfile(this.appName, currProfileName, properties);
                this.userProfiles.put(currProfileName, userProfile);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("Error in loading user profile '" + currProfileName + ".properties' for application name '" + this.appName + "'. Going to exit..."), (Throwable)ex);
            System.exit(1);
        }
    }

    private void initDatabaseProfiles() {
        String currProfileName = null;
        try {
            Iterator<String> iterator = this.dbProfiles.keySet().iterator();
            while (iterator.hasNext()) {
                String profileName;
                currProfileName = profileName = iterator.next();
                String configFile = this.dbProfileConfigDir + File.separator + currProfileName + ".xml";
                DatabaseProfile dbProfile = new DatabaseProfile(this.appName, currProfileName, configFile);
                this.dbProfiles.put(currProfileName, dbProfile);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)("Error in loading database profile '" + currProfileName + ".properties' for application name '" + this.appName + "'. Going to exit..."), (Throwable)ex);
            System.exit(1);
        }
    }

    public String getName() {
        return this.appName;
    }

    public String getAppLaunchUrl() {
        return this.appLaunchUrl;
    }

    public String getAppLoginPageValidatorClass() {
        return this.appLoginPageValidatorClass;
    }

    public String getAppLoginSuccessPageValidatorClass() {
        return this.appLoginSuccessPageValidatorClass;
    }

    public String getRemoteWebDriverProviderClass() {
        return this.remoteWebDriverProviderClass;
    }

    public RemoteWebDriverProvider getRemoteWebDriverProvider() {
        return this.remoteWebDriverProvider;
    }

    public WebBrowserType getAppWebBrowser() {
        return this.appWebBrowser;
    }

    public boolean isEnableWebBrowserExtension() {
        return this.enableWebBrowserExtension;
    }

    public Dimension getBrowserWindowSize() {
        return this.browserWindowSize;
    }

    public String getUserProfileConfigDir() {
        return this.userProfileConfigDir;
    }

    public String getDbProfileConfigDir() {
        return this.dbProfileConfigDir;
    }

    public ProxyConfiguration getProxyConfig() {
        return this.proxyConfig;
    }

    public UserProfile getUserProfile(String profileName) {
        UserProfile profile = this.userProfiles.get(profileName);
        Assert.assertNotNull((Object)profile, (String)("Please configure user profile '" + profileName + "' for application '" + this.appName + "'."));
        return profile;
    }

    public DatabaseProfile getDatabaseProfile(String profileName) {
        DatabaseProfile profile = this.dbProfiles.get(profileName);
        Assert.assertNotNull((Object)profile, (String)("Please configure database profile '" + profileName + "' for application '" + this.appName + "'."));
        return profile;
    }

    public String getAdditionalPropertyValue(String propName) {
        Assert.assertTrue((boolean)this.additionalProps.containsKey(propName), (String)("Please specify the additional property '" + propName + "' in application '" + this.appName + "' AppConfig.properties file."));
        return this.additionalProps.get(propName);
    }
}

