/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.config;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.uitnet.testing.smartfwk.ui.core.config.webbrowser.WebBrowserType;

public class FirefoxDriverConfig {
    private String profilePath;
    private String driverFilePath;
    private Map<String, String> browserExtensions = new HashMap<String, String>(3);
    private Map<String, String> browserPreferences = new HashMap<String, String>(3);
    private Map<String, String> driverCapabilities;

    public FirefoxDriverConfig(String seleniumConfigDir, Properties properties) {
        this.init(seleniumConfigDir, properties);
    }

    private void init(String seleniumConfigDir, Properties properties) {
        this.driverFilePath = properties.getProperty("BROWSER_DRIVER_FILENAME");
        if (this.driverFilePath != null && !"".equals(this.driverFilePath.trim())) {
            this.driverFilePath = seleniumConfigDir + File.separator + "web-drivers" + File.separator + WebBrowserType.firefox.name() + File.separator + this.driverFilePath.trim();
        }
        this.profilePath = seleniumConfigDir + File.separator + "web-drivers" + File.separator + WebBrowserType.firefox.name() + File.separator + "profile";
        for (Object key : properties.keySet()) {
            String prop = String.valueOf(key).trim();
            String propValue = properties.getProperty(String.valueOf(key));
            if (prop.startsWith("BROWSER-EXT_")) {
                this.browserExtensions.put(prop.substring("BROWSER-EXT_".length()), seleniumConfigDir + File.separator + "web-drivers" + File.separator + WebBrowserType.firefox.name() + File.separator + "extensions" + File.separator + propValue);
            }
            if (!prop.startsWith("BROWSER-PREF_")) continue;
            this.browserPreferences.put(prop.substring("BROWSER-PREF_".length()), propValue);
        }
        this.driverCapabilities = new LinkedHashMap<String, String>();
        for (Object key : properties.keySet()) {
            String strKey = (String)key;
            if (!strKey.startsWith("DriverCapability.")) continue;
            this.driverCapabilities.put(strKey.substring("DriverCapability.".length()), properties.getProperty(strKey));
        }
    }

    public String getProfilePath() {
        return this.profilePath;
    }

    public String getDriverFilePath() {
        return this.driverFilePath;
    }

    public Map<String, String> getBrowserExtensions() {
        return this.browserExtensions;
    }

    public Map<String, String> getBrowserPrefs() {
        return this.browserPreferences;
    }

    public Map<String, String> getDriverCapabilities() {
        return this.driverCapabilities;
    }
}

