/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.objects;

import java.awt.Rectangle;
import org.openqa.selenium.Keys;
import org.sikuli.script.Region;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.commons.UIObjectType;
import org.uitnet.testing.smartfwk.ui.core.config.webbrowser.WebBrowser;
import org.uitnet.testing.smartfwk.ui.core.events.InputEvent;
import org.uitnet.testing.smartfwk.ui.core.events.InputEventType;
import org.uitnet.testing.smartfwk.ui.core.events.KeyboardEvent;
import org.uitnet.testing.smartfwk.ui.core.events.KeyboardEventName;
import org.uitnet.testing.smartfwk.ui.core.events.MouseEvent;
import org.uitnet.testing.smartfwk.ui.core.events.MouseEventName;
import org.uitnet.testing.smartfwk.ui.core.objects.NewTextLocation;
import org.uitnet.testing.smartfwk.ui.core.objects.UIObject;
import org.uitnet.testing.smartfwk.ui.core.objects.scrollbar.Scrollbar;
import org.uitnet.testing.smartfwk.ui.core.objects.validator.mechanisms.TextValidationMechanism;
import org.uitnet.testing.smartfwk.ui.core.utils.DataMatchUtil;

public abstract class UIObjectValidator {
    protected WebBrowser browser;
    protected UIObject uiObject;
    protected Region region;

    public UIObjectValidator(WebBrowser browser, UIObject uiObject, Region region) {
        this.browser = browser;
        this.uiObject = uiObject;
        if (browser != null) {
            this.region = region == null ? Region.create((Rectangle)new Rectangle(0, 0, new Double(browser.getAppConfig().getBrowserWindowSize().getWidth()).intValue(), new Double(browser.getAppConfig().getBrowserWindowSize().getHeight()).intValue())) : region;
        }
    }

    public UIObject getUIObject() {
        return this.uiObject;
    }

    public UIObjectType geUIObjectType() {
        return this.uiObject.getType();
    }

    public Region getRegion() {
        return this.region;
    }

    public void validatePresent(int numRetries) {
        Assert.assertTrue((boolean)this.isPresent(numRetries), (String)("Failed to find element '" + this.uiObject.getDisplayName() + "'"));
    }

    public void validateNotPresent(int numRetries) {
        Assert.assertTrue((!this.isPresent(numRetries) ? 1 : 0) != 0, (String)("Element '" + this.uiObject.getDisplayName() + "' is already present."));
    }

    public <EVENTNAME> void performAction(InputEvent<EVENTNAME> event, int numRetries) {
        if (event.getType() == InputEventType.mouse) {
            MouseEvent mouseEvent = (MouseEvent)event;
            switch ((MouseEventName)((Object)mouseEvent.getName())) {
                case mouseClick: {
                    this.click(numRetries);
                    break;
                }
                case mouseRightClick: {
                    this.rightClick(numRetries);
                    break;
                }
                case mouseDoubleClick: {
                    this.doubleClick(numRetries);
                    break;
                }
                case mouseClickAndHold: {
                    this.clickAndHold(numRetries);
                    break;
                }
                case mouseRelease: {
                    this.release(numRetries);
                }
            }
        } else if (event.getType() == InputEventType.keyBoard) {
            KeyboardEvent kbEvent = (KeyboardEvent)event;
            switch ((KeyboardEventName)((Object)kbEvent.getName())) {
                case kbKeyDown: {
                    if (kbEvent.getInputText() != null) {
                        this.typeText(kbEvent.getInputText(), kbEvent.getTextLocation(), numRetries);
                    }
                    this.performKeyDown(kbEvent.getKey(), numRetries);
                    break;
                }
                case kbKeyUp: {
                    if (kbEvent.getInputText() != null) {
                        this.typeText(kbEvent.getInputText(), kbEvent.getTextLocation(), numRetries);
                    }
                    this.performKeyUp(kbEvent.getKey(), numRetries);
                    break;
                }
                case keyPressed: {
                    if (kbEvent.getInputText() != null) {
                        this.typeText(kbEvent.getInputText(), kbEvent.getTextLocation(), numRetries);
                    }
                    this.performKeyPressed(kbEvent.getKey(), numRetries);
                }
            }
        }
    }

    protected boolean matchTextValue(String actualValue, String expectedValue, TextValidationMechanism validationMechanism) {
        return DataMatchUtil.matchTextValue(actualValue, expectedValue, validationMechanism);
    }

    protected void validateTextValue(String actualValue, String expectedValue, TextValidationMechanism validationMechanism) {
        DataMatchUtil.validateTextValue(actualValue, expectedValue, validationMechanism);
    }

    public String seleniumToSikuliKeyConverter(Keys key) {
        switch (key.name()) {
            case "HOME": {
                return "\ue008";
            }
            case "END": {
                return "\ue007";
            }
            case "TAB": {
                return "\t";
            }
            case "BACK_SPACE": {
                return "\b";
            }
            case "RETURN": {
                return "\r";
            }
            case "ENTER": {
                return "\r";
            }
            case "SHIFT": {
                return "\ue020";
            }
            case "CONTROL": {
                return "\ue021";
            }
            case "ALT": {
                return "\ue022";
            }
            case "ESCAPE": {
                return "\u001b";
            }
            case "SPACE": {
                return " ";
            }
            case "PAGE_UP": {
                return "\ue004";
            }
            case "PAGE_DOWN": {
                return "\ue005";
            }
            case "LEFT": 
            case "ARROW_LEFT": {
                return "\ue003";
            }
            case "UP": 
            case "ARROW_UP": {
                return "\ue000";
            }
            case "RIGHT": 
            case "ARROW_RIGHT": {
                return "\ue001";
            }
            case "DOWN": 
            case "ARROW_DOWN": {
                return "\ue002";
            }
            case "INSERT": {
                return "\ue009";
            }
            case "DELETE": {
                return "\ue006";
            }
            case "SEMICOLON": {
                return ";";
            }
            case "F1": {
                return "\ue011";
            }
            case "F2": {
                return "\ue012";
            }
            case "F3": {
                return "\ue013";
            }
            case "F4": {
                return "\ue014";
            }
            case "F5": {
                return "\ue015";
            }
            case "F6": {
                return "\ue016";
            }
            case "F7": {
                return "\ue017";
            }
            case "F8": {
                return "\ue018";
            }
            case "F9": {
                return "\ue019";
            }
            case "F10": {
                return "\ue01a";
            }
            case "F11": {
                return "\ue01b";
            }
            case "F12": {
                return "\ue01c";
            }
            case "META": {
                return "\ue023";
            }
            case "COMMAND": {
                return "\ue023";
            }
        }
        return null;
    }

    public abstract boolean isPresent(int var1);

    public abstract boolean isVisible(int var1);

    public abstract void click(int var1);

    public abstract void doubleClick(int var1);

    public abstract void rightClick(int var1);

    public abstract void clickAndHold(int var1);

    public abstract void release(int var1);

    public abstract void performKeyDown(Keys var1, int var2);

    public abstract void performKeyUp(Keys var1, int var2);

    public abstract void performKeyPressed(Keys var1, int var2);

    public abstract void typeText(String var1, NewTextLocation var2, int var3);

    public abstract UIObjectValidator scrollElementOnViewport(Scrollbar var1);

    public abstract Object findElement(int var1);

    public abstract Object findElementNoException(int var1);

    public abstract Object findElements(int var1);
}

