/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.utils;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.testng.Assert;

public class ScreenCaptureUtil {
    private static int screenshotId = 0;

    public static Dimension getScreenSize() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    public static void capture(String dir, String testClassName, String testCaseName, Rectangle screenArea) {
        try {
            Rectangle screenRectangle = screenArea;
            if (screenArea == null) {
                Dimension screenSize = ScreenCaptureUtil.getScreenSize();
                screenRectangle = new Rectangle(screenSize);
            }
            Robot robot = new Robot();
            BufferedImage image = robot.createScreenCapture(screenRectangle);
            File dirObj = new File(dir);
            if (!dirObj.exists()) {
                dirObj.mkdirs();
            }
            String imageFile = null;
            imageFile = testClassName == null ? dir + File.separator + testCaseName + "-" + ScreenCaptureUtil.getNextScreenshotId() + ".png" : dir + File.separator + testClassName + "-" + testCaseName + "-" + ScreenCaptureUtil.getNextScreenshotId() + ".png";
            ImageIO.write((RenderedImage)image, "png", new File(imageFile));
        }
        catch (Exception ex) {
            Assert.fail((String)"Failed to take screenshot.", (Throwable)ex);
        }
    }

    private static synchronized int getNextScreenshotId() {
        return ++screenshotId;
    }
}

