/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.core.config.webbrowser;

import java.awt.Dimension;
import org.openqa.selenium.WebDriver;
import org.sikuli.script.Screen;
import org.uitnet.testing.smartfwk.ui.core.config.AppConfig;
import org.uitnet.testing.smartfwk.ui.core.config.TestConfigManager;
import org.uitnet.testing.smartfwk.ui.core.config.webbrowser.WebBrowserFactory;
import org.uitnet.testing.smartfwk.ui.core.config.webbrowser.WebBrowserType;

public class WebBrowser {
    private String appName;
    private String id;
    private WebDriver seleniumWebDriver;
    private boolean newInstance;
    private WebBrowserType type;
    private WebBrowserFactory browserFactory;
    private Screen sikuliDriver;
    private AppConfig appConfig;
    private TestConfigManager testCfgMgr;

    public WebBrowser(String id, String appName, AppConfig appConfig, TestConfigManager testCfgMgr, WebBrowserFactory factory, WebDriver seleniumWebDriver, WebBrowserType type) {
        this.id = id;
        this.appName = appName;
        this.appConfig = appConfig;
        this.testCfgMgr = testCfgMgr;
        this.browserFactory = factory;
        this.seleniumWebDriver = seleniumWebDriver;
        this.type = type;
        this.sikuliDriver = new Screen();
        this.newInstance = true;
    }

    public Dimension getWindowSize() {
        return this.appConfig.getBrowserWindowSize();
    }

    public String getAppName() {
        return this.appName;
    }

    public AppConfig getAppConfig() {
        return this.appConfig;
    }

    public TestConfigManager getTestConfigManager() {
        return this.testCfgMgr;
    }

    public String getId() {
        return this.id;
    }

    public WebDriver getSeleniumWebDriver() {
        return this.seleniumWebDriver;
    }

    public WebBrowserType getWebBrowserType() {
        return this.type;
    }

    public Screen getSikuliScreen() {
        return this.sikuliDriver;
    }

    public void openURL(String url) {
        this.seleniumWebDriver.navigate().to(url);
    }

    public void openDefaultURL() {
        this.openURL(this.appConfig.getAppLaunchUrl());
    }

    public boolean isNewInstance() {
        return this.newInstance;
    }

    public void setNewInstance(boolean newInstance) {
        if (this.newInstance != newInstance) {
            this.newInstance = newInstance;
        }
    }

    public void waitForMilliSeconds(long milliSeconds) {
        try {
            Thread.sleep(milliSeconds);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void waitForSeconds(int seconds) {
        try {
            Thread.sleep(seconds * 1000);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getOSName() {
        return System.getProperty("os.name");
    }

    public String getOSShortName() {
        String osName = this.getOSName();
        if (osName != null) {
            return osName.trim().split(" ")[0];
        }
        return null;
    }

    public void refresh() {
        this.seleniumWebDriver.navigate().refresh();
    }

    public void setFocus() {
        this.seleniumWebDriver.switchTo().window(this.seleniumWebDriver.getWindowHandle());
    }

    public void quit() {
        this.browserFactory.destroyAppWebBrowser(this.appName, this.id);
    }
}

