/*
 * Decompiled with CFR 0.152.
 */
package org.uitnet.testing.smartfwk.ui.standard.domobj;

import java.util.List;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.sikuli.script.Region;
import org.testng.Assert;
import org.uitnet.testing.smartfwk.ui.core.config.webbrowser.WebBrowser;
import org.uitnet.testing.smartfwk.ui.core.objects.DOMObject;
import org.uitnet.testing.smartfwk.ui.core.objects.DOMObjectValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.NewTextLocation;
import org.uitnet.testing.smartfwk.ui.core.objects.checkbox.CheckBoxValidator;
import org.uitnet.testing.smartfwk.ui.core.objects.scrollbar.Scrollbar;
import org.uitnet.testing.smartfwk.ui.standard.domobj.CheckBoxSD;

public class CheckBoxValidatorSD
extends CheckBoxValidator {
    protected DOMObjectValidator domObjValidator;

    public CheckBoxValidatorSD(WebBrowser browser, CheckBoxSD uiObject, Region region) {
        super(browser, uiObject, region);
        this.domObjValidator = new DOMObjectValidator(browser, new DOMObject(uiObject.getDisplayName(), uiObject.getLocatorXPath()), region);
    }

    public DOMObjectValidator getDOMObjectValidator() {
        return this.domObjValidator;
    }

    @Override
    public void typeText(String textToType, NewTextLocation location, int numRetries) {
        this.domObjValidator.typeText(textToType, location, numRetries);
    }

    @Override
    public boolean isPresent(int numRetries) {
        return this.domObjValidator.isPresent(numRetries);
    }

    @Override
    public boolean isVisible(int numRetries) {
        return this.domObjValidator.isVisible(numRetries);
    }

    @Override
    public void click(int numRetries) {
        this.domObjValidator.click(numRetries);
    }

    @Override
    public void doubleClick(int numRetries) {
        this.domObjValidator.doubleClick(numRetries);
    }

    @Override
    public void rightClick(int numRetries) {
        this.domObjValidator.rightClick(numRetries);
    }

    @Override
    public void clickAndHold(int numRetries) {
        this.domObjValidator.clickAndHold(numRetries);
    }

    @Override
    public void release(int numRetries) {
        this.domObjValidator.release(numRetries);
    }

    @Override
    public void performKeyDown(Keys keys, int numRetries) {
        this.domObjValidator.performKeyDown(keys, numRetries);
    }

    @Override
    public void performKeyUp(Keys keys, int numRetries) {
        this.domObjValidator.performKeyUp(keys, numRetries);
    }

    @Override
    public void performKeyPressed(Keys keys, int numRetries) {
        this.domObjValidator.performKeyPressed(keys, numRetries);
    }

    @Override
    public CheckBoxValidatorSD scrollElementOnViewport(Scrollbar scrollbar) {
        this.domObjValidator.scrollElementOnViewport(scrollbar);
        return this;
    }

    @Override
    public boolean isCheckBoxChecked(int numRetries) {
        WebElement webElem = this.findElement(numRetries);
        return webElem.isSelected();
    }

    @Override
    public void validateCheckBoxChecked(int numRetries) {
        Assert.assertTrue((boolean)this.isCheckBoxChecked(numRetries), (String)("Checkbox '" + this.uiObject.getDisplayName() + "' is not checked."));
    }

    @Override
    public void validateCheckBoxUnchecked(int numRetries) {
        Assert.assertFalse((boolean)this.isCheckBoxChecked(numRetries), (String)("Checkbox '" + this.uiObject.getDisplayName() + "' is checked."));
    }

    @Override
    public void checkAndValidateChecked(int numRetries) {
        WebElement webElem = this.findElement(numRetries);
        webElem.click();
        try {
            this.validateCheckBoxChecked(numRetries);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to check the Checkbox '" + this.uiObject.getDisplayName() + "'."));
        }
    }

    @Override
    public void uncheckAndValidateUnchecked(int numRetries) {
        WebElement webElem = this.findElement(numRetries);
        webElem.click();
        try {
            this.validateCheckBoxUnchecked(numRetries);
        }
        catch (Throwable th) {
            Assert.fail((String)("Failed to uncheck the Checkbox '" + this.uiObject.getDisplayName() + "'."));
        }
    }

    public WebElement findElement(int numRetries) {
        return this.domObjValidator.findElement(numRetries);
    }

    public WebElement findElementNoException(int numRetries) {
        return this.domObjValidator.findElementNoException(numRetries);
    }

    @Override
    public List<WebElement> findElements(int numRetries) {
        return this.domObjValidator.findElements(numRetries);
    }
}

